/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.modification;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.opendaylight.controller.cluster.datastore.modification.AbstractModification;
import org.opendaylight.controller.cluster.datastore.node.utils.stream.SerializationUtils;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreWriteTransaction;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModification;

public class WriteModification
extends AbstractModification {
    private static final long serialVersionUID = 1L;
    private NormalizedNode<?, ?> data;
    private static final SerializationUtils.Applier<WriteModification> APPLIER = (instance, path, node) -> {
        instance.setPath(path);
        instance.data = node;
    };

    public WriteModification() {
        this(9);
    }

    public WriteModification(short version) {
        super(version);
    }

    public WriteModification(YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
        super(path);
        this.data = data;
    }

    @Override
    public void apply(DOMStoreWriteTransaction transaction) {
        transaction.write(this.getPath(), this.data);
    }

    @Override
    public void apply(DataTreeModification transaction) {
        transaction.write(this.getPath(), this.data);
    }

    public NormalizedNode<?, ?> getData() {
        return this.data;
    }

    @Override
    public byte getType() {
        return 2;
    }

    @Override
    public void readExternal(ObjectInput in) {
        SerializationUtils.deserializePathAndNode((DataInput)in, (Object)this, APPLIER);
    }

    @Override
    public void writeExternal(ObjectOutput out) {
        SerializationUtils.serializePathAndNode((YangInstanceIdentifier)this.getPath(), this.data, (DataOutput)out);
    }

    public static WriteModification fromStream(ObjectInput in, short version) {
        WriteModification mod = new WriteModification(version);
        mod.readExternal(in);
        return mod;
    }
}

