/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.persisted;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.persisted.AbstractIdentifiablePayload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PurgeTransactionPayload
extends AbstractIdentifiablePayload<TransactionIdentifier> {
    private static final Logger LOG = LoggerFactory.getLogger(PurgeTransactionPayload.class);
    private static final long serialVersionUID = 1L;

    PurgeTransactionPayload(TransactionIdentifier transactionId, byte[] serialized) {
        super(transactionId, serialized);
    }

    public static PurgeTransactionPayload create(TransactionIdentifier transactionId, int initialSerializedBufferCapacity) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput((int)initialSerializedBufferCapacity);
        try {
            transactionId.writeTo((DataOutput)out);
        }
        catch (IOException e) {
            LOG.error("Failed to serialize {}", (Object)transactionId, (Object)e);
            throw new RuntimeException("Failed to serialize " + transactionId, e);
        }
        return new PurgeTransactionPayload(transactionId, out.toByteArray());
    }

    protected Proxy externalizableProxy(byte[] serialized) {
        return new Proxy(serialized);
    }

    private static final class Proxy
    extends AbstractIdentifiablePayload.AbstractProxy<TransactionIdentifier> {
        private static final long serialVersionUID = 1L;

        public Proxy() {
        }

        Proxy(byte[] serialized) {
            super(serialized);
        }

        @Override
        protected TransactionIdentifier readIdentifier(DataInput in) throws IOException {
            return TransactionIdentifier.readFrom((DataInput)in);
        }

        protected PurgeTransactionPayload createObject(TransactionIdentifier identifier, byte[] serialized) {
            return new PurgeTransactionPayload(identifier, serialized);
        }
    }
}

