/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.shardmanager;

import akka.actor.Props;
import com.google.common.base.Preconditions;
import java.util.concurrent.CountDownLatch;
import org.opendaylight.controller.cluster.datastore.AbstractDataStore;
import org.opendaylight.controller.cluster.datastore.ClusterWrapper;
import org.opendaylight.controller.cluster.datastore.DatastoreContextFactory;
import org.opendaylight.controller.cluster.datastore.config.Configuration;
import org.opendaylight.controller.cluster.datastore.persisted.DatastoreSnapshot;
import org.opendaylight.controller.cluster.datastore.shardmanager.ShardManager;
import org.opendaylight.controller.cluster.datastore.utils.PrimaryShardInfoFutureCache;

public abstract class AbstractShardManagerCreator<T extends AbstractShardManagerCreator<T>> {
    private ClusterWrapper cluster;
    private Configuration configuration;
    private DatastoreContextFactory datastoreContextFactory;
    private AbstractDataStore distributedDataStore;
    private CountDownLatch waitTillReadyCountDownLatch;
    private PrimaryShardInfoFutureCache primaryShardInfoCache;
    private DatastoreSnapshot restoreFromSnapshot;
    private volatile boolean sealed;

    AbstractShardManagerCreator() {
    }

    private T self() {
        return (T)this;
    }

    protected final void checkSealed() {
        Preconditions.checkState((!this.sealed ? 1 : 0) != 0, (Object)"Builder is already sealed - further modifications are not allowed");
    }

    ClusterWrapper getCluster() {
        return this.cluster;
    }

    public T cluster(ClusterWrapper newCluster) {
        this.checkSealed();
        this.cluster = newCluster;
        return this.self();
    }

    Configuration getConfiguration() {
        return this.configuration;
    }

    public T configuration(Configuration newConfiguration) {
        this.checkSealed();
        this.configuration = newConfiguration;
        return this.self();
    }

    DatastoreContextFactory getDatastoreContextFactory() {
        return this.datastoreContextFactory;
    }

    public T datastoreContextFactory(DatastoreContextFactory newDatastoreContextFactory) {
        this.checkSealed();
        this.datastoreContextFactory = (DatastoreContextFactory)Preconditions.checkNotNull((Object)newDatastoreContextFactory);
        return this.self();
    }

    AbstractDataStore getDistributedDataStore() {
        return this.distributedDataStore;
    }

    public T distributedDataStore(AbstractDataStore newDistributedDataStore) {
        this.checkSealed();
        this.distributedDataStore = newDistributedDataStore;
        return this.self();
    }

    CountDownLatch getWaitTillReadyCountDownLatch() {
        return this.waitTillReadyCountDownLatch;
    }

    public T waitTillReadyCountDownLatch(CountDownLatch newWaitTillReadyCountDownLatch) {
        this.checkSealed();
        this.waitTillReadyCountDownLatch = newWaitTillReadyCountDownLatch;
        return this.self();
    }

    PrimaryShardInfoFutureCache getPrimaryShardInfoCache() {
        return this.primaryShardInfoCache;
    }

    public T primaryShardInfoCache(PrimaryShardInfoFutureCache newPrimaryShardInfoCache) {
        this.checkSealed();
        this.primaryShardInfoCache = newPrimaryShardInfoCache;
        return this.self();
    }

    DatastoreSnapshot getRestoreFromSnapshot() {
        return this.restoreFromSnapshot;
    }

    public T restoreFromSnapshot(DatastoreSnapshot newRestoreFromSnapshot) {
        this.checkSealed();
        this.restoreFromSnapshot = newRestoreFromSnapshot;
        return this.self();
    }

    protected void verify() {
        this.sealed = true;
        Preconditions.checkNotNull((Object)this.cluster, (Object)"cluster should not be null");
        Preconditions.checkNotNull((Object)this.configuration, (Object)"configuration should not be null");
        Preconditions.checkNotNull((Object)this.datastoreContextFactory, (Object)"datastoreContextFactory should not be null");
        Preconditions.checkNotNull((Object)this.distributedDataStore, (Object)"distributedDataStore should not be null");
        Preconditions.checkNotNull((Object)this.waitTillReadyCountDownLatch, (Object)"waitTillReadyCountdownLatch should not be null");
        Preconditions.checkNotNull((Object)this.primaryShardInfoCache, (Object)"primaryShardInfoCache should not be null");
    }

    public Props props() {
        this.verify();
        return Props.create(ShardManager.class, (Object[])new Object[]{this});
    }
}

