/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.shardmanager;

import akka.actor.ActorRef;
import akka.pattern.Patterns;
import com.google.common.base.Preconditions;
import java.util.List;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.datastore.identifiers.ShardIdentifier;
import org.opendaylight.controller.cluster.datastore.shardmanager.GetLocalShardIds;
import org.opendaylight.controller.cluster.datastore.shardmanager.ShardManagerInfoMBean;
import org.opendaylight.controller.cluster.datastore.shardmanager.SwitchShardBehavior;
import org.opendaylight.controller.cluster.raft.RaftState;
import org.opendaylight.controller.md.sal.common.util.jmx.AbstractMXBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;

final class ShardManagerInfo
extends AbstractMXBean
implements ShardManagerInfoMBean {
    public static final String JMX_CATEGORY_SHARD_MANAGER = "ShardManager";
    private static final Logger LOG = LoggerFactory.getLogger(ShardManagerInfo.class);
    private static final long ASK_TIMEOUT_MILLIS = 5000L;
    private final ActorRef shardManager;
    private final MemberName memberName;
    private volatile boolean syncStatus = false;

    ShardManagerInfo(ActorRef shardManager, MemberName memberName, String name, String mxBeanType) {
        super(name, mxBeanType, JMX_CATEGORY_SHARD_MANAGER);
        this.shardManager = (ActorRef)Preconditions.checkNotNull((Object)shardManager);
        this.memberName = (MemberName)Preconditions.checkNotNull((Object)memberName);
    }

    @Override
    public List<String> getLocalShards() {
        try {
            return (List)Await.result((Awaitable)Patterns.ask((ActorRef)this.shardManager, (Object)GetLocalShardIds.INSTANCE, (long)5000L), (Duration)Duration.Inf());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean getSyncStatus() {
        return this.syncStatus;
    }

    void setSyncStatus(boolean syncStatus) {
        this.syncStatus = syncStatus;
    }

    @Override
    public String getMemberName() {
        return this.memberName.getName();
    }

    private void requestSwitchShardState(ShardIdentifier shardId, String newState, long term) {
        RaftState state = RaftState.valueOf((String)newState);
        switch (state) {
            case Follower: 
            case Leader: {
                try {
                    Await.result((Awaitable)Patterns.ask((ActorRef)this.shardManager, (Object)new SwitchShardBehavior(shardId, state, term), (long)5000L), (Duration)Duration.Inf());
                    break;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            default: {
                throw new IllegalArgumentException("Illegal target state " + state);
            }
        }
    }

    @Override
    public void switchAllLocalShardsState(String newState, long term) {
        LOG.info("switchAllLocalShardsState called newState = {}, term = {}", (Object)newState, (Object)term);
        this.requestSwitchShardState(null, newState, term);
    }

    @Override
    public void switchShardState(String shardId, String newState, long term) {
        ShardIdentifier identifier = ShardIdentifier.fromShardIdString(shardId);
        LOG.info("switchShardState called shardName = {}, newState = {}, term = {}", new Object[]{shardId, newState, term});
        this.requestSwitchShardState(identifier, newState, term);
    }
}

