/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.shardstrategy;

import org.opendaylight.controller.cluster.datastore.config.Configuration;
import org.opendaylight.controller.cluster.datastore.shardstrategy.ShardStrategy;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

public class ModuleShardStrategy
implements ShardStrategy {
    public static final String NAME = "module";
    private final String moduleName;
    private final Configuration configuration;

    public ModuleShardStrategy(String moduleName, Configuration configuration) {
        this.moduleName = moduleName;
        this.configuration = configuration;
    }

    @Override
    public String findShard(YangInstanceIdentifier path) {
        String shardName = this.configuration.getShardNameForModule(this.moduleName);
        return shardName != null ? shardName : "default";
    }

    @Override
    public YangInstanceIdentifier getPrefixForPath(YangInstanceIdentifier path) {
        return YangInstanceIdentifier.EMPTY;
    }
}

