/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.utils;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.google.common.primitives.UnsignedLong;
import org.opendaylight.yangtools.concepts.Mutable;

@Beta
public final class UnsignedLongRangeSet
implements Mutable {
    private final RangeSet<UnsignedLong> rangeset;

    private UnsignedLongRangeSet(RangeSet<UnsignedLong> rangeset) {
        this.rangeset = (RangeSet)Preconditions.checkNotNull(rangeset);
    }

    public static UnsignedLongRangeSet create() {
        return new UnsignedLongRangeSet((RangeSet<UnsignedLong>)TreeRangeSet.create());
    }

    public static UnsignedLongRangeSet create(RangeSet<UnsignedLong> input) {
        return new UnsignedLongRangeSet((RangeSet<UnsignedLong>)TreeRangeSet.create(input));
    }

    public RangeSet<UnsignedLong> toImmutable() {
        return ImmutableRangeSet.copyOf(this.rangeset);
    }

    public void add(long longBits) {
        this.add(UnsignedLong.fromLongBits((long)longBits));
    }

    public void add(UnsignedLong value) {
        this.rangeset.add(Range.closedOpen((Comparable)value, (Comparable)UnsignedLong.ONE.plus(value)));
    }

    public boolean contains(UnsignedLong value) {
        return this.rangeset.contains((Comparable)value);
    }

    public boolean contains(long longBits) {
        return this.contains(UnsignedLong.fromLongBits((long)longBits));
    }

    public UnsignedLongRangeSet copy() {
        return new UnsignedLongRangeSet((RangeSet<UnsignedLong>)TreeRangeSet.create(this.rangeset));
    }
}

