/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.sharding;

import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientLocalHistory;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientSnapshot;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.DataStoreClient;
import org.opendaylight.controller.cluster.datastore.utils.ClusterUtils;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteCursor;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.ListNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableLeafNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableLeafSetEntryNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableLeafSetNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableMapEntryNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableMapNodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PrefixedShardConfigWriter {
    private static final Logger LOG = LoggerFactory.getLogger(PrefixedShardConfigWriter.class);
    private final ClientLocalHistory history;

    PrefixedShardConfigWriter(DataStoreClient client) {
        this.history = client.createLocalHistory();
        this.writeInitialParent();
    }

    ListenableFuture<Void> writeConfig(YangInstanceIdentifier path, Collection<MemberName> replicas) {
        LOG.debug("Writing config for {}, replicas {}", (Object)path, replicas);
        return PrefixedShardConfigWriter.doSubmit(this.doWrite(path, replicas));
    }

    ListenableFuture<Void> removeConfig(YangInstanceIdentifier path) {
        LOG.debug("Removing config for {}.", (Object)path);
        return PrefixedShardConfigWriter.doSubmit(this.doDelete(path));
    }

    private void writeInitialParent() {
        ClientTransaction tx = this.history.createTransaction();
        DOMDataTreeWriteCursor cursor = tx.openCursor();
        ContainerNode root = (ContainerNode)ImmutableContainerNodeBuilder.create().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(ClusterUtils.PREFIX_SHARDS_QNAME)).withChild((DataContainerChild)ImmutableMapNodeBuilder.create().withNodeIdentifier(new YangInstanceIdentifier.NodeIdentifier(ClusterUtils.SHARD_LIST_QNAME)).build()).build();
        cursor.merge(ClusterUtils.PREFIX_SHARDS_PATH.getLastPathArgument(), (NormalizedNode)root);
        cursor.close();
        DOMStoreThreePhaseCommitCohort cohort = tx.ready();
        PrefixedShardConfigWriter.submitBlocking(cohort);
    }

    private static void submitBlocking(DOMStoreThreePhaseCommitCohort cohort) {
        try {
            PrefixedShardConfigWriter.doSubmit(cohort).get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("Unable to write initial shard config parent.", (Throwable)e);
        }
    }

    private static ListenableFuture<Void> doSubmit(DOMStoreThreePhaseCommitCohort cohort) {
        AsyncFunction validateFunction = input -> cohort.preCommit();
        AsyncFunction prepareFunction = input -> cohort.commit();
        ListenableFuture prepareFuture = Futures.transformAsync((ListenableFuture)cohort.canCommit(), (AsyncFunction)validateFunction, (Executor)MoreExecutors.directExecutor());
        return Futures.transformAsync((ListenableFuture)prepareFuture, (AsyncFunction)prepareFunction, (Executor)MoreExecutors.directExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkDefaultIsPresent() {
        YangInstanceIdentifier.NodeIdentifierWithPredicates pag = new YangInstanceIdentifier.NodeIdentifierWithPredicates(ClusterUtils.SHARD_LIST_QNAME, ClusterUtils.SHARD_PREFIX_QNAME, (Object)YangInstanceIdentifier.EMPTY);
        YangInstanceIdentifier defaultId = ClusterUtils.SHARD_LIST_PATH.node((YangInstanceIdentifier.PathArgument)pag);
        ClientSnapshot snapshot = this.history.takeSnapshot();
        try {
            boolean bl = (Boolean)snapshot.exists(defaultId).get();
            return bl;
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("Presence check of default shard in configuration failed.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            snapshot.abort();
        }
    }

    private DOMStoreThreePhaseCommitCohort doWrite(YangInstanceIdentifier path, Collection<MemberName> replicas) {
        ListNodeBuilder replicaListBuilder = ImmutableLeafSetNodeBuilder.create().withNodeIdentifier(new YangInstanceIdentifier.NodeIdentifier(ClusterUtils.SHARD_REPLICA_QNAME));
        replicas.forEach(name -> replicaListBuilder.withChild((LeafSetEntryNode)ImmutableLeafSetEntryNodeBuilder.create().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeWithValue(ClusterUtils.SHARD_REPLICA_QNAME, (Object)name.getName())).withValue((Object)name.getName()).build()));
        MapEntryNode newEntry = (MapEntryNode)ImmutableMapEntryNodeBuilder.create().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifierWithPredicates(ClusterUtils.SHARD_LIST_QNAME, ClusterUtils.SHARD_PREFIX_QNAME, (Object)path)).withChild((DataContainerChild)ImmutableLeafNodeBuilder.create().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(ClusterUtils.SHARD_PREFIX_QNAME)).withValue((Object)path).build()).withChild((DataContainerChild)ImmutableContainerNodeBuilder.create().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(ClusterUtils.SHARD_REPLICAS_QNAME)).withChild((DataContainerChild)replicaListBuilder.build()).build()).build();
        ClientTransaction tx = this.history.createTransaction();
        DOMDataTreeWriteCursor cursor = tx.openCursor();
        ClusterUtils.SHARD_LIST_PATH.getPathArguments().forEach(arg_0 -> ((DOMDataTreeWriteCursor)cursor).enter(arg_0));
        cursor.write((YangInstanceIdentifier.PathArgument)newEntry.getIdentifier(), (NormalizedNode)newEntry);
        cursor.close();
        return tx.ready();
    }

    private DOMStoreThreePhaseCommitCohort doDelete(YangInstanceIdentifier path) {
        ClientTransaction tx = this.history.createTransaction();
        DOMDataTreeWriteCursor cursor = tx.openCursor();
        ClusterUtils.SHARD_LIST_PATH.getPathArguments().forEach(arg_0 -> ((DOMDataTreeWriteCursor)cursor).enter(arg_0));
        cursor.delete((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifierWithPredicates(ClusterUtils.SHARD_LIST_QNAME, ClusterUtils.SHARD_PREFIX_QNAME, (Object)path));
        cursor.close();
        return tx.ready();
    }
}

