/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612;

import com.google.common.base.MoreObjects;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Objects;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.TypeObject;

public class HeartbeatIntervalType
implements TypeObject,
Serializable {
    private static final long serialVersionUID = 6964103311731561611L;
    private final Integer _value;

    private static void check_valueRange(int value) {
        if (value >= 100 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[100..65535]]", (int)value);
    }

    @ConstructorProperties(value={"value"})
    public HeartbeatIntervalType(Integer _value) {
        if (_value != null) {
            HeartbeatIntervalType.check_valueRange(_value);
        }
        Objects.requireNonNull(_value, "Supplied value may not be null");
        this._value = _value;
    }

    public HeartbeatIntervalType(HeartbeatIntervalType source) {
        this._value = source._value;
    }

    public static HeartbeatIntervalType getDefaultInstance(String defaultValue) {
        return new HeartbeatIntervalType(Integer.valueOf(defaultValue));
    }

    public Integer getValue() {
        return this._value;
    }

    public int hashCode() {
        return CodeHelpers.wrapperHashCode((Object)this._value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HeartbeatIntervalType other = (HeartbeatIntervalType)obj;
        return Objects.equals(this._value, other._value);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(HeartbeatIntervalType.class);
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_value", (Object)this._value);
        return helper.toString();
    }
}

