/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110.prefix.shards;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110.prefix.shards.Shard;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110.prefix.shards.ShardKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110.prefix.shards.shard.Replicas;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

public class ShardBuilder
implements Builder<Shard> {
    private InstanceIdentifier<?> _prefix;
    private Replicas _replicas;
    private ShardKey key;
    Map<Class<? extends Augmentation<Shard>>, Augmentation<Shard>> augmentation = Collections.emptyMap();

    public ShardBuilder() {
    }

    public ShardBuilder(Shard base) {
        Map aug;
        this.key = base.key();
        this._prefix = base.getPrefix();
        this._replicas = base.getReplicas();
        if (base instanceof ShardImpl) {
            ShardImpl impl = (ShardImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Shard>>, Augmentation<Shard>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Shard>>, Augmentation<Shard>>(aug);
        }
    }

    public ShardKey key() {
        return this.key;
    }

    public InstanceIdentifier<?> getPrefix() {
        return this._prefix;
    }

    public Replicas getReplicas() {
        return this._replicas;
    }

    public <E$$ extends Augmentation<Shard>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public ShardBuilder withKey(ShardKey key) {
        this.key = key;
        return this;
    }

    public ShardBuilder setPrefix(InstanceIdentifier<?> value) {
        this._prefix = value;
        return this;
    }

    public ShardBuilder setReplicas(Replicas value) {
        this._replicas = value;
        return this;
    }

    public ShardBuilder addAugmentation(Class<? extends Augmentation<Shard>> augmentationType, Augmentation<Shard> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Shard>>, Augmentation<Shard>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ShardBuilder removeAugmentation(Class<? extends Augmentation<Shard>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Shard build() {
        return new ShardImpl(this);
    }

    private static final class ShardImpl
    implements Shard {
        private final InstanceIdentifier<?> _prefix;
        private final Replicas _replicas;
        private final ShardKey key;
        private Map<Class<? extends Augmentation<Shard>>, Augmentation<Shard>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        ShardImpl(ShardBuilder base) {
            this.key = base.key() != null ? base.key() : new ShardKey(base.getPrefix());
            this._prefix = this.key.getPrefix();
            this._replicas = base.getReplicas();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Shard> getImplementedInterface() {
            return Shard.class;
        }

        @Override
        public ShardKey key() {
            return this.key;
        }

        @Override
        public InstanceIdentifier<?> getPrefix() {
            return this._prefix;
        }

        @Override
        public Replicas getReplicas() {
            return this._replicas;
        }

        public <E$$ extends Augmentation<Shard>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._prefix);
            result = 31 * result + Objects.hashCode(this._replicas);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Shard.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Shard other = (Shard)obj;
            if (!Objects.equals(this._prefix, other.getPrefix())) {
                return false;
            }
            if (!Objects.equals(this._replicas, other.getReplicas())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ShardImpl otherImpl = (ShardImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Shard>>, Augmentation<Shard>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Shard");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_prefix", this._prefix);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_replicas", (Object)this._replicas);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

