/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.scheduler.core;

import java.util.Map;
import javax.management.MBeanException;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.karaf.scheduler.ScheduleOptions;
import org.apache.karaf.scheduler.Scheduler;
import org.apache.karaf.scheduler.SchedulerMBean;
import org.apache.karaf.scheduler.command.support.TriggerJob;

public class SchedulerMBeanImpl
extends StandardMBean
implements SchedulerMBean {
    private Scheduler scheduler;

    public SchedulerMBeanImpl() throws NotCompliantMBeanException {
        super(SchedulerMBean.class);
    }

    @Override
    public TabularData getJobs() throws MBeanException {
        try {
            CompositeType jobType = new CompositeType("Job", "Scheduler job", new String[]{"Job", "Schedule"}, new String[]{"Job Name", "Job Scheduling"}, new OpenType[]{SimpleType.STRING, SimpleType.STRING});
            TabularType tableType = new TabularType("Jobs", "Tables of all jobs", jobType, new String[]{"Job"});
            TabularDataSupport table = new TabularDataSupport(tableType);
            Map<Object, ScheduleOptions> jobs = this.scheduler.getJobs();
            for (Map.Entry<Object, ScheduleOptions> entry : jobs.entrySet()) {
                CompositeDataSupport data = new CompositeDataSupport(jobType, new String[]{"Job", "Schedule"}, new Object[]{entry.getValue().name(), entry.getValue().schedule()});
                table.put(data);
            }
            return table;
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    @Override
    public void trigger(String name, boolean background) throws MBeanException {
        try {
            if (background) {
                this.scheduler.schedule(new TriggerJob(this.scheduler, name), this.scheduler.NOW());
            } else {
                this.scheduler.trigger(name);
            }
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    @Override
    public void unschedule(String name) throws MBeanException {
        try {
            this.scheduler.unschedule(name);
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }
}

