/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.bus.http;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.util.concurrent.EventExecutorGroup;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import org.opendaylight.jsonrpc.bus.api.MessageListener;
import org.opendaylight.jsonrpc.bus.api.SessionType;
import org.opendaylight.jsonrpc.bus.http.HttpClientHandler;
import org.opendaylight.jsonrpc.bus.http.HttpUtil;
import org.opendaylight.jsonrpc.bus.http.PeerContextImpl;
import org.opendaylight.jsonrpc.bus.http.WebSocketClientHandler;
import org.opendaylight.jsonrpc.bus.http.WebSocketClientHandshake;
import org.opendaylight.jsonrpc.bus.spi.AbstractChannelInitializer;
import org.opendaylight.jsonrpc.bus.spi.CommonConstants;

class ClientInitializer
extends AbstractChannelInitializer {
    private final boolean useSsl;
    private final SslContext sslContext;
    private final boolean isWebsocket;
    private final URI baseUri;
    private final MessageListener listener;

    ClientInitializer(SessionType socketType, EventExecutorGroup handlerExecutor, boolean useSsl, boolean isWebsocket, URI baseUri, Map<String, String> opts, MessageListener listener) {
        super(socketType, handlerExecutor);
        this.useSsl = useSsl;
        this.isWebsocket = isWebsocket;
        this.baseUri = baseUri;
        this.listener = listener;
        if (useSsl) {
            try {
                TrustManagerFactory trustManagerFactory = "ignore".equals(opts.computeIfAbsent("certificatetrustpolicy", v -> "ignore")) ? InsecureTrustManagerFactory.INSTANCE : null;
                this.sslContext = SslContextBuilder.forClient().trustManager(trustManagerFactory).build();
            }
            catch (SSLException e) {
                throw new IllegalStateException("Failed to initialize SSL", e);
            }
        } else {
            this.sslContext = null;
        }
    }

    public void initChannel(SocketChannel ch) throws Exception {
        super.initChannel(ch);
        ch.attr(CommonConstants.ATTR_PEER_CONTEXT).set((Object)new PeerContextImpl((Channel)ch, this.isWebsocket, this.useSsl));
        ch.attr(CommonConstants.ATTR_RESPONSE_QUEUE).set(new AtomicReference<Object>(null));
        if (this.useSsl) {
            ch.pipeline().addLast("ssl", (ChannelHandler)this.sslContext.newHandler(ch.alloc()));
        }
        if (!this.isWebsocket) {
            ch.attr(CommonConstants.ATTR_HANDSHAKE_DONE).set((Object)true);
        }
        ch.pipeline().addLast("codec", (ChannelHandler)new HttpClientCodec());
        ch.pipeline().addLast("http-aggregator", (ChannelHandler)new HttpObjectAggregator(262144));
        if (this.isWebsocket) {
            WebSocketClientHandshaker handshaker = this.getWsHandshaker();
            ch.pipeline().addLast("ws-handshake", (ChannelHandler)new WebSocketClientHandshake(handshaker));
        }
        ClientInitializer.configureLogging((Channel)ch);
        if (this.isWebsocket) {
            ch.pipeline().addLast(this.handlerExecutor, new ChannelHandler[]{new WebSocketClientHandler(this.listener)});
        } else {
            ch.pipeline().addLast(this.handlerExecutor, "client-handler", (ChannelHandler)new HttpClientHandler(this.listener));
        }
    }

    private WebSocketClientHandshaker getWsHandshaker() {
        return WebSocketClientHandshakerFactory.newHandshaker((URI)HttpUtil.stripPathAndQueryParams(this.baseUri), (WebSocketVersion)WebSocketVersion.V13, null, (boolean)true, (HttpHeaders)new DefaultHttpHeaders());
    }
}

