/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.bus.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;

final class HttpUtil {
    private HttpUtil() {
    }

    public static String getTransport(boolean isWebsocket, boolean isSsl) {
        if (isWebsocket) {
            return isSsl ? "wss" : "ws";
        }
        return isSsl ? "https" : "http";
    }

    public static Object createRequestObject(boolean isWebSocket, String message) {
        return isWebSocket ? HttpUtil.createWebsocketFrame(message) : HttpUtil.createHttpRequest(message);
    }

    private static HttpRequest createHttpRequest(String msg) {
        ByteBuf buffer = Unpooled.buffer();
        buffer.writeCharSequence((CharSequence)msg, StandardCharsets.UTF_8);
        DefaultFullHttpRequest http = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/", buffer);
        http.headers().add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.APPLICATION_JSON);
        http.headers().add((CharSequence)HttpHeaderNames.ACCEPT, (Object)HttpHeaderValues.APPLICATION_JSON);
        http.headers().add((CharSequence)HttpHeaderNames.USER_AGENT, (Object)"JSON-RPC 2.0 client");
        http.headers().add((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        http.headers().add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)String.valueOf(buffer.readableBytes()));
        return http;
    }

    private static WebSocketFrame createWebsocketFrame(String message) {
        return new TextWebSocketFrame(message);
    }

    public static URI stripPathAndQueryParams(URI inUri) {
        try {
            return new URI(inUri.getScheme(), null, inUri.getHost(), inUri.getPort(), null, null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }
}

