/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.bus.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import java.nio.charset.StandardCharsets;
import org.opendaylight.jsonrpc.bus.http.HttpUtil;
import org.opendaylight.jsonrpc.bus.spi.AbstractPeerContext;

public class PeerContextImpl
extends AbstractPeerContext {
    private final boolean isWebsocket;

    public PeerContextImpl(Channel channel, boolean isWebsocket, boolean isSsl) {
        super(channel, HttpUtil.getTransport(isWebsocket, isSsl));
        this.isWebsocket = isWebsocket;
    }

    public void send(String msg) {
        this.channel.writeAndFlush(this.isWebsocket ? this.getWsResponse(msg) : this.getHttpResponse(msg));
    }

    private HttpResponse getHttpResponse(String msg) {
        ByteBuf buffer = Unpooled.buffer();
        buffer.writeCharSequence((CharSequence)msg, StandardCharsets.UTF_8);
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, buffer);
        response.headers().add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.APPLICATION_JSON);
        response.headers().add((CharSequence)HttpHeaderNames.SERVER, (Object)"JSON-RPC 2.0 server");
        response.headers().add((CharSequence)HttpHeaderNames.ACCEPT, (Object)HttpHeaderValues.APPLICATION_JSON);
        response.headers().add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)String.valueOf(buffer.writerIndex()));
        return response;
    }

    private TextWebSocketFrame getWsResponse(String msg) {
        return new TextWebSocketFrame(msg);
    }
}

