/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.bus.http;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.util.concurrent.ProgressivePromise;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicReference;
import org.opendaylight.jsonrpc.bus.api.MessageListener;
import org.opendaylight.jsonrpc.bus.api.PeerContext;
import org.opendaylight.jsonrpc.bus.spi.AbstractMessageListenerAdapter;
import org.opendaylight.jsonrpc.bus.spi.CommonConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WebSocketClientHandler
extends AbstractMessageListenerAdapter<TextWebSocketFrame> {
    private static final Logger LOG = LoggerFactory.getLogger(WebSocketClientHandler.class);

    WebSocketClientHandler(MessageListener messageListener) {
        super(messageListener);
    }

    protected void channelRead0(ChannelHandlerContext ctx, TextWebSocketFrame msg) throws Exception {
        ProgressivePromise promise;
        String bufferContent = msg.content().toString(StandardCharsets.UTF_8);
        if (CommonConstants.DEBUG_MODE) {
            LOG.debug("Received weboscket frame with content '{}'", (Object)bufferContent);
        }
        if ((promise = (ProgressivePromise)((AtomicReference)ctx.channel().attr(CommonConstants.ATTR_RESPONSE_QUEUE).get()).getAndSet(null)) != null) {
            promise.trySuccess((Object)bufferContent);
        }
        PeerContext peer = (PeerContext)ctx.channel().attr(CommonConstants.ATTR_PEER_CONTEXT).get();
        this.messageListener.onMessage(peer, bufferContent);
    }
}

