/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.audit.logger;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.nio.charset.Charset;
import org.apache.karaf.audit.Event;
import org.apache.karaf.audit.EventLayout;
import org.apache.karaf.audit.EventLogger;

public class TcpEventLogger
implements EventLogger {
    private final String host;
    private final int port;
    private final Charset encoding;
    private final EventLayout layout;
    private BufferedWriter writer;

    public TcpEventLogger(String host, int port, String encoding, EventLayout layout) throws IOException {
        this.host = host;
        this.port = port;
        this.encoding = Charset.forName(encoding);
        this.layout = layout;
    }

    @Override
    public void write(Event event) throws IOException {
        if (this.writer == null) {
            Socket socket = new Socket(this.host, this.port);
            this.writer = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), this.encoding));
        }
        this.layout.format(event, this.writer);
        this.writer.append("\n");
    }

    @Override
    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        }
    }
}

