/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.audit.logger;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import org.apache.karaf.audit.Event;
import org.apache.karaf.audit.EventLayout;
import org.apache.karaf.audit.EventLogger;

public class UdpEventLogger
implements EventLogger {
    private final InetAddress host;
    private final int port;
    private final CharsetEncoder encoder;
    private final EventLayout layout;
    private final DatagramSocket dgram;
    private ByteBuffer bb = ByteBuffer.allocate(1024);

    public UdpEventLogger(String host, int port, String encoding, EventLayout layout) throws SocketException, UnknownHostException {
        this.layout = layout;
        this.host = InetAddress.getByName(host);
        this.port = port;
        this.encoder = Charset.forName(encoding).newEncoder();
        this.dgram = new DatagramSocket();
    }

    @Override
    public void write(Event event) throws IOException {
        CharBuffer cb = this.layout.format(event);
        int cap = (int)((float)cb.remaining() * this.encoder.averageBytesPerChar());
        ByteBuffer bb = this.bb.capacity() > cap ? this.bb : ByteBuffer.allocate(cap);
        this.encoder.reset();
        this.encoder.encode(cb, bb, true);
        if (cb.remaining() > 0) {
            bb = ByteBuffer.allocate(bb.capacity() * 2);
            cb.position(0);
            this.encoder.reset();
            this.encoder.encode(cb, bb, true);
        }
        this.dgram.send(new DatagramPacket(bb.array(), 0, bb.position(), this.host, this.port));
        bb.position(0);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        this.dgram.close();
    }
}

