/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.aries.application.ApplicationMetadata;
import org.apache.aries.application.Content;
import org.apache.aries.application.DeploymentContent;
import org.apache.aries.application.DeploymentMetadata;
import org.apache.aries.application.InvalidAttributeException;
import org.apache.aries.application.impl.ApplicationMetadataImpl;
import org.apache.aries.application.impl.ContentImpl;
import org.apache.aries.application.impl.DeploymentContentImpl;
import org.apache.aries.application.management.AriesApplication;
import org.apache.aries.application.management.BundleInfo;
import org.apache.aries.application.management.ResolverException;
import org.apache.aries.application.utils.FilterUtils;
import org.apache.aries.util.VersionRange;
import org.apache.aries.util.manifest.ManifestProcessor;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentMetadataImpl
implements DeploymentMetadata {
    private ApplicationMetadata _applicationMetadata;
    private List<DeploymentContent> _deploymentContent = new ArrayList<DeploymentContent>();
    private List<DeploymentContent> _provisionSharedContent = new ArrayList<DeploymentContent>();
    private List<DeploymentContent> _deployedUseBundleContent = new ArrayList<DeploymentContent>();
    private Set<Content> _deploymentImportPackage = new HashSet<Content>();
    private Map<String, String> _deploymentCustomEntries = new HashMap<String, String>();
    private Map<String, String> _deploymentEntries = new HashMap<String, String>();
    private Collection<Filter> _deployedImportService = new ArrayList<Filter>();

    public DeploymentMetadataImpl(AriesApplication app, Set<BundleInfo> bundlesRequired) throws ResolverException {
        this._applicationMetadata = app.getApplicationMetadata();
        this._deploymentContent = new ArrayList<DeploymentContent>();
        this._provisionSharedContent = new ArrayList<DeploymentContent>();
        this._deployedUseBundleContent = new ArrayList<DeploymentContent>();
        HashMap<String, VersionRange> appContent = new HashMap<String, VersionRange>();
        for (Content c : app.getApplicationMetadata().getApplicationContents()) {
            appContent.put(c.getContentName(), c.getVersion());
        }
        HashMap<String, VersionRange> useBundles = new HashMap<String, VersionRange>();
        for (Content c : app.getApplicationMetadata().getUseBundles()) {
            useBundles.put(c.getContentName(), c.getVersion());
        }
        for (BundleInfo info : bundlesRequired) {
            VersionRange appContentRange = (VersionRange)appContent.get(info.getSymbolicName());
            VersionRange useBundleRange = (VersionRange)useBundles.get(info.getSymbolicName());
            DeploymentContentImpl dp = new DeploymentContentImpl(info.getSymbolicName(), info.getVersion());
            if (appContentRange == null && useBundleRange == null) {
                this._provisionSharedContent.add(dp);
                continue;
            }
            if (appContentRange.matches(info.getVersion())) {
                this._deploymentContent.add(dp);
                continue;
            }
            if (useBundleRange.matches(info.getVersion())) {
                this._deployedUseBundleContent.add(dp);
                continue;
            }
            throw new ResolverException("Bundle " + info.getSymbolicName() + " at version " + info.getVersion() + " is not in the range " + appContentRange + " or " + useBundleRange);
        }
    }

    public DeploymentMetadataImpl(Manifest mf) throws InvalidAttributeException {
        this._applicationMetadata = new ApplicationMetadataImpl(mf);
        Attributes attributes = mf.getMainAttributes();
        this.parseDeploymentContent(attributes.getValue("Deployed-Content"), this._deploymentContent);
        this.parseDeploymentContent(attributes.getValue("Provision-Bundle"), this._provisionSharedContent);
        this.parseDeploymentContent(attributes.getValue("Deployed-Use-Bundle"), this._deployedUseBundleContent);
        this.parseContent(attributes.getValue("Import-Package"), this._deploymentImportPackage);
        this._deployedImportService = this.getFilters(attributes.getValue("DeployedService-Import"));
        this._deploymentCustomEntries = this.getCustomEntries(attributes);
        this._deploymentEntries = this.getEntries(attributes);
    }

    public DeploymentMetadataImpl(Map<String, String> map) throws InvalidAttributeException {
        Attributes attributes = new Attributes();
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                attributes.putValue(entry.getKey(), entry.getValue());
            }
        }
        this.parseDeploymentContent(map.get("Deployed-Content"), this._deploymentContent);
        this.parseDeploymentContent(map.get("Provision-Bundle"), this._provisionSharedContent);
        this.parseDeploymentContent(map.get("Deployed-Use-Bundle"), this._deployedUseBundleContent);
        this.parseContent(attributes.getValue("Import-Package"), this._deploymentImportPackage);
        this._deployedImportService = this.getFilters(attributes.getValue("DeployedService-Import"));
        this._deploymentCustomEntries = this.getCustomEntries(attributes);
        this._deploymentEntries = this.getEntries(attributes);
    }

    private Collection<Attributes.Name> getDeploymentStandardHeaders() {
        HashSet<Attributes.Name> standardKeys = new HashSet<Attributes.Name>();
        standardKeys.add(new Attributes.Name("Manifest-Version"));
        standardKeys.add(new Attributes.Name("Deployed-Content"));
        standardKeys.add(new Attributes.Name("Provision-Bundle"));
        standardKeys.add(new Attributes.Name("Deployed-Use-Bundle"));
        standardKeys.add(new Attributes.Name("Import-Package"));
        standardKeys.add(new Attributes.Name("DeployedService-Import"));
        standardKeys.add(new Attributes.Name("Application-SymbolicName"));
        standardKeys.add(new Attributes.Name("Application-Version"));
        return standardKeys;
    }

    private Collection<String> getCustomHeaders(Attributes attrs) {
        Set<Object> keys;
        HashSet<String> customKeys = new HashSet<String>();
        Collection<Attributes.Name> standardKeys = this.getDeploymentStandardHeaders();
        if (attrs != null && !attrs.isEmpty() && (keys = attrs.keySet()) != null && !keys.isEmpty()) {
            for (Object eachKey : keys) {
                String key = eachKey.toString();
                customKeys.add(key);
            }
            customKeys.removeAll(standardKeys);
        }
        return customKeys;
    }

    private String getContentsAsString(Collection<Content> contents) {
        StringBuilder builder = new StringBuilder();
        boolean beginning = true;
        for (Content c : contents) {
            if (!beginning) {
                builder.append(",");
            }
            builder.append(c);
            beginning = false;
        }
        return builder.toString();
    }

    public List<DeploymentContent> getApplicationDeploymentContents() {
        return Collections.unmodifiableList(this._deploymentContent);
    }

    public List<DeploymentContent> getApplicationProvisionBundles() {
        return Collections.unmodifiableList(this._provisionSharedContent);
    }

    public ApplicationMetadata getApplicationMetadata() {
        return this._applicationMetadata;
    }

    public String getApplicationSymbolicName() {
        return this._applicationMetadata.getApplicationSymbolicName();
    }

    public Version getApplicationVersion() {
        return this._applicationMetadata.getApplicationVersion();
    }

    public void store(File f) throws FileNotFoundException, IOException {
        FileOutputStream fos = new FileOutputStream(f);
        this.store(fos);
        fos.close();
    }

    public void store(OutputStream out) throws IOException {
        Manifest mf = new Manifest();
        Attributes attributes = mf.getMainAttributes();
        attributes.putValue(Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
        attributes.putValue("Application-Version", this.getApplicationVersion().toString());
        attributes.putValue("Application-SymbolicName", this.getApplicationSymbolicName());
        if (this._deploymentContent != null && !this._deploymentContent.isEmpty()) {
            attributes.putValue("Deployed-Content", this.getDeploymentContentsAsString(this._deploymentContent));
        }
        if (this._provisionSharedContent != null && !this._provisionSharedContent.isEmpty()) {
            attributes.putValue("Provision-Bundle", this.getDeploymentContentsAsString(this._provisionSharedContent));
        }
        if (this._deployedUseBundleContent != null && !this._deployedUseBundleContent.isEmpty()) {
            attributes.putValue("Deployed-Use-Bundle", this.getDeploymentContentsAsString(this._deployedUseBundleContent));
        }
        if (this._deploymentImportPackage != null && !this._deploymentImportPackage.isEmpty()) {
            attributes.putValue("Import-Package", this.getContentsAsString(this._deploymentImportPackage));
        }
        if (this._deployedImportService != null && !this._deployedImportService.isEmpty()) {
            attributes.putValue("DeployedService-Import", this.convertFiltersToString(this._deployedImportService, ","));
        }
        if (this._deploymentCustomEntries != null && this._deploymentCustomEntries.isEmpty()) {
            for (Map.Entry<String, String> customEntry : this._deploymentCustomEntries.entrySet()) {
                attributes.putValue(customEntry.getKey(), customEntry.getValue());
            }
        }
        mf.write(out);
    }

    private String getDeploymentContentsAsString(List<DeploymentContent> content) {
        StringBuilder builder = new StringBuilder();
        for (DeploymentContent dc : content) {
            builder.append(dc.getContentName());
            builder.append(";deployed-version=");
            builder.append(dc.getExactVersion());
            builder.append(",");
        }
        if (builder.length() > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    private void parseDeploymentContent(String content, List<DeploymentContent> contents) {
        List pcList = ManifestProcessor.split((String)content, (String)",");
        for (String s : pcList) {
            contents.add(new DeploymentContentImpl(s));
        }
    }

    private void parseContent(String content, Collection<Content> contents) {
        List pcList = ManifestProcessor.split((String)content, (String)",");
        for (String s : pcList) {
            contents.add(new ContentImpl(s));
        }
    }

    public List<DeploymentContent> getDeployedUseBundle() {
        return Collections.unmodifiableList(this._deployedUseBundleContent);
    }

    public Set<Content> getImportPackage() {
        return Collections.unmodifiableSet(this._deploymentImportPackage);
    }

    public Collection<Filter> getDeployedServiceImport() {
        return Collections.unmodifiableCollection(this._deployedImportService);
    }

    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this._deploymentEntries);
    }

    private Map<String, String> getEntries(Attributes attrs) {
        HashMap<String, String> entries = new HashMap<String, String>();
        if (attrs != null && !attrs.isEmpty()) {
            Set<Object> keys = attrs.keySet();
            for (Object key : keys) {
                entries.put(key.toString(), attrs.getValue((Attributes.Name)key));
            }
        }
        return entries;
    }

    private Map<String, String> getCustomEntries(Attributes attrs) {
        HashMap<String, String> customEntry = new HashMap<String, String>();
        Collection<String> customHeaders = this.getCustomHeaders(attrs);
        if (customHeaders != null && customHeaders.isEmpty()) {
            for (String customHeader : customHeaders) {
                customEntry.put(customHeader, attrs.getValue(customHeader));
            }
        }
        return customEntry;
    }

    private Collection<Filter> getFilters(String filterString) throws InvalidAttributeException {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        List fs = ManifestProcessor.split((String)filterString, (String)",");
        if (fs != null && !fs.isEmpty()) {
            for (String filter : fs) {
                try {
                    filters.add(FrameworkUtil.createFilter((String)FilterUtils.removeMandatoryFilterToken(filter)));
                }
                catch (InvalidSyntaxException ise) {
                    InvalidAttributeException iae = new InvalidAttributeException((Exception)((Object)ise));
                    throw iae;
                }
            }
        }
        return filters;
    }

    private String convertFiltersToString(Collection<Filter> contents, String separator) {
        StringBuilder newContent = new StringBuilder();
        if (contents != null && !contents.isEmpty()) {
            boolean beginning = true;
            for (Filter content : contents) {
                if (beginning) {
                    newContent.append(separator);
                }
                newContent.append(content.toString());
                beginning = false;
            }
        }
        return newContent.toString();
    }
}

