/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.clustering.it.provider.impl;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.SplittableRandom;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.clustering.it.provider.impl.AbstractTransactionHandler;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeCursorAwareTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.api.DOMDataTreeProducer;
import org.opendaylight.mdsal.dom.api.DOMDataTreeProducerException;
import org.opendaylight.mdsal.dom.api.DOMDataTreeService;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteCursor;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.ProduceTransactionsInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.ProduceTransactionsOutput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.ProduceTransactionsOutputBuilder;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.TransactionsParams;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProduceTransactionsHandler
extends AbstractTransactionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ProduceTransactionsHandler.class);
    private final SettableFuture<RpcResult<ProduceTransactionsOutput>> future = SettableFuture.create();
    private final SplittableRandom random = new SplittableRandom();
    private final Set<Integer> usedValues = new HashSet<Integer>();
    private final DOMDataTreeIdentifier idListItem;
    private final DOMDataTreeProducer itemProducer;
    private long insertTx = 0L;
    private long deleteTx = 0L;

    private ProduceTransactionsHandler(DOMDataTreeProducer producer, DOMDataTreeIdentifier idListItem, ProduceTransactionsInput input) {
        super((TransactionsParams)input);
        this.itemProducer = (DOMDataTreeProducer)Preconditions.checkNotNull((Object)producer);
        this.idListItem = (DOMDataTreeIdentifier)Preconditions.checkNotNull((Object)idListItem);
    }

    public static ListenableFuture<RpcResult<ProduceTransactionsOutput>> start(DOMDataTreeService domDataTreeService, ProduceTransactionsInput input) {
        String id = input.getId();
        LOG.debug("Filling the item list {} with initial values.", (Object)id);
        YangInstanceIdentifier idListWithKey = ID_INT_YID.node((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifierWithPredicates(ID_INT, ID, (Object)id));
        DOMDataTreeProducer itemProducer = domDataTreeService.createProducer(Collections.singleton(new DOMDataTreeIdentifier(LogicalDatastoreType.CONFIGURATION, idListWithKey)));
        DOMDataTreeCursorAwareTransaction tx = itemProducer.createTransaction(false);
        DOMDataTreeWriteCursor cursor = tx.createCursor(new DOMDataTreeIdentifier(LogicalDatastoreType.CONFIGURATION, idListWithKey));
        MapNode list = (MapNode)ImmutableNodes.mapNodeBuilder((QName)ITEM).build();
        cursor.write(list.getIdentifier(), (NormalizedNode)list);
        cursor.close();
        try {
            tx.commit().get(125L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            LOG.warn("Unable to fill the initial item list.", (Throwable)e);
            ProduceTransactionsHandler.closeProducer(itemProducer);
            return Futures.immediateFuture((Object)RpcResultBuilder.failed().withError(RpcError.ErrorType.APPLICATION, "Unexpected-exception", (Throwable)e).build());
        }
        ProduceTransactionsHandler handler = new ProduceTransactionsHandler(itemProducer, new DOMDataTreeIdentifier(LogicalDatastoreType.CONFIGURATION, idListWithKey.node(list.getIdentifier()).toOptimized()), input);
        handler.doStart();
        return handler.future;
    }

    private static void closeProducer(DOMDataTreeProducer producer) {
        try {
            producer.close();
        }
        catch (DOMDataTreeProducerException exception) {
            LOG.warn("Failure while closing producer.", (Throwable)exception);
        }
    }

    FluentFuture<? extends @NonNull CommitInfo> execWrite(long txId) {
        int i = this.random.nextInt(0x100001);
        DOMDataTreeCursorAwareTransaction tx = this.itemProducer.createTransaction(false);
        DOMDataTreeWriteCursor cursor = tx.createCursor(this.idListItem);
        YangInstanceIdentifier.NodeIdentifierWithPredicates entryId = new YangInstanceIdentifier.NodeIdentifierWithPredicates(ITEM, NUMBER, (Object)i);
        if (this.usedValues.contains(i)) {
            LOG.debug("Deleting item: {}", (Object)i);
            ++this.deleteTx;
            cursor.delete((YangInstanceIdentifier.PathArgument)entryId);
            this.usedValues.remove(i);
        } else {
            LOG.debug("Inserting item: {}", (Object)i);
            ++this.insertTx;
            MapEntryNode entry = (MapEntryNode)ImmutableNodes.mapEntryBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)entryId).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)NUMBER, (Object)i)).build();
            cursor.write((YangInstanceIdentifier.PathArgument)entryId, (NormalizedNode)entry);
            this.usedValues.add(i);
        }
        cursor.close();
        return tx.commit();
    }

    @Override
    void runFailed(Throwable cause, long txId) {
        ProduceTransactionsHandler.closeProducer(this.itemProducer);
        this.future.set((Object)RpcResultBuilder.failed().withError(RpcError.ErrorType.APPLICATION, "Commit failed for tx # " + txId, cause).build());
    }

    @Override
    void runSuccessful(long allTx) {
        ProduceTransactionsHandler.closeProducer(this.itemProducer);
        ProduceTransactionsOutput output = new ProduceTransactionsOutputBuilder().setAllTx(Long.valueOf(allTx)).setInsertTx(Long.valueOf(this.insertTx)).setDeleteTx(Long.valueOf(this.deleteTx)).build();
        this.future.set((Object)RpcResultBuilder.success().withResult((Object)output).build());
    }

    @Override
    void runTimedOut(String cause) {
        ProduceTransactionsHandler.closeProducer(this.itemProducer);
        this.future.set((Object)RpcResultBuilder.failed().withError(RpcError.ErrorType.APPLICATION, cause).build());
    }
}

