/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.clustering.it.provider.impl;

import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcException;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcIdentifier;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcImplementation;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcImplementationRegistration;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcProviderService;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcResult;
import org.opendaylight.controller.md.sal.dom.spi.DefaultDOMRpcResult;
import org.opendaylight.mdsal.singleton.common.api.ClusterSingletonService;
import org.opendaylight.mdsal.singleton.common.api.ClusterSingletonServiceProvider;
import org.opendaylight.mdsal.singleton.common.api.ClusterSingletonServiceRegistration;
import org.opendaylight.mdsal.singleton.common.api.ServiceGroupIdentifier;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableLeafNodeBuilder;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SingletonGetConstantService
implements DOMRpcImplementation,
ClusterSingletonService {
    private static final Logger LOG = LoggerFactory.getLogger(SingletonGetConstantService.class);
    private static final QName OUTPUT = QName.create((String)"tag:opendaylight.org,2017:controller:yang:lowlevel:target", (String)"2017-02-15", (String)"output");
    private static final QName CONSTANT = QName.create((String)"tag:opendaylight.org,2017:controller:yang:lowlevel:target", (String)"2017-02-15", (String)"constant");
    private static final QName CONTEXT = QName.create((String)"tag:opendaylight.org,2017:controller:yang:lowlevel:target", (String)"2017-02-15", (String)"context");
    private static final QName GET_SINGLETON_CONSTANT = QName.create((String)"tag:opendaylight.org,2017:controller:yang:lowlevel:target", (String)"2017-02-15", (String)"get-singleton-constant");
    private static final ServiceGroupIdentifier SERVICE_GROUP_IDENTIFIER = ServiceGroupIdentifier.create((String)"get-singleton-constant-service");
    private final DOMRpcProviderService rpcProviderService;
    private final String constant;
    private DOMRpcImplementationRegistration<SingletonGetConstantService> rpcRegistration;

    private SingletonGetConstantService(DOMRpcProviderService rpcProviderService, String constant) {
        this.rpcProviderService = rpcProviderService;
        this.constant = constant;
    }

    public static ClusterSingletonServiceRegistration registerNew(ClusterSingletonServiceProvider singletonService, DOMRpcProviderService rpcProviderService, String constant) {
        LOG.debug("Registering get-singleton-constant into ClusterSingletonService, value {}", (Object)constant);
        return singletonService.registerClusterSingletonService((ClusterSingletonService)new SingletonGetConstantService(rpcProviderService, constant));
    }

    public CheckedFuture<DOMRpcResult, DOMRpcException> invokeRpc(DOMRpcIdentifier rpc, NormalizedNode<?, ?> input) {
        LOG.debug("get-singleton-constant invoked, current value: {}", (Object)this.constant);
        LeafNode value = (LeafNode)ImmutableLeafNodeBuilder.create().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(CONSTANT)).withValue((Object)this.constant).build();
        ContainerNode result = (ContainerNode)ImmutableContainerNodeBuilder.create().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(OUTPUT)).withChild((DataContainerChild)value).build();
        return Futures.immediateCheckedFuture((Object)new DefaultDOMRpcResult((NormalizedNode)result));
    }

    public void instantiateServiceInstance() {
        LOG.debug("Gained ownership of get-singleton-constant, registering service into rpcService");
        DOMRpcIdentifier id = DOMRpcIdentifier.create((SchemaPath)SchemaPath.create((boolean)true, (QName[])new QName[]{GET_SINGLETON_CONSTANT}));
        this.rpcRegistration = this.rpcProviderService.registerRpcImplementation((DOMRpcImplementation)this, new DOMRpcIdentifier[]{id});
    }

    public ListenableFuture<Void> closeServiceInstance() {
        LOG.debug("Closing get-singleton-constant instance");
        this.rpcRegistration.close();
        return Futures.immediateFuture(null);
    }

    public ServiceGroupIdentifier getIdentifier() {
        return SERVICE_GROUP_IDENTIFIER;
    }
}

