/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.clustering.it.provider.impl;

import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicLong;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.UnsubscribeYnlOutput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.UnsubscribeYnlOutputBuilder;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.target.rev170215.IdSequence;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.target.rev170215.OdlMdsalLowlevelTargetListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YnlListener
implements OdlMdsalLowlevelTargetListener {
    private static final Logger LOG = LoggerFactory.getLogger(YnlListener.class);
    private final String id;
    private final AtomicLong localNumber = new AtomicLong();
    private final AtomicLong allNot = new AtomicLong();
    private final AtomicLong idNot = new AtomicLong();
    private final AtomicLong errNot = new AtomicLong();

    public YnlListener(String id) {
        Preconditions.checkNotNull((Object)id);
        this.id = id;
    }

    public void onIdSequence(IdSequence notification) {
        LOG.debug("Received id-sequence notification, : {}", (Object)notification);
        this.allNot.incrementAndGet();
        if (notification.getId().equals(this.id)) {
            this.idNot.incrementAndGet();
            this.localNumber.getAndUpdate(value -> {
                if (notification.getSequenceNumber() - value == 1L) {
                    return value + 1L;
                }
                this.errNot.getAndIncrement();
                return value;
            });
        }
    }

    public UnsubscribeYnlOutput getOutput() {
        return new UnsubscribeYnlOutputBuilder().setAllNot(Long.valueOf(this.allNot.get())).setErrNot(Long.valueOf(this.errNot.get())).setIdNot(Long.valueOf(this.idNot.get())).setLocalNumber(Long.valueOf(this.localNumber.get())).build();
    }
}

