/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.export;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SubmoduleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SubmoduleStatement;
import org.opendaylight.yangtools.yang.model.export.ModuleNamespaceContext;
import org.opendaylight.yangtools.yang.model.export.YinXMLEventReader;

@Beta
@ThreadSafe
public final class YinXMLEventReaderFactory {
    private static final Location DUMMY_LOCATION = new Location(){

        @Override
        public int getLineNumber() {
            return -1;
        }

        @Override
        public int getColumnNumber() {
            return -1;
        }

        @Override
        public int getCharacterOffset() {
            return -1;
        }

        @Override
        public String getPublicId() {
            return null;
        }

        @Override
        public String getSystemId() {
            return null;
        }
    };
    private static final YinXMLEventReaderFactory DEFAULT;
    private final XMLEventFactory eventFactory;

    private YinXMLEventReaderFactory(XMLEventFactory eventFactory) {
        this.eventFactory = Objects.requireNonNull(eventFactory);
    }

    public static YinXMLEventReaderFactory defaultInstance() {
        return DEFAULT;
    }

    public static YinXMLEventReaderFactory ofEventFactory(XMLEventFactory factory) {
        return new YinXMLEventReaderFactory(factory);
    }

    public XMLEventReader createXMLEventReader(ModuleEffectiveStatement module) {
        ModuleStatement declared = (ModuleStatement)module.getDeclared();
        Preconditions.checkArgument((declared != null ? 1 : 0) != 0, (String)"Module %s does not expose declared model", (Object)module);
        return new YinXMLEventReader(this.eventFactory, new ModuleNamespaceContext(module), (DeclaredStatement<?>)declared);
    }

    public XMLEventReader createXMLEventReader(ModuleEffectiveStatement module, SubmoduleEffectiveStatement submodule) {
        SubmoduleStatement declared = (SubmoduleStatement)submodule.getDeclared();
        Preconditions.checkArgument((declared != null ? 1 : 0) != 0, (String)"Submodule %s does not expose declared model", (Object)submodule);
        return new YinXMLEventReader(this.eventFactory, new ModuleNamespaceContext(module), (DeclaredStatement<?>)declared);
    }

    static {
        XMLEventFactory eventFactory = XMLEventFactory.newFactory();
        eventFactory.setLocation(DUMMY_LOCATION);
        DEFAULT = new YinXMLEventReaderFactory(eventFactory);
    }
}

