/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.subsystem.commands;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.felix.utils.manifest.Attribute;
import org.apache.felix.utils.manifest.Clause;
import org.apache.felix.utils.manifest.Directive;
import org.apache.felix.utils.manifest.Parser;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.Terminal;
import org.apache.karaf.shell.support.ShellUtil;
import org.apache.karaf.subsystem.commands.SubsystemCompleter;
import org.apache.karaf.subsystem.commands.SubsystemSupport;
import org.osgi.service.subsystem.Subsystem;

@Command(scope="subsystem", name="info", description="Display information about subsystems")
@Service
public class InfoAction
extends SubsystemSupport
implements Action {
    protected static final String SUBSYSTEM_PREFIX = "Subsystem-";
    protected static final String PACKAGE_SUFFFIX = "-Package";
    protected static final String SERVICE_SUFFIX = "-Service";
    protected static final String CAPABILITY_SUFFIX = "-Capability";
    protected static final String IMPORT_PACKAGES_ATTRIB = "Import-Package";
    protected static final String REQUIRE_BUNDLE_ATTRIB = "Require-Bundle";
    @Option(name="--indent", description="Indentation method")
    int indent = -1;
    @Argument(description="Subsystem names or ids")
    @Completion(value=SubsystemCompleter.class)
    String id;
    @Reference(optional=true)
    Terminal terminal;

    public Object execute() throws Exception {
        for (Subsystem ss : this.getSubsystems(this.id)) {
            this.printHeaders(ss);
        }
        return null;
    }

    protected void printHeaders(Subsystem subsystem) throws Exception {
        String title = InfoAction.getSubsystemName(subsystem);
        System.out.println("\n" + title);
        System.out.println(ShellUtil.getUnderlineString((String)title));
        if (this.indent == 0) {
            Map dict = subsystem.getSubsystemHeaders(null);
            for (String k : dict.keySet()) {
                Object v = dict.get(k);
                System.out.println(k + " = " + ShellUtil.getValueString(v));
            }
        } else {
            System.out.println(this.generateFormattedOutput(subsystem));
        }
    }

    public static String getSubsystemName(Subsystem subsystem) {
        String name = (String)subsystem.getSubsystemHeaders(null).get("Subsystem-Name");
        return name == null ? "Subsystem " + Long.toString(subsystem.getSubsystemId()) : name + " (" + Long.toString(subsystem.getSubsystemId()) + ")";
    }

    protected String generateFormattedOutput(Subsystem subsystem) {
        StringBuilder output = new StringBuilder();
        TreeMap otherAttribs = new TreeMap();
        TreeMap subsystemAttribs = new TreeMap();
        TreeMap serviceAttribs = new TreeMap();
        TreeMap packagesAttribs = new TreeMap();
        Map dict = subsystem.getSubsystemHeaders(null);
        for (String k : dict.keySet()) {
            Object v = dict.get(k);
            if (k.startsWith(SUBSYSTEM_PREFIX)) {
                subsystemAttribs.put(k, v);
                continue;
            }
            if (k.endsWith(SERVICE_SUFFIX) || k.endsWith(CAPABILITY_SUFFIX)) {
                serviceAttribs.put(k, v);
                continue;
            }
            if (k.endsWith(PACKAGE_SUFFFIX)) {
                packagesAttribs.put(k, v);
                continue;
            }
            if (k.endsWith(REQUIRE_BUNDLE_ATTRIB)) {
                packagesAttribs.put(k, v);
                continue;
            }
            otherAttribs.put(k, v);
        }
        for (Map.Entry e : otherAttribs.entrySet()) {
            output.append(String.format("%s = %s\n", e.getKey(), ShellUtil.getValueString(e.getValue())));
        }
        if (otherAttribs.size() > 0) {
            output.append('\n');
        }
        for (Map.Entry e : subsystemAttribs.entrySet()) {
            output.append((String)e.getKey());
            output.append(" = \n");
            this.formatHeader(ShellUtil.getValueString(e.getValue()), null, output, this.indent);
            output.append("\n");
        }
        if (subsystemAttribs.size() > 0) {
            output.append('\n');
        }
        for (Map.Entry e : serviceAttribs.entrySet()) {
            output.append((String)e.getKey());
            output.append(" = \n");
            this.formatHeader(ShellUtil.getValueString(e.getValue()), null, output, this.indent);
            output.append("\n");
        }
        if (serviceAttribs.size() > 0) {
            output.append('\n');
        }
        HashMap formatters = new HashMap();
        for (Map.Entry e : packagesAttribs.entrySet()) {
            output.append((String)e.getKey());
            output.append(" = \n");
            this.formatHeader(ShellUtil.getValueString(e.getValue()), (ClauseFormatter)formatters.get(e.getKey()), output, this.indent);
            output.append("\n");
        }
        if (packagesAttribs.size() > 0) {
            output.append('\n');
        }
        return output.toString();
    }

    protected void formatHeader(String header, ClauseFormatter formatter, StringBuilder builder, int indent) {
        Clause[] clauses = Parser.parseHeader(header);
        this.formatClauses(clauses, formatter, builder, indent);
    }

    protected void formatClauses(Clause[] clauses, ClauseFormatter formatter, StringBuilder builder, int indent) {
        boolean first = true;
        for (Clause clause : clauses) {
            if (first) {
                first = false;
            } else {
                builder.append(",\n");
            }
            this.formatClause(clause, formatter, builder, indent);
        }
    }

    protected void formatClause(Clause clause, ClauseFormatter formatter, StringBuilder builder, int indent) {
        builder.append("\t");
        if (formatter != null) {
            formatter.pre(clause, builder);
        }
        this.formatClause(clause, builder, indent);
        if (formatter != null) {
            formatter.post(clause, builder);
        }
    }

    protected int getTermWidth() {
        return this.terminal != null ? this.terminal.getWidth() : 80;
    }

    protected void formatClause(Clause clause, StringBuilder builder, int indent) {
        String v;
        int i;
        if (indent < 0) {
            indent = clause.toString().length() < this.getTermWidth() - 8 ? 1 : 3;
        }
        String name = clause.getName();
        Directive[] directives = clause.getDirectives();
        Attribute[] attributes = clause.getAttributes();
        Arrays.sort(directives, Comparator.comparing(Directive::getName));
        Arrays.sort(attributes, Comparator.comparing(Attribute::getName));
        builder.append(name);
        for (i = 0; directives != null && i < directives.length; ++i) {
            builder.append(";");
            if (indent > 1) {
                builder.append("\n\t\t");
            }
            builder.append(directives[i].getName()).append(":=");
            v = directives[i].getValue();
            if (v.contains(",")) {
                if (indent > 2 && v.length() > 20) {
                    v = v.replace(",", ",\n\t\t\t");
                }
                builder.append("\"").append(v).append("\"");
                continue;
            }
            builder.append(v);
        }
        for (i = 0; attributes != null && i < attributes.length; ++i) {
            builder.append(";");
            if (indent > 1) {
                builder.append("\n\t\t");
            }
            builder.append(attributes[i].getName()).append("=");
            v = attributes[i].getValue();
            if (v.contains(",")) {
                if (indent > 2 && v.length() > 20) {
                    v = v.replace(",", ",\n\t\t\t");
                }
                builder.append("\"").append(v).append("\"");
                continue;
            }
            builder.append(v);
        }
    }

    protected static interface ClauseFormatter {
        public void pre(Clause var1, StringBuilder var2);

        public void post(Clause var1, StringBuilder var2);
    }
}

