/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.subsystem.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.osgi.service.subsystem.Subsystem;

public abstract class SubsystemSupport {
    @Reference
    Subsystem subsystem;

    protected Subsystem getRoot() {
        Subsystem ss = this.subsystem;
        while (!ss.getParents().isEmpty()) {
            ss = (Subsystem)ss.getParents().iterator().next();
        }
        return ss;
    }

    protected Subsystem getSubsystem(String id) {
        List<Subsystem> subsystems = this.getSubsystems(id);
        int nb = subsystems.size();
        if (nb == 0) {
            throw new IllegalArgumentException("No subsystem matching " + id);
        }
        if (nb > 1) {
            throw new IllegalArgumentException("Multiple subsystems matching " + id);
        }
        return subsystems.get(0);
    }

    protected List<Subsystem> getSubsystems(String id) {
        Pattern p2;
        Pattern p1;
        if (id == null || id.isEmpty()) {
            return this.getSubsystems();
        }
        ArrayList<Subsystem> subsystems = new ArrayList<Subsystem>();
        Pattern pattern = Pattern.compile("^\\d+$");
        Matcher matcher = pattern.matcher(id);
        if (matcher.find()) {
            long lid = Long.parseLong(id);
            for (Subsystem ss : this.getSubsystems()) {
                if (ss.getSubsystemId() != lid) continue;
                subsystems.add(ss);
            }
            return subsystems;
        }
        pattern = Pattern.compile("^(\\d+)-(\\d+)$");
        matcher = pattern.matcher(id);
        if (matcher.find()) {
            int index = id.indexOf(45);
            long startId = Long.parseLong(id.substring(0, index));
            long endId = Long.parseLong(id.substring(index + 1));
            for (Subsystem ss : this.getSubsystems()) {
                if (startId > ss.getSubsystemId() || ss.getSubsystemId() > endId) continue;
                subsystems.add(ss);
            }
            return subsystems;
        }
        int index = id.indexOf(47);
        if (index < 0) {
            p1 = Pattern.compile(id);
            p2 = null;
        } else {
            p1 = Pattern.compile(id.substring(0, index));
            p2 = Pattern.compile(id.substring(index + 1));
        }
        for (Subsystem ss : this.getSubsystems()) {
            if (!p1.matcher(ss.getSymbolicName()).find() || p2 != null && !p2.matcher(ss.getVersion().toString()).find()) continue;
            subsystems.add(ss);
        }
        return subsystems;
    }

    protected List<Long> getSubsytemIds(Collection<Subsystem> subsystems) {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (Subsystem ss : subsystems) {
            long id = ss.getSubsystemId();
            if (ids.contains(id)) continue;
            ids.add(id);
        }
        Collections.sort(ids);
        return ids;
    }

    protected List<Subsystem> getSubsystems() {
        TreeMap<Long, Subsystem> subsystems = new TreeMap<Long, Subsystem>();
        this.doGetSubsystems(subsystems, this.getRoot());
        return new ArrayList<Subsystem>(subsystems.values());
    }

    private void doGetSubsystems(Map<Long, Subsystem> subsystems, Subsystem subsystem) {
        if (subsystems.put(subsystem.getSubsystemId(), subsystem) == null) {
            for (Subsystem child : subsystem.getChildren()) {
                this.doGetSubsystems(subsystems, child);
            }
        }
    }
}

