/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.undertow.weld.impl;

import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.InstanceHandle;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Unmanaged;

public class CdiInstanceFactory<T>
implements InstanceFactory<T> {
    private BeanManager beanManager;
    private Class<T> klass;

    public CdiInstanceFactory(BeanManager beanManager, Class<T> klass) {
        this.beanManager = beanManager;
        this.klass = klass;
    }

    public InstanceHandle<T> createInstance() throws InstantiationException {
        Unmanaged unmanaged = new Unmanaged(this.beanManager, this.klass);
        final Unmanaged.UnmanagedInstance unmanagedInstance = unmanaged.newInstance();
        final Object instance = unmanagedInstance.produce().inject().postConstruct().get();
        return new InstanceHandle<T>(){

            public T getInstance() {
                return instance;
            }

            public void release() {
                unmanagedInstance.preDestroy().dispose();
            }
        };
    }
}

