/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.transx.jdbc;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.TransactionSupport;
import javax.sql.CommonDataSource;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.ops4j.pax.transx.connection.ExceptionSorter;
import org.ops4j.pax.transx.connector.ConnectionManagerBuilder;
import org.ops4j.pax.transx.jdbc.impl.AbstractJdbcManagedConnectionFactory;
import org.ops4j.pax.transx.jdbc.impl.ConnectionPoolDataSourceMCF;
import org.ops4j.pax.transx.jdbc.impl.LocalDataSourceMCF;
import org.ops4j.pax.transx.jdbc.impl.XADataSourceMCF;
import org.ops4j.pax.transx.tm.TransactionManager;

public class ManagedDataSourceBuilder {
    private ConnectionManagerBuilder builder = ConnectionManagerBuilder.builder();
    private CommonDataSource dataSource;
    private ExceptionSorter exceptionSorter;
    private String userName;
    private String password;
    private boolean commitBeforeAutocommit;
    private int preparedStatementCacheSize = 0;
    private int transactionIsolationLevel = -1;
    private AbstractJdbcManagedConnectionFactory<?, ?, ?> managedConnectionFactory;

    private ManagedDataSourceBuilder() {
    }

    public static ManagedDataSourceBuilder builder() {
        return new ManagedDataSourceBuilder();
    }

    public ManagedDataSourceBuilder name(String name) {
        this.builder.name(name);
        return this;
    }

    public ManagedDataSourceBuilder dataSource(CommonDataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public ManagedDataSourceBuilder userName(String userName) {
        this.userName = userName;
        return this;
    }

    public ManagedDataSourceBuilder password(String password) {
        this.password = password;
        return this;
    }

    public ManagedDataSourceBuilder commitBeforeAutocommit(boolean commitBeforeAutocommit) {
        this.commitBeforeAutocommit = commitBeforeAutocommit;
        return this;
    }

    public ManagedDataSourceBuilder preparedStatementCacheSize(int preparedStatementCacheSize) {
        this.preparedStatementCacheSize = preparedStatementCacheSize;
        return this;
    }

    public ManagedDataSourceBuilder transactionIsolationLevel(int transactionIsolationLevel) {
        this.transactionIsolationLevel = transactionIsolationLevel;
        return this;
    }

    public ManagedDataSourceBuilder exceptionSorter(ExceptionSorter exceptionSorter) {
        this.exceptionSorter = exceptionSorter;
        return this;
    }

    public ManagedDataSourceBuilder transaction(TransactionSupport.TransactionSupportLevel tx) {
        this.builder.transaction(tx);
        return this;
    }

    public ManagedDataSourceBuilder transactionManager(TransactionManager transactionManager) {
        this.builder.transactionManager(transactionManager);
        return this;
    }

    public ManagedDataSourceBuilder minIdle(int minSize) {
        this.builder.minIdle(minSize);
        return this;
    }

    public ManagedDataSourceBuilder maxPoolSize(int maxPoolSize) {
        this.builder.maxPoolSize(maxPoolSize);
        return this;
    }

    public ManagedDataSourceBuilder aliveBypassWindow(long aliveBypassWindowMs) {
        this.builder.aliveBypassWindow(aliveBypassWindowMs);
        return this;
    }

    public ManagedDataSourceBuilder aliveBypassWindow(long aliveBypassWindow, TimeUnit unit) {
        this.builder.aliveBypassWindow(unit.toMillis(aliveBypassWindow));
        return this;
    }

    public ManagedDataSourceBuilder houseKeepingPeriod(long houseKeepingPeriodMs) {
        this.builder.houseKeepingPeriod(houseKeepingPeriodMs);
        return this;
    }

    public ManagedDataSourceBuilder houseKeepingPeriod(long houseKeepingPeriod, TimeUnit unit) {
        this.builder.houseKeepingPeriod(unit.toMillis(houseKeepingPeriod));
        return this;
    }

    public ManagedDataSourceBuilder connectionTimeout(long connectionTimeoutMs) {
        this.builder.connectionTimeout(connectionTimeoutMs);
        return this;
    }

    public ManagedDataSourceBuilder connectionTimeout(long connectionTimeout, TimeUnit unit) {
        this.builder.connectionTimeout(unit.toMillis(connectionTimeout));
        return this;
    }

    public ManagedDataSourceBuilder idleTimeout(long idleTimeoutMs) {
        this.builder.idleTimeout(idleTimeoutMs);
        return this;
    }

    public ManagedDataSourceBuilder idleTimeout(long idleTimeout, TimeUnit unit) {
        this.builder.idleTimeout(unit.toMillis(idleTimeout));
        return this;
    }

    public ManagedDataSourceBuilder maxLifetime(long maxLifetimeMs) {
        this.builder.maxLifetime(maxLifetimeMs);
        return this;
    }

    public ManagedDataSourceBuilder maxLifetime(long maxLifetime, TimeUnit unit) {
        this.builder.maxLifetime(unit.toMillis(maxLifetime));
        return this;
    }

    public ManagedDataSourceBuilder properties(Properties properties) {
        this.configure(properties::get);
        return this;
    }

    public ManagedDataSourceBuilder properties(Map<String, Object> properties) {
        this.configure(properties::get);
        return this;
    }

    private void configure(Function<String, Object> property) {
        Object maxLifetime;
        Object idleTimeout;
        Object connectionTimeout;
        Object houseKeepingPeriod;
        Object aliveBypassWindow;
        Object maxPoolSize;
        Object minIdle;
        Object transactionIsolationLevel;
        Object preparedStatementCacheSize;
        Object commitBeforeAutocommit;
        Object password;
        Object userName;
        Object name = property.apply("name");
        if (name != null) {
            this.name(name.toString());
        }
        if ((userName = property.apply("userName")) != null) {
            this.userName(userName.toString());
        }
        if ((password = property.apply("password")) != null) {
            this.password(password.toString());
        }
        if ((commitBeforeAutocommit = property.apply("commitBeforeAutocommit")) != null) {
            this.commitBeforeAutocommit("true".equalsIgnoreCase(commitBeforeAutocommit.toString()));
        }
        if ((preparedStatementCacheSize = property.apply("preparedStatementCacheSize")) != null) {
            this.preparedStatementCacheSize(this.toInt(preparedStatementCacheSize, "preparedStatementCacheSize"));
        }
        if ((transactionIsolationLevel = property.apply("transactionIsolationLevel")) != null) {
            this.transactionIsolationLevel(this.toInt(transactionIsolationLevel, "transactionIsolationLevel"));
        }
        if ((minIdle = property.apply("minIdle")) != null) {
            this.minIdle(this.toInt(minIdle, "minIdle"));
        }
        if ((maxPoolSize = property.apply("maxPoolSize")) != null) {
            this.maxPoolSize(this.toInt(maxPoolSize, "maxPoolSize"));
        }
        if ((aliveBypassWindow = property.apply("aliveBypassWindow")) != null) {
            this.aliveBypassWindow(this.toInt(aliveBypassWindow, "aliveBypassWindow"));
        }
        if ((houseKeepingPeriod = property.apply("houseKeepingPeriod")) != null) {
            this.houseKeepingPeriod(this.toInt(houseKeepingPeriod, "houseKeepingPeriod"));
        }
        if ((connectionTimeout = property.apply("connectionTimeout")) != null) {
            this.connectionTimeout(this.toInt(connectionTimeout, "connectionTimeout"));
        }
        if ((idleTimeout = property.apply("idleTimeout")) != null) {
            this.idleTimeout(this.toInt(idleTimeout, "idleTimeout"));
        }
        if ((maxLifetime = property.apply("maxLifetime")) != null) {
            this.maxLifetime(this.toInt(maxLifetime, "maxLifetime"));
        }
    }

    private int toInt(Object v, String property) {
        try {
            return Integer.parseInt(v.toString());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Can't parse property \"" + property + "\" as int");
        }
    }

    public DataSource build() throws Exception {
        if (this.dataSource == null) {
            throw new NullPointerException("dataSource must be set");
        }
        if (this.managedConnectionFactory == null) {
            this.managedConnectionFactory = ManagedDataSourceBuilder.create(this.dataSource);
        }
        if (this.exceptionSorter != null) {
            this.managedConnectionFactory.setExceptionSorter(this.exceptionSorter);
        }
        this.managedConnectionFactory.setUserName(this.userName);
        this.managedConnectionFactory.setPassword(this.password);
        this.managedConnectionFactory.setCommitBeforeAutocommit(this.commitBeforeAutocommit);
        this.managedConnectionFactory.setPreparedStatementCacheSize(this.preparedStatementCacheSize);
        this.managedConnectionFactory.setTransactionIsolationLevel(this.transactionIsolationLevel);
        this.builder.managedConnectionFactory(this.managedConnectionFactory);
        ConnectionManager cm = this.builder.build();
        return (DataSource)this.managedConnectionFactory.createConnectionFactory(cm);
    }

    private static AbstractJdbcManagedConnectionFactory<?, ?, ?> create(CommonDataSource dataSource) {
        if (dataSource instanceof XADataSource) {
            return new XADataSourceMCF((XADataSource)dataSource);
        }
        if (dataSource instanceof ConnectionPoolDataSource) {
            return new ConnectionPoolDataSourceMCF((ConnectionPoolDataSource)dataSource);
        }
        if (dataSource instanceof DataSource) {
            return new LocalDataSourceMCF((DataSource)dataSource);
        }
        throw new UnsupportedOperationException();
    }
}

