/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.transx.jdbc.impl;

import java.sql.Connection;
import java.sql.SQLException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.TransactionSupport;
import javax.security.auth.Subject;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.ops4j.pax.transx.connection.ExceptionSorter;
import org.ops4j.pax.transx.connection.NoExceptionsAreFatalSorter;
import org.ops4j.pax.transx.connection.utils.CredentialExtractor;
import org.ops4j.pax.transx.jdbc.impl.AbstractJdbcManagedConnectionFactory;
import org.ops4j.pax.transx.jdbc.impl.ManagedPooledConnection;

public class ConnectionPoolDataSourceMCF
extends AbstractJdbcManagedConnectionFactory<ConnectionPoolDataSourceMCF, ManagedPooledConnection, ConnectionPoolDataSource> {
    public ConnectionPoolDataSourceMCF(ConnectionPoolDataSource connectionPoolDataSource) {
        this(connectionPoolDataSource, (ExceptionSorter)new NoExceptionsAreFatalSorter());
    }

    public ConnectionPoolDataSourceMCF(ConnectionPoolDataSource connectionPoolDataSource, ExceptionSorter exceptionSorter) {
        super(connectionPoolDataSource, exceptionSorter);
    }

    public TransactionSupport.TransactionSupportLevel getTransactionSupport() {
        return TransactionSupport.TransactionSupportLevel.LocalTransaction;
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        CredentialExtractor credentialExtractor = new CredentialExtractor(subject, connectionRequestInfo, this);
        PooledConnection sqlConnection = this.getPhysicalConnection(credentialExtractor);
        try {
            Connection pc = this.wrap(sqlConnection.getConnection());
            return new ManagedPooledConnection(this, sqlConnection, pc, credentialExtractor, this.exceptionSorter);
        }
        catch (SQLException e) {
            throw new ResourceAdapterInternalException("Could not set up ManagedPooledConnection", (Throwable)e);
        }
    }

    protected PooledConnection getPhysicalConnection(CredentialExtractor credentialExtractor) throws ResourceException {
        try {
            String username = credentialExtractor.getUserName();
            String password = credentialExtractor.getPassword();
            if (username != null) {
                return ((ConnectionPoolDataSource)this.dataSource).getPooledConnection(username, password);
            }
            return ((ConnectionPoolDataSource)this.dataSource).getPooledConnection();
        }
        catch (SQLException e) {
            throw new ResourceAdapterInternalException("Unable to obtain physical connection to " + this.dataSource, (Throwable)e);
        }
    }
}

