/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.transx.jdbc.impl;

import java.util.Arrays;
import java.util.Objects;
import org.ops4j.pax.transx.jdbc.impl.ConnectionWrapper;
import org.ops4j.pax.transx.jdbc.impl.PreparedStatementWrapper;

public class PreparedStatementKey {
    private static final int PREPARED_STMT_FORMAT_1 = 1;
    private static final int PREPARED_STMT_FORMAT_2 = 2;
    private static final int PREPARED_STMT_FORMAT_3 = 3;
    private static final int PREPARED_STMT_FORMAT_4 = 4;
    private static final int PREPARED_STMT_FORMAT_5 = 5;
    private static final int PREPARED_STMT_FORMAT_6 = 6;
    private static final int[] NULL_INT_ARRAY = new int[]{0};
    private static final String[] NULL_STRING_ARRAY = new String[]{""};
    private final ConnectionWrapper c;
    private final String sql;
    private final int stmtFormat;
    private final int parm0;
    private final int parm1;
    private final int parm2;
    private final int[] columnIndexes;
    private final String[] columnNames;
    private PreparedStatementWrapper psw = null;

    public PreparedStatementKey(ConnectionWrapper c, String sql) {
        this(c, sql, 1, 0, 0, 0, NULL_INT_ARRAY, NULL_STRING_ARRAY);
    }

    public PreparedStatementKey(ConnectionWrapper c, String sql, int autoGeneratedKeys) {
        this(c, sql, 2, autoGeneratedKeys, 0, 0, NULL_INT_ARRAY, NULL_STRING_ARRAY);
    }

    public PreparedStatementKey(ConnectionWrapper c, String sql, int resultSetType, int resultSetConcurrency) {
        this(c, sql, 3, resultSetType, resultSetConcurrency, 0, NULL_INT_ARRAY, NULL_STRING_ARRAY);
    }

    public PreparedStatementKey(ConnectionWrapper c, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        this(c, sql, 4, resultSetType, resultSetConcurrency, resultSetHoldability, NULL_INT_ARRAY, NULL_STRING_ARRAY);
    }

    public PreparedStatementKey(ConnectionWrapper c, String sql, int[] columnIndexes) {
        this(c, sql, 5, 0, 0, 0, (int[])columnIndexes.clone(), NULL_STRING_ARRAY);
    }

    public PreparedStatementKey(ConnectionWrapper c, String sql, String[] columnNames) {
        this(c, sql, 6, 0, 0, 0, NULL_INT_ARRAY, (String[])columnNames.clone());
    }

    public PreparedStatementKey(ConnectionWrapper c, String sql, int stmtFormat, int parm0, int parm1, int parm2, int[] columnIndexes, String[] columnNames) {
        this.c = c;
        this.sql = sql;
        this.stmtFormat = stmtFormat;
        this.parm0 = parm0;
        this.parm1 = parm1;
        this.parm2 = parm2;
        this.columnIndexes = columnIndexes;
        this.columnNames = columnNames;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PreparedStatementKey that = (PreparedStatementKey)o;
        return this.stmtFormat == that.stmtFormat && this.parm0 == that.parm0 && this.parm1 == that.parm1 && this.parm2 == that.parm2 && Objects.equals(this.sql, that.sql) && Arrays.equals(this.columnIndexes, that.columnIndexes) && Arrays.equals(this.columnNames, that.columnNames);
    }

    public String getSql() {
        return this.sql;
    }

    public int hashCode() {
        return Objects.hash(this.stmtFormat, this.sql, this.parm0, this.parm1, this.parm2, this.columnIndexes, this.columnNames);
    }

    public void setPreparedStatementWrapper(PreparedStatementWrapper psw) {
        this.psw = psw;
    }

    public PreparedStatementWrapper getPreparedStatementWrapper() {
        return this.psw;
    }
}

