/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.gson;

import com.google.common.annotations.Beta;
import com.google.common.base.Verify;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.codec.gson.BooleanJSONCodec;
import org.opendaylight.yangtools.yang.data.codec.gson.EmptyJSONCodec;
import org.opendaylight.yangtools.yang.data.codec.gson.IdentityrefJSONCodec;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodec;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodecFactorySupplier;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONInstanceIdentifierCodec;
import org.opendaylight.yangtools.yang.data.codec.gson.NullJSONCodec;
import org.opendaylight.yangtools.yang.data.codec.gson.NumberJSONCodec;
import org.opendaylight.yangtools.yang.data.codec.gson.QuotedJSONCodec;
import org.opendaylight.yangtools.yang.data.codec.gson.UnionJSONCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.AbstractIntegerStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.BinaryStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.BitsStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.BooleanStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.DataStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.DecimalStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.EnumStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.StringStringCodec;
import org.opendaylight.yangtools.yang.data.util.codec.AbstractCodecFactory;
import org.opendaylight.yangtools.yang.data.util.codec.CodecCache;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.type.BinaryTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BooleanTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.DecimalTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EmptyTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.IdentityrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.InstanceIdentifierTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int16TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int32TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int64TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int8TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.StringTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint16TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint32TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint64TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint8TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnionTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnknownTypeDefinition;

@Beta
public final class JSONCodecFactory
extends AbstractCodecFactory<JSONCodec<?>> {
    private final JSONCodec<?> iidCodec;

    JSONCodecFactory(SchemaContext context, CodecCache<JSONCodec<?>> cache, BiFunction<SchemaContext, JSONCodecFactory, JSONInstanceIdentifierCodec> iidCodecSupplier) {
        super(context, cache);
        this.iidCodec = (JSONCodec)Verify.verifyNotNull((Object)iidCodecSupplier.apply(context, this));
    }

    @Deprecated
    public static JSONCodecFactory getPrecomputed(SchemaContext context) {
        return JSONCodecFactorySupplier.DRAFT_LHOTKA_NETMOD_YANG_JSON_02.getPrecomputed(context);
    }

    @Deprecated
    public static Optional<JSONCodecFactory> getPrecomputedIfAvailable(SchemaContext context) {
        return JSONCodecFactorySupplier.DRAFT_LHOTKA_NETMOD_YANG_JSON_02.getPrecomputedIfAvailable(context);
    }

    @Deprecated
    public static JSONCodecFactory getShared(SchemaContext context) {
        return JSONCodecFactorySupplier.DRAFT_LHOTKA_NETMOD_YANG_JSON_02.getShared(context);
    }

    @Deprecated
    public static JSONCodecFactory createLazy(SchemaContext context) {
        return JSONCodecFactorySupplier.DRAFT_LHOTKA_NETMOD_YANG_JSON_02.createLazy(context);
    }

    @Deprecated
    public static JSONCodecFactory createSimple(SchemaContext context) {
        return JSONCodecFactorySupplier.DRAFT_LHOTKA_NETMOD_YANG_JSON_02.createSimple(context);
    }

    protected JSONCodec<?> binaryCodec(BinaryTypeDefinition type) {
        return new QuotedJSONCodec(BinaryStringCodec.from((BinaryTypeDefinition)type));
    }

    protected JSONCodec<?> booleanCodec(BooleanTypeDefinition type) {
        return new BooleanJSONCodec((DataStringCodec<Boolean>)BooleanStringCodec.from((BooleanTypeDefinition)type));
    }

    protected JSONCodec<?> bitsCodec(BitsTypeDefinition type) {
        return new QuotedJSONCodec(BitsStringCodec.from((BitsTypeDefinition)type));
    }

    protected JSONCodec<?> decimalCodec(DecimalTypeDefinition type) {
        return new NumberJSONCodec(DecimalStringCodec.from((DecimalTypeDefinition)type));
    }

    protected JSONCodec<?> emptyCodec(EmptyTypeDefinition type) {
        return EmptyJSONCodec.INSTANCE;
    }

    protected JSONCodec<?> enumCodec(EnumTypeDefinition type) {
        return new QuotedJSONCodec(EnumStringCodec.from((EnumTypeDefinition)type));
    }

    protected JSONCodec<?> identityRefCodec(IdentityrefTypeDefinition type, QNameModule module) {
        return new IdentityrefJSONCodec(this.getSchemaContext(), module);
    }

    protected JSONCodec<?> instanceIdentifierCodec(InstanceIdentifierTypeDefinition type) {
        return this.iidCodec;
    }

    protected JSONCodec<?> int8Codec(Int8TypeDefinition type) {
        return new NumberJSONCodec(AbstractIntegerStringCodec.from((Int8TypeDefinition)type));
    }

    protected JSONCodec<?> int16Codec(Int16TypeDefinition type) {
        return new NumberJSONCodec(AbstractIntegerStringCodec.from((Int16TypeDefinition)type));
    }

    protected JSONCodec<?> int32Codec(Int32TypeDefinition type) {
        return new NumberJSONCodec(AbstractIntegerStringCodec.from((Int32TypeDefinition)type));
    }

    protected JSONCodec<?> int64Codec(Int64TypeDefinition type) {
        return new NumberJSONCodec(AbstractIntegerStringCodec.from((Int64TypeDefinition)type));
    }

    protected JSONCodec<?> stringCodec(StringTypeDefinition type) {
        return new QuotedJSONCodec(StringStringCodec.from((StringTypeDefinition)type));
    }

    protected JSONCodec<?> uint8Codec(Uint8TypeDefinition type) {
        return new NumberJSONCodec(AbstractIntegerStringCodec.from((Uint8TypeDefinition)type));
    }

    protected JSONCodec<?> uint16Codec(Uint16TypeDefinition type) {
        return new NumberJSONCodec(AbstractIntegerStringCodec.from((Uint16TypeDefinition)type));
    }

    protected JSONCodec<?> uint32Codec(Uint32TypeDefinition type) {
        return new NumberJSONCodec(AbstractIntegerStringCodec.from((Uint32TypeDefinition)type));
    }

    protected JSONCodec<?> uint64Codec(Uint64TypeDefinition type) {
        return new NumberJSONCodec(AbstractIntegerStringCodec.from((Uint64TypeDefinition)type));
    }

    protected JSONCodec<?> unionCodec(UnionTypeDefinition type, List<JSONCodec<?>> codecs) {
        return UnionJSONCodec.create(type, codecs);
    }

    protected JSONCodec<?> unknownCodec(UnknownTypeDefinition type) {
        return NullJSONCodec.INSTANCE;
    }
}

