/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.store.inmemory;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.spi.AbstractDOMDataTreeChangeListenerRegistration;
import org.opendaylight.mdsal.dom.spi.RegistrationTreeNode;
import org.opendaylight.mdsal.dom.spi.shard.ChildShardContext;
import org.opendaylight.mdsal.dom.spi.store.AbstractDOMStoreTreeChangePublisher;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreTreeChangePublisher;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTree;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidateNodes;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidates;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModification;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataValidationFailedException;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.DataContainerNodeAttrBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableMapEntryNodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractDOMShardTreeChangePublisher
extends AbstractDOMStoreTreeChangePublisher {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDOMShardTreeChangePublisher.class);
    private final YangInstanceIdentifier shardPath;
    private final Map<DOMDataTreeIdentifier, ChildShardContext> childShards;
    private final DataTree dataTree;

    protected AbstractDOMShardTreeChangePublisher(DataTree dataTree, YangInstanceIdentifier shardPath, Map<DOMDataTreeIdentifier, ChildShardContext> childShards) {
        this.dataTree = Objects.requireNonNull(dataTree);
        this.shardPath = Objects.requireNonNull(shardPath);
        this.childShards = Objects.requireNonNull(childShards);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <L extends DOMDataTreeChangeListener> AbstractDOMDataTreeChangeListenerRegistration<L> registerTreeChangeListener(YangInstanceIdentifier path, L listener) {
        this.takeLock();
        try {
            AbstractDOMDataTreeChangeListenerRegistration<L> abstractDOMDataTreeChangeListenerRegistration = this.setupListenerContext(path, listener);
            return abstractDOMDataTreeChangeListenerRegistration;
        }
        finally {
            this.releaseLock();
        }
    }

    private <L extends DOMDataTreeChangeListener> AbstractDOMDataTreeChangeListenerRegistration<L> setupListenerContext(YangInstanceIdentifier listenerPath, L listener) {
        YangInstanceIdentifier strippedIdentifier = listenerPath;
        if (!this.shardPath.isEmpty()) {
            strippedIdentifier = YangInstanceIdentifier.create(this.stripShardPath(listenerPath));
        }
        DOMDataTreeListenerWithSubshards subshardListener = new DOMDataTreeListenerWithSubshards(this.dataTree, strippedIdentifier, listener);
        AbstractDOMDataTreeChangeListenerRegistration<L> reg = this.setupContextWithoutSubshards(strippedIdentifier, subshardListener);
        for (ChildShardContext maybeAffected : this.childShards.values()) {
            if (listenerPath.contains(maybeAffected.getPrefix().getRootIdentifier())) {
                LOG.debug("Adding new subshard{{}} to listener at {}", (Object)maybeAffected.getPrefix(), (Object)listenerPath);
                subshardListener.addSubshard(maybeAffected);
                continue;
            }
            if (!maybeAffected.getPrefix().getRootIdentifier().contains(listenerPath)) continue;
            throw new UnsupportedOperationException("Listener should be registered directly into initialDataChangeEvent subshard");
        }
        this.initialDataChangeEvent(listenerPath, listener);
        return reg;
    }

    private <L extends DOMDataTreeChangeListener> void initialDataChangeEvent(YangInstanceIdentifier listenerPath, L listener) {
        DataTreeCandidate initialCandidate;
        Optional preExistingData = this.dataTree.takeSnapshot().readNode(YangInstanceIdentifier.create(this.stripShardPath(listenerPath)));
        if (preExistingData.isPresent()) {
            NormalizedNode data = (NormalizedNode)preExistingData.get();
            Preconditions.checkState((boolean)(data instanceof DataContainerNode), (String)"Expected DataContainer node, but was {}", data.getClass());
            initialCandidate = ((DataContainerNode)data).getValue().isEmpty() ? DataTreeCandidates.newDataTreeCandidate((YangInstanceIdentifier)listenerPath, (DataTreeCandidateNode)DataTreeCandidateNodes.empty((YangInstanceIdentifier.PathArgument)data.getIdentifier())) : DataTreeCandidates.fromNormalizedNode((YangInstanceIdentifier)listenerPath, AbstractDOMShardTreeChangePublisher.translateRootShardIdentifierToListenerPath(listenerPath, (NormalizedNode)preExistingData.get()));
        } else {
            initialCandidate = DataTreeCandidates.newDataTreeCandidate((YangInstanceIdentifier)listenerPath, (DataTreeCandidateNode)DataTreeCandidateNodes.empty((YangInstanceIdentifier.PathArgument)listenerPath.getLastPathArgument()));
        }
        listener.onDataTreeChanged(Collections.singleton(initialCandidate));
    }

    private static NormalizedNode<?, ?> translateRootShardIdentifierToListenerPath(YangInstanceIdentifier listenerPath, NormalizedNode<?, ?> node) {
        DataContainerNodeAttrBuilder nodeBuilder;
        if (listenerPath.isEmpty()) {
            return node;
        }
        if (node instanceof ContainerNode) {
            nodeBuilder = ImmutableContainerNodeBuilder.create().withValue(((ContainerNode)node).getValue());
        } else if (node instanceof MapEntryNode) {
            nodeBuilder = ImmutableMapEntryNodeBuilder.create().withValue(((MapEntryNode)node).getValue());
        } else {
            throw new IllegalArgumentException("Expected ContainerNode or MapEntryNode, but was " + node.getClass());
        }
        nodeBuilder.withNodeIdentifier(listenerPath.getLastPathArgument());
        return nodeBuilder.build();
    }

    private <L extends DOMDataTreeChangeListener> AbstractDOMDataTreeChangeListenerRegistration<L> setupContextWithoutSubshards(YangInstanceIdentifier listenerPath, final DOMDataTreeListenerWithSubshards listener) {
        LOG.debug("Registering root listener at {}", (Object)listenerPath);
        final RegistrationTreeNode node = this.findNodeFor(listenerPath.getPathArguments());
        AbstractDOMDataTreeChangeListenerRegistration registration = new AbstractDOMDataTreeChangeListenerRegistration<L>(listener){

            protected void removeRegistration() {
                listener.close();
                AbstractDOMShardTreeChangePublisher.this.removeRegistration(node, (Object)this);
                AbstractDOMShardTreeChangePublisher.this.registrationRemoved(this);
            }
        };
        this.addRegistration(node, registration);
        return registration;
    }

    private Iterable<YangInstanceIdentifier.PathArgument> stripShardPath(YangInstanceIdentifier listenerPath) {
        if (this.shardPath.isEmpty()) {
            return listenerPath.getPathArguments();
        }
        ArrayList<YangInstanceIdentifier.PathArgument> listenerPathArgs = new ArrayList<YangInstanceIdentifier.PathArgument>(listenerPath.getPathArguments());
        Iterator shardIter = this.shardPath.getPathArguments().iterator();
        Iterator listenerIter = listenerPathArgs.iterator();
        while (shardIter.hasNext() && ((YangInstanceIdentifier.PathArgument)shardIter.next()).equals(listenerIter.next())) {
            listenerIter.remove();
        }
        return listenerPathArgs;
    }

    private static final class DOMDataTreeListenerWithSubshards
    implements DOMDataTreeChangeListener {
        private final DataTree dataTree;
        private final YangInstanceIdentifier listenerPath;
        private final DOMDataTreeChangeListener delegate;
        private final Map<YangInstanceIdentifier, ListenerRegistration<DOMDataTreeChangeListener>> registrations = new HashMap<YangInstanceIdentifier, ListenerRegistration<DOMDataTreeChangeListener>>();

        DOMDataTreeListenerWithSubshards(DataTree dataTree, YangInstanceIdentifier listenerPath, DOMDataTreeChangeListener delegate) {
            this.dataTree = Objects.requireNonNull(dataTree);
            this.listenerPath = Objects.requireNonNull(listenerPath);
            this.delegate = Objects.requireNonNull(delegate);
        }

        public void onDataTreeChanged(Collection<DataTreeCandidate> changes) {
            LOG.debug("Received data changed {}", changes);
            this.delegate.onDataTreeChanged(changes);
        }

        void onDataTreeChanged(YangInstanceIdentifier rootPath, Collection<DataTreeCandidate> changes) {
            List<DataTreeCandidate> newCandidates = changes.stream().map(candidate -> DataTreeCandidates.newDataTreeCandidate((YangInstanceIdentifier)rootPath, (DataTreeCandidateNode)candidate.getRootNode())).collect(Collectors.toList());
            this.delegate.onDataTreeChanged(Collections.singleton(this.applyChanges(newCandidates)));
        }

        void addSubshard(ChildShardContext context) {
            Preconditions.checkState((boolean)(context.getShard() instanceof DOMStoreTreeChangePublisher), (Object)"All subshards that are initialDataChangeEvent part of ListenerContext need to be listenable");
            DOMStoreTreeChangePublisher listenableShard = (DOMStoreTreeChangePublisher)context.getShard();
            this.registrations.put(context.getPrefix().getRootIdentifier(), (ListenerRegistration<DOMDataTreeChangeListener>)listenableShard.registerTreeChangeListener(context.getPrefix().getRootIdentifier(), changes -> this.onDataTreeChanged(context.getPrefix().getRootIdentifier(), changes)));
        }

        void close() {
            for (ListenerRegistration<DOMDataTreeChangeListener> registration : this.registrations.values()) {
                registration.close();
            }
            this.registrations.clear();
        }

        private DataTreeCandidate applyChanges(Collection<DataTreeCandidate> changes) {
            DataTreeModification modification = this.dataTree.takeSnapshot().newModification();
            for (DataTreeCandidate change : changes) {
                DataTreeCandidates.applyToModification((DataTreeModification)modification, (DataTreeCandidate)change);
            }
            modification.ready();
            try {
                this.dataTree.validate(modification);
            }
            catch (DataValidationFailedException e) {
                LOG.error("Validation failed for built modification", (Throwable)e);
                throw new IllegalStateException("Notification validation failed", e);
            }
            DataTreeCandidateNode modifiedChild = this.dataTree.prepare(modification).getRootNode();
            for (YangInstanceIdentifier.PathArgument pathArgument : this.listenerPath.getPathArguments()) {
                modifiedChild = modifiedChild.getModifiedChild(pathArgument);
            }
            if (modifiedChild == null) {
                modifiedChild = DataTreeCandidateNodes.empty((YangInstanceIdentifier.PathArgument)this.listenerPath.getLastPathArgument());
            }
            return DataTreeCandidates.newDataTreeCandidate((YangInstanceIdentifier)this.listenerPath, (DataTreeCandidateNode)modifiedChild);
        }
    }
}

