/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.store.inmemory;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;
import org.opendaylight.mdsal.common.api.TransactionCommitFailedException;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.mdsal.dom.store.inmemory.InMemoryDOMDataTreeShardChangePublisher;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTree;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModification;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataValidationFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InMemoryDOMDataTreeShardThreePhaseCommitCohort
implements DOMStoreThreePhaseCommitCohort {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryDOMDataTreeShardThreePhaseCommitCohort.class);
    private static final ListenableFuture<Void> SUCCESSFUL_FUTURE = Futures.immediateFuture(null);
    private static final ListenableFuture<Boolean> CAN_COMMIT_FUTURE = Futures.immediateFuture((Object)Boolean.TRUE);
    private final DataTree dataTree;
    private final DataTreeModification modification;
    private DataTreeCandidate candidate;
    private final InMemoryDOMDataTreeShardChangePublisher changePublisher;

    InMemoryDOMDataTreeShardThreePhaseCommitCohort(DataTree dataTree, DataTreeModification modification, InMemoryDOMDataTreeShardChangePublisher changePublisher) {
        this.dataTree = Objects.requireNonNull(dataTree);
        this.modification = Objects.requireNonNull(modification);
        this.changePublisher = Objects.requireNonNull(changePublisher);
    }

    public ListenableFuture<Boolean> canCommit() {
        try {
            this.dataTree.validate(this.modification);
            LOG.debug("DataTreeModification {} validated", (Object)this.modification);
            return CAN_COMMIT_FUTURE;
        }
        catch (DataValidationFailedException e) {
            LOG.warn("Data validation failed for {}", (Object)this.modification);
            LOG.trace("dataTree : {}", (Object)this.dataTree);
            return Futures.immediateFailedFuture((Throwable)new TransactionCommitFailedException("Data did not pass validation.", (Throwable)e, new RpcError[0]));
        }
        catch (Exception e) {
            LOG.warn("Unexpected failure in validation phase", (Throwable)e);
            return Futures.immediateFailedFuture((Throwable)e);
        }
    }

    public ListenableFuture<Void> preCommit() {
        try {
            this.candidate = this.dataTree.prepare(this.modification);
            LOG.debug("DataTreeModification {} prepared", (Object)this.modification);
            return SUCCESSFUL_FUTURE;
        }
        catch (Exception e) {
            LOG.warn("Unexpected failure in preparation phase", (Throwable)e);
            return Futures.immediateFailedFuture((Throwable)e);
        }
    }

    public ListenableFuture<Void> abort() {
        this.candidate = null;
        return SUCCESSFUL_FUTURE;
    }

    public ListenableFuture<Void> commit() {
        Preconditions.checkState((this.candidate != null ? 1 : 0) != 0, (Object)"Attempted to commit an aborted transaction");
        LOG.debug("Commiting candidate {}", (Object)this.candidate);
        this.dataTree.commit(this.candidate);
        this.changePublisher.publishChange(this.candidate);
        return SUCCESSFUL_FUTURE;
    }
}

