/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.blueprint.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class AnnotationScanner {
    public List<AccessibleObject> getJpaAnnotatedMembers(Class<?> c, Class<? extends Annotation> annotation) {
        ArrayList<AccessibleObject> jpaAnnotated = new ArrayList<AccessibleObject>();
        for (Class<?> cl = c; cl != Object.class && cl != null; cl = cl.getSuperclass()) {
            AnnotationScanner.parseClass(annotation, jpaAnnotated, cl);
        }
        return jpaAnnotated;
    }

    private static void parseClass(Class<? extends Annotation> annotation, List<AccessibleObject> jpaAnnotated, Class<?> cl) {
        for (Field field : cl.getDeclaredFields()) {
            if (!field.isAnnotationPresent(annotation)) continue;
            field.setAccessible(true);
            jpaAnnotated.add(field);
        }
        for (AccessibleObject accessibleObject : cl.getDeclaredMethods()) {
            if (!accessibleObject.isAnnotationPresent(annotation) || !((Method)accessibleObject).getName().startsWith("set") || ((Method)accessibleObject).getParameterTypes().length != 1) continue;
            jpaAnnotated.add(accessibleObject);
        }
    }

    public static String getName(AccessibleObject member) {
        if (member instanceof Field) {
            return ((Field)member).getName();
        }
        if (member instanceof Method) {
            Method method = (Method)member;
            String name = method.getName();
            if (!name.startsWith("set")) {
                return null;
            }
            return AnnotationScanner.lowerCamelCase(name.substring(3));
        }
        throw new IllegalArgumentException();
    }

    private static String lowerCamelCase(String name) {
        return name.substring(0, 1).toLowerCase() + name.substring(1);
    }

    public static Class<?> getType(AccessibleObject member) {
        if (member instanceof Field) {
            return ((Field)member).getType();
        }
        if (member instanceof Method) {
            return ((Method)member).getParameterTypes()[0];
        }
        throw new IllegalArgumentException();
    }
}

