/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.restconf;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.restconf.Restconf;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.restconf.restconf.Config;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.restconf.restconf.Modules;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.restconf.restconf.Operational;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.restconf.restconf.Operations;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.restconf.restconf.Streams;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class RestconfBuilder
implements Builder<Restconf> {
    private Config _config;
    private Modules _modules;
    private Operational _operational;
    private Operations _operations;
    private Streams _streams;
    private Restconf.Version _version;
    Map<Class<? extends Augmentation<Restconf>>, Augmentation<Restconf>> augmentation = Collections.emptyMap();

    public RestconfBuilder() {
    }

    public RestconfBuilder(Restconf base) {
        Map aug;
        this._config = base.getConfig();
        this._modules = base.getModules();
        this._operational = base.getOperational();
        this._operations = base.getOperations();
        this._streams = base.getStreams();
        this._version = base.getVersion();
        if (base instanceof RestconfImpl) {
            RestconfImpl impl = (RestconfImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Restconf>>, Augmentation<Restconf>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Restconf>>, Augmentation<Restconf>>(aug);
        }
    }

    public Config getConfig() {
        return this._config;
    }

    public Modules getModules() {
        return this._modules;
    }

    public Operational getOperational() {
        return this._operational;
    }

    public Operations getOperations() {
        return this._operations;
    }

    public Streams getStreams() {
        return this._streams;
    }

    public Restconf.Version getVersion() {
        return this._version;
    }

    public <E$$ extends Augmentation<Restconf>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public RestconfBuilder setConfig(Config value) {
        this._config = value;
        return this;
    }

    public RestconfBuilder setModules(Modules value) {
        this._modules = value;
        return this;
    }

    public RestconfBuilder setOperational(Operational value) {
        this._operational = value;
        return this;
    }

    public RestconfBuilder setOperations(Operations value) {
        this._operations = value;
        return this;
    }

    public RestconfBuilder setStreams(Streams value) {
        this._streams = value;
        return this;
    }

    public RestconfBuilder setVersion(Restconf.Version value) {
        this._version = value;
        return this;
    }

    public RestconfBuilder addAugmentation(Class<? extends Augmentation<Restconf>> augmentationType, Augmentation<Restconf> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Restconf>>, Augmentation<Restconf>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public RestconfBuilder removeAugmentation(Class<? extends Augmentation<Restconf>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Restconf build() {
        return new RestconfImpl(this);
    }

    private static final class RestconfImpl
    implements Restconf {
        private final Config _config;
        private final Modules _modules;
        private final Operational _operational;
        private final Operations _operations;
        private final Streams _streams;
        private final Restconf.Version _version;
        private Map<Class<? extends Augmentation<Restconf>>, Augmentation<Restconf>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        RestconfImpl(RestconfBuilder base) {
            this._config = base.getConfig();
            this._modules = base.getModules();
            this._operational = base.getOperational();
            this._operations = base.getOperations();
            this._streams = base.getStreams();
            this._version = base.getVersion();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Restconf> getImplementedInterface() {
            return Restconf.class;
        }

        @Override
        public Config getConfig() {
            return this._config;
        }

        @Override
        public Modules getModules() {
            return this._modules;
        }

        @Override
        public Operational getOperational() {
            return this._operational;
        }

        @Override
        public Operations getOperations() {
            return this._operations;
        }

        @Override
        public Streams getStreams() {
            return this._streams;
        }

        @Override
        public Restconf.Version getVersion() {
            return this._version;
        }

        public <E$$ extends Augmentation<Restconf>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._config);
            result = 31 * result + Objects.hashCode(this._modules);
            result = 31 * result + Objects.hashCode(this._operational);
            result = 31 * result + Objects.hashCode(this._operations);
            result = 31 * result + Objects.hashCode(this._streams);
            result = 31 * result + Objects.hashCode((Object)this._version);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Restconf.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Restconf other = (Restconf)obj;
            if (!Objects.equals(this._config, other.getConfig())) {
                return false;
            }
            if (!Objects.equals(this._modules, other.getModules())) {
                return false;
            }
            if (!Objects.equals(this._operational, other.getOperational())) {
                return false;
            }
            if (!Objects.equals(this._operations, other.getOperations())) {
                return false;
            }
            if (!Objects.equals(this._streams, other.getStreams())) {
                return false;
            }
            if (!Objects.equals((Object)this._version, (Object)other.getVersion())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                RestconfImpl otherImpl = (RestconfImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Restconf>>, Augmentation<Restconf>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Restconf");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_config", (Object)this._config);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_modules", (Object)this._modules);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_operational", (Object)this._operational);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_operations", (Object)this._operations);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_streams", (Object)this._streams);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_version", (Object)((Object)this._version));
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

