/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.yang.patch.yang.patch;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.DataResourceIdentifier;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.yang.patch.yang.patch.Edit;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.yang.patch.yang.patch.EditKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class EditBuilder
implements Builder<Edit> {
    private String _editId;
    private Edit.Operation _operation;
    private DataResourceIdentifier _point;
    private DataResourceIdentifier _target;
    private Edit.Where _where;
    private EditKey key;
    Map<Class<? extends Augmentation<Edit>>, Augmentation<Edit>> augmentation = Collections.emptyMap();

    public EditBuilder() {
    }

    public EditBuilder(Edit base) {
        Map aug;
        this.key = base.key();
        this._editId = base.getEditId();
        this._operation = base.getOperation();
        this._point = base.getPoint();
        this._target = base.getTarget();
        this._where = base.getWhere();
        if (base instanceof EditImpl) {
            EditImpl impl = (EditImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Edit>>, Augmentation<Edit>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Edit>>, Augmentation<Edit>>(aug);
        }
    }

    public EditKey key() {
        return this.key;
    }

    public String getEditId() {
        return this._editId;
    }

    public Edit.Operation getOperation() {
        return this._operation;
    }

    public DataResourceIdentifier getPoint() {
        return this._point;
    }

    public DataResourceIdentifier getTarget() {
        return this._target;
    }

    public Edit.Where getWhere() {
        return this._where;
    }

    public <E$$ extends Augmentation<Edit>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public EditBuilder withKey(EditKey key) {
        this.key = key;
        return this;
    }

    public EditBuilder setEditId(String value) {
        this._editId = value;
        return this;
    }

    public EditBuilder setOperation(Edit.Operation value) {
        this._operation = value;
        return this;
    }

    public EditBuilder setPoint(DataResourceIdentifier value) {
        this._point = value;
        return this;
    }

    public EditBuilder setTarget(DataResourceIdentifier value) {
        this._target = value;
        return this;
    }

    public EditBuilder setWhere(Edit.Where value) {
        this._where = value;
        return this;
    }

    public EditBuilder addAugmentation(Class<? extends Augmentation<Edit>> augmentationType, Augmentation<Edit> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Edit>>, Augmentation<Edit>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public EditBuilder removeAugmentation(Class<? extends Augmentation<Edit>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Edit build() {
        return new EditImpl(this);
    }

    private static final class EditImpl
    implements Edit {
        private final String _editId;
        private final Edit.Operation _operation;
        private final DataResourceIdentifier _point;
        private final DataResourceIdentifier _target;
        private final Edit.Where _where;
        private final EditKey key;
        private Map<Class<? extends Augmentation<Edit>>, Augmentation<Edit>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        EditImpl(EditBuilder base) {
            this.key = base.key() != null ? base.key() : new EditKey(base.getEditId());
            this._editId = this.key.getEditId();
            this._operation = base.getOperation();
            this._point = base.getPoint();
            this._target = base.getTarget();
            this._where = base.getWhere();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Edit> getImplementedInterface() {
            return Edit.class;
        }

        @Override
        public EditKey key() {
            return this.key;
        }

        @Override
        public String getEditId() {
            return this._editId;
        }

        @Override
        public Edit.Operation getOperation() {
            return this._operation;
        }

        @Override
        public DataResourceIdentifier getPoint() {
            return this._point;
        }

        @Override
        public DataResourceIdentifier getTarget() {
            return this._target;
        }

        @Override
        public Edit.Where getWhere() {
            return this._where;
        }

        public <E$$ extends Augmentation<Edit>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._editId);
            result = 31 * result + Objects.hashCode((Object)this._operation);
            result = 31 * result + Objects.hashCode(this._point);
            result = 31 * result + Objects.hashCode(this._target);
            result = 31 * result + Objects.hashCode((Object)this._where);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Edit.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Edit other = (Edit)obj;
            if (!Objects.equals(this._editId, other.getEditId())) {
                return false;
            }
            if (!Objects.equals((Object)this._operation, (Object)other.getOperation())) {
                return false;
            }
            if (!Objects.equals(this._point, other.getPoint())) {
                return false;
            }
            if (!Objects.equals(this._target, other.getTarget())) {
                return false;
            }
            if (!Objects.equals((Object)this._where, (Object)other.getWhere())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                EditImpl otherImpl = (EditImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Edit>>, Augmentation<Edit>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Edit");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_editId", (Object)this._editId);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_operation", (Object)((Object)this._operation));
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_point", (Object)this._point);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_target", (Object)this._target);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_where", (Object)((Object)this._where));
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

