/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.schema.service.osgi;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.GuardedBy;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.dom.broker.schema.ScanningSchemaServiceProvider;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.model.api.SchemaContextListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OsgiBundleScanningSchemaService
extends ScanningSchemaServiceProvider
implements ServiceTrackerCustomizer<SchemaContextListener, SchemaContextListener> {
    private static final Logger LOG = LoggerFactory.getLogger(OsgiBundleScanningSchemaService.class);
    private static final AtomicReference<OsgiBundleScanningSchemaService> GLOBAL_INSTANCE = new AtomicReference();
    private static final long FRAMEWORK_BUNDLE_ID = 0L;
    private final BundleScanner scanner = new BundleScanner();
    private final BundleContext context;
    @GuardedBy(value="lock")
    private BundleTracker<Iterable<Registration>> bundleTracker;
    private final Object lock = new Object();
    private ServiceTracker<SchemaContextListener, SchemaContextListener> listenerTracker;
    private boolean starting = true;
    private volatile boolean stopping;

    private OsgiBundleScanningSchemaService(BundleContext context) {
        this.context = Objects.requireNonNull(context);
    }

    public static @NonNull OsgiBundleScanningSchemaService createInstance(BundleContext ctx) {
        OsgiBundleScanningSchemaService instance = new OsgiBundleScanningSchemaService(ctx);
        Preconditions.checkState((boolean)GLOBAL_INSTANCE.compareAndSet(null, instance));
        instance.start();
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start() {
        Preconditions.checkState((this.context != null ? 1 : 0) != 0);
        LOG.debug("start() starting");
        this.listenerTracker = new ServiceTracker(this.context, SchemaContextListener.class, (ServiceTrackerCustomizer)this);
        this.bundleTracker = new BundleTracker(this.context, 60, (BundleTrackerCustomizer)this.scanner);
        Object object = this.lock;
        synchronized (object) {
            this.bundleTracker.open();
            LOG.debug("BundleTracker.open() complete");
            if (!this.hasListeners()) {
                this.tryToUpdateSchemaContext();
            }
        }
        this.listenerTracker.open();
        this.starting = false;
        LOG.debug("start() complete");
    }

    public static OsgiBundleScanningSchemaService getInstance() {
        OsgiBundleScanningSchemaService instance = GLOBAL_INSTANCE.get();
        Preconditions.checkState((instance != null ? 1 : 0) != 0, (Object)"Global Instance was not instantiated");
        return instance;
    }

    @VisibleForTesting
    public static void destroyInstance() throws Exception {
        OsgiBundleScanningSchemaService instance = GLOBAL_INSTANCE.getAndSet(null);
        if (instance != null) {
            instance.closeInstance();
        }
    }

    private void closeInstance() {
        this.stopping = true;
        if (this.bundleTracker != null) {
            this.bundleTracker.close();
            this.bundleTracker = null;
        }
        if (this.listenerTracker != null) {
            this.listenerTracker.close();
            this.listenerTracker = null;
        }
        this.close();
    }

    public BundleContext getContext() {
        return this.context;
    }

    public SchemaContextListener addingService(ServiceReference<SchemaContextListener> reference) {
        SchemaContextListener listener = (SchemaContextListener)this.context.getService(reference);
        this.registerSchemaContextListener(listener);
        return listener;
    }

    public void modifiedService(ServiceReference<SchemaContextListener> reference, SchemaContextListener service) {
    }

    public void removedService(ServiceReference<SchemaContextListener> reference, SchemaContextListener service) {
        this.context.ungetService(reference);
        this.removeListener(service);
    }

    private class BundleScanner
    implements BundleTrackerCustomizer<Iterable<Registration>> {
        private BundleScanner() {
        }

        public Iterable<Registration> addingBundle(Bundle bundle, BundleEvent event) {
            if (bundle.getBundleId() == 0L) {
                return Collections.emptyList();
            }
            Enumeration enumeration = bundle.findEntries("META-INF/yang", "*.yang", false);
            if (enumeration == null) {
                return Collections.emptyList();
            }
            ArrayList<URL> urls = new ArrayList<URL>();
            while (enumeration.hasMoreElements()) {
                URL u = (URL)enumeration.nextElement();
                try {
                    urls.add(u);
                    LOG.debug("Registered {}", (Object)u);
                }
                catch (Exception e) {
                    LOG.warn("Failed to register {}, ignoring it", (Object)u, (Object)e);
                }
            }
            List registrations = OsgiBundleScanningSchemaService.this.registerAvailableYangs(urls);
            if (!registrations.isEmpty()) {
                LOG.debug("Loaded {} new URLs from bundle {}, attempting to rebuild schema context", (Object)registrations.size(), (Object)bundle.getSymbolicName());
                if (!OsgiBundleScanningSchemaService.this.starting && !OsgiBundleScanningSchemaService.this.stopping) {
                    OsgiBundleScanningSchemaService.this.tryToUpdateSchemaContext();
                }
            }
            return ImmutableList.copyOf((Collection)registrations);
        }

        public void modifiedBundle(Bundle bundle, BundleEvent event, Iterable<Registration> object) {
            if (bundle.getBundleId() == 0L) {
                LOG.debug("Framework bundle {} got event {}", (Object)bundle, (Object)event.getType());
                if ((event.getType() & 0x100) != 0) {
                    LOG.info("OSGi framework is being stopped, halting bundle scanning");
                    OsgiBundleScanningSchemaService.this.stopping = true;
                }
            }
        }

        public void removedBundle(Bundle bundle, BundleEvent event, Iterable<Registration> urls) {
            for (Registration url : urls) {
                try {
                    url.close();
                }
                catch (Exception e) {
                    LOG.warn("Failed do unregister URL {}, proceeding", (Object)url, (Object)e);
                }
            }
            int numUrls = Iterables.size(urls);
            if (numUrls > 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("removedBundle: {}, state: {}, # urls: {}", new Object[]{bundle.getSymbolicName(), bundle.getState(), numUrls});
                }
                if (!OsgiBundleScanningSchemaService.this.starting && !OsgiBundleScanningSchemaService.this.stopping) {
                    OsgiBundleScanningSchemaService.this.tryToUpdateSchemaContext();
                }
            }
        }
    }
}

