/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.connect.netconf;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.dom.DOMSource;
import org.opendaylight.mdsal.binding.generator.impl.ModuleInfoBackedContext;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.netconf.sal.connect.api.NetconfDeviceSchemas;
import org.opendaylight.netconf.sal.connect.netconf.sal.NetconfDeviceRpc;
import org.opendaylight.netconf.sal.connect.netconf.util.NetconfMessageTransformUtil;
import org.opendaylight.netconf.sal.connect.util.RemoteDeviceId;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160621.;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160621.ModulesState;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160621.module.list.Module;
import org.opendaylight.yangtools.util.xml.UntrustedXML;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.gson.JsonParserStream;
import org.opendaylight.yangtools.yang.data.codec.xml.XmlParserStream;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.NormalizedNodeResult;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.repo.api.RevisionSourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class LibraryModulesSchemas
implements NetconfDeviceSchemas {
    private static final Logger LOG = LoggerFactory.getLogger(LibraryModulesSchemas.class);
    private static final Pattern DATE_PATTERN = Pattern.compile("(\\d{4}-\\d{2}-\\d{2})");
    private static final SchemaContext LIBRARY_CONTEXT;
    private final Map<QName, URL> availableModels;
    private static final YangInstanceIdentifier MODULES_STATE_MODULE_LIST;
    private static final ContainerNode GET_MODULES_STATE_MODULE_LIST_RPC;

    private LibraryModulesSchemas(Map<QName, URL> availableModels) {
        this.availableModels = availableModels;
    }

    public Map<SourceIdentifier, URL> getAvailableModels() {
        HashMap<SourceIdentifier, URL> result = new HashMap<SourceIdentifier, URL>();
        for (Map.Entry<QName, URL> entry : this.availableModels.entrySet()) {
            RevisionSourceIdentifier sId = RevisionSourceIdentifier.create((String)entry.getKey().getLocalName(), (Optional)entry.getKey().getRevision());
            result.put((SourceIdentifier)sId, entry.getValue());
        }
        return result;
    }

    public static LibraryModulesSchemas create(String url, String username, String password) {
        Preconditions.checkNotNull((Object)url);
        try {
            URL urlConnection = new URL(url);
            URLConnection connection = urlConnection.openConnection();
            if (connection instanceof HttpURLConnection) {
                connection.setRequestProperty("Accept", "application/xml");
                String userpass = username + ":" + password;
                String basicAuth = "Basic " + DatatypeConverter.printBase64Binary((byte[])userpass.getBytes(StandardCharsets.UTF_8));
                connection.setRequestProperty("Authorization", basicAuth);
            }
            return LibraryModulesSchemas.createFromURLConnection(connection);
        }
        catch (IOException e) {
            LOG.warn("Unable to download yang library from {}", (Object)url, (Object)e);
            return new LibraryModulesSchemas(Collections.emptyMap());
        }
    }

    public static LibraryModulesSchemas create(NetconfDeviceRpc deviceRpc, RemoteDeviceId deviceId) {
        DOMRpcResult moduleListNodeResult;
        try {
            moduleListNodeResult = (DOMRpcResult)deviceRpc.invokeRpc(NetconfMessageTransformUtil.NETCONF_GET_PATH, (NormalizedNode<?, ?>)GET_MODULES_STATE_MODULE_LIST_RPC).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(deviceId + ": Interrupted while waiting for response to " + MODULES_STATE_MODULE_LIST, e);
        }
        catch (ExecutionException e) {
            LOG.warn("{}: Unable to detect available schemas, get to {} failed", new Object[]{deviceId, MODULES_STATE_MODULE_LIST, e});
            return new LibraryModulesSchemas(Collections.emptyMap());
        }
        if (!moduleListNodeResult.getErrors().isEmpty()) {
            LOG.warn("{}: Unable to detect available schemas, get to {} failed, {}", new Object[]{deviceId, MODULES_STATE_MODULE_LIST, moduleListNodeResult.getErrors()});
            return new LibraryModulesSchemas(Collections.emptyMap());
        }
        Optional<NormalizedNode<?, ?>> modulesStateNode = LibraryModulesSchemas.findModulesStateNode(moduleListNodeResult.getResult());
        if (modulesStateNode.isPresent()) {
            Preconditions.checkState((boolean)(modulesStateNode.get() instanceof ContainerNode), (String)"Expecting container containing schemas, but was %s", modulesStateNode.get());
            return LibraryModulesSchemas.create((ContainerNode)modulesStateNode.get());
        }
        LOG.warn("{}: Unable to detect available schemas, get to {} was empty", (Object)deviceId, (Object)NetconfMessageTransformUtil.toId(ModulesState.QNAME));
        return new LibraryModulesSchemas(Collections.emptyMap());
    }

    private static LibraryModulesSchemas create(ContainerNode modulesStateNode) {
        YangInstanceIdentifier.NodeIdentifier moduleListNodeId = new YangInstanceIdentifier.NodeIdentifier(Module.QNAME);
        Optional moduleListNode = modulesStateNode.getChild((YangInstanceIdentifier.PathArgument)moduleListNodeId);
        Preconditions.checkState((boolean)moduleListNode.isPresent(), (String)"Unable to find list: %s in %s", (Object)moduleListNodeId, (Object)modulesStateNode);
        Preconditions.checkState((boolean)(moduleListNode.get() instanceof MapNode), (String)"Unexpected structure for container: %s in : %s. Expecting a list", (Object)moduleListNodeId, (Object)modulesStateNode);
        ImmutableMap.Builder schemasMapping = new ImmutableMap.Builder();
        for (MapEntryNode moduleNode : ((MapNode)moduleListNode.get()).getValue()) {
            Optional<Map.Entry<QName, URL>> schemaMappingEntry = LibraryModulesSchemas.createFromEntry(moduleNode);
            if (!schemaMappingEntry.isPresent()) continue;
            schemasMapping.put(LibraryModulesSchemas.createFromEntry(moduleNode).get());
        }
        return new LibraryModulesSchemas((Map<QName, URL>)schemasMapping.build());
    }

    public static LibraryModulesSchemas create(String url) {
        Preconditions.checkNotNull((Object)url);
        try {
            URL urlConnection = new URL(url);
            URLConnection connection = urlConnection.openConnection();
            if (connection instanceof HttpURLConnection) {
                connection.setRequestProperty("Accept", "application/xml");
            }
            return LibraryModulesSchemas.createFromURLConnection(connection);
        }
        catch (IOException e) {
            LOG.warn("Unable to download yang library from {}", (Object)url, (Object)e);
            return new LibraryModulesSchemas(Collections.emptyMap());
        }
    }

    private static Optional<? extends NormalizedNode<?, ?>> findModulesStateNode(NormalizedNode<?, ?> result) {
        if (result == null) {
            return Optional.empty();
        }
        Optional dataNode = ((DataContainerNode)result).getChild((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.NETCONF_DATA_NODEID);
        if (!dataNode.isPresent()) {
            return Optional.empty();
        }
        return ((DataContainerNode)dataNode.get()).getChild((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.toId(ModulesState.QNAME));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static LibraryModulesSchemas createFromURLConnection(URLConnection connection) {
        String contentType = connection.getContentType();
        if (LibraryModulesSchemas.guessJsonFromFileName(connection.getURL().getFile())) {
            contentType = "application/json";
        }
        Preconditions.checkNotNull((Object)contentType, (Object)"Content type unknown");
        Preconditions.checkState((contentType.equals("application/json") || contentType.equals("application/xml") ? 1 : 0) != 0, (Object)"Only XML and JSON types are supported.");
        try (InputStream in = connection.getInputStream();){
            Optional<NormalizedNode<?, ?>> optionalModulesStateNode;
            Optional<NormalizedNode<?, ?>> optional = optionalModulesStateNode = contentType.equals("application/json") ? LibraryModulesSchemas.readJson(in) : LibraryModulesSchemas.readXml(in);
            if (!optionalModulesStateNode.isPresent()) {
                LibraryModulesSchemas libraryModulesSchemas2 = new LibraryModulesSchemas(Collections.emptyMap());
                return libraryModulesSchemas2;
            }
            NormalizedNode<?, ?> modulesStateNode = optionalModulesStateNode.get();
            Preconditions.checkState((boolean)modulesStateNode.getNodeType().equals((Object)ModulesState.QNAME), (String)"Wrong QName %s", (Object)modulesStateNode.getNodeType());
            Preconditions.checkState((boolean)(modulesStateNode instanceof ContainerNode), (String)"Expecting container containing module list, but was %s", modulesStateNode);
            YangInstanceIdentifier.NodeIdentifier moduleListNodeId = new YangInstanceIdentifier.NodeIdentifier(Module.QNAME);
            Optional moduleListNode = ((ContainerNode)modulesStateNode).getChild((YangInstanceIdentifier.PathArgument)moduleListNodeId);
            Preconditions.checkState((boolean)moduleListNode.isPresent(), (String)"Unable to find list: %s in %s", (Object)moduleListNodeId, modulesStateNode);
            Preconditions.checkState((boolean)(moduleListNode.get() instanceof MapNode), (String)"Unexpected structure for container: %s in : %s. Expecting a list", (Object)moduleListNodeId, modulesStateNode);
            ImmutableMap.Builder schemasMapping = new ImmutableMap.Builder();
            for (MapEntryNode moduleNode : ((MapNode)moduleListNode.get()).getValue()) {
                Optional<Map.Entry<QName, URL>> schemaMappingEntry = LibraryModulesSchemas.createFromEntry(moduleNode);
                if (!schemaMappingEntry.isPresent()) continue;
                schemasMapping.put(LibraryModulesSchemas.createFromEntry(moduleNode).get());
            }
            LibraryModulesSchemas libraryModulesSchemas = new LibraryModulesSchemas((Map<QName, URL>)schemasMapping.build());
            return libraryModulesSchemas;
        }
        catch (IOException e) {
            LOG.warn("Unable to download yang library from {}", (Object)connection.getURL(), (Object)e);
            return new LibraryModulesSchemas(Collections.emptyMap());
        }
    }

    private static boolean guessJsonFromFileName(String fileName) {
        String extension = "";
        int i = fileName.lastIndexOf(46);
        if (i != -1) {
            extension = fileName.substring(i).toLowerCase(Locale.ROOT);
        }
        return extension.equals(".json");
    }

    private static Optional<NormalizedNode<?, ?>> readJson(InputStream in) {
        NormalizedNodeResult resultHolder = new NormalizedNodeResult();
        NormalizedNodeStreamWriter writer = ImmutableNormalizedNodeStreamWriter.from((NormalizedNodeResult)resultHolder);
        JsonParserStream jsonParser = JsonParserStream.create((NormalizedNodeStreamWriter)writer, (SchemaContext)LIBRARY_CONTEXT);
        JsonReader reader = new JsonReader((Reader)new InputStreamReader(in, Charset.defaultCharset()));
        jsonParser.parse(reader);
        return resultHolder.isFinished() ? Optional.of(resultHolder.getResult()) : Optional.empty();
    }

    private static Optional<NormalizedNode<?, ?>> readXml(InputStream in) {
        try {
            DocumentBuilder docBuilder = UntrustedXML.newDocumentBuilder();
            Document read = docBuilder.parse(in);
            Document doc = docBuilder.newDocument();
            Element rootElement = doc.createElementNS("urn:ietf:params:xml:ns:yang:ietf-yang-library", "modules");
            doc.appendChild(rootElement);
            for (int i = 0; i < read.getElementsByTagName("revision").getLength(); ++i) {
                String revision = read.getElementsByTagName("revision").item(i).getTextContent();
                if (DATE_PATTERN.matcher(revision).find() || revision.isEmpty()) {
                    Node module = doc.importNode(read.getElementsByTagName("module").item(i), true);
                    rootElement.appendChild(module);
                    continue;
                }
                LOG.warn("Xml contains wrong revision - {} - on module {}", (Object)revision, (Object)read.getElementsByTagName("module").item(i).getTextContent());
            }
            NormalizedNodeResult resultHolder = new NormalizedNodeResult();
            NormalizedNodeStreamWriter writer = ImmutableNormalizedNodeStreamWriter.from((NormalizedNodeResult)resultHolder);
            XmlParserStream xmlParser = XmlParserStream.create((NormalizedNodeStreamWriter)writer, (SchemaContext)LIBRARY_CONTEXT, (SchemaNode)LIBRARY_CONTEXT.getDataChildByName(ModulesState.QNAME));
            xmlParser.traverse(new DOMSource(doc.getDocumentElement()));
            NormalizedNode parsed = resultHolder.getResult();
            return Optional.of(parsed);
        }
        catch (IOException | URISyntaxException | ParserConfigurationException | XMLStreamException | SAXException e) {
            LOG.warn("Unable to parse yang library xml content", (Throwable)e);
            return Optional.empty();
        }
    }

    private static Optional<Map.Entry<QName, URL>> createFromEntry(MapEntryNode moduleNode) {
        Preconditions.checkArgument((boolean)moduleNode.getNodeType().equals((Object)Module.QNAME), (String)"Wrong QName %s", (Object)moduleNode.getNodeType());
        YangInstanceIdentifier.NodeIdentifier childNodeId = new YangInstanceIdentifier.NodeIdentifier(QName.create((QName)Module.QNAME, (String)"name"));
        String moduleName = LibraryModulesSchemas.getSingleChildNodeValue(moduleNode, childNodeId).get();
        childNodeId = new YangInstanceIdentifier.NodeIdentifier(QName.create((QName)Module.QNAME, (String)"revision"));
        Optional<String> revision = LibraryModulesSchemas.getSingleChildNodeValue(moduleNode, childNodeId);
        if (revision.isPresent() && !Revision.STRING_FORMAT_PATTERN.matcher(revision.get()).matches()) {
            LOG.warn("Skipping library schema for {}. Revision {} is in wrong format.", (Object)moduleNode, (Object)revision.get());
            return Optional.empty();
        }
        childNodeId = new YangInstanceIdentifier.NodeIdentifier(QName.create((QName)Module.QNAME, (String)"schema"));
        Optional<String> schemaUriAsString = LibraryModulesSchemas.getSingleChildNodeValue(moduleNode, childNodeId);
        childNodeId = new YangInstanceIdentifier.NodeIdentifier(QName.create((QName)Module.QNAME, (String)"namespace"));
        String moduleNameSpace = LibraryModulesSchemas.getSingleChildNodeValue(moduleNode, childNodeId).get();
        QName moduleQName = revision.isPresent() ? QName.create((String)moduleNameSpace, (String)revision.get(), (String)moduleName) : QName.create((URI)URI.create(moduleNameSpace), (String)moduleName);
        try {
            return Optional.of(new AbstractMap.SimpleImmutableEntry<QName, URL>(moduleQName, new URL(schemaUriAsString.get())));
        }
        catch (MalformedURLException e) {
            LOG.warn("Skipping library schema for {}. URL {} representing yang schema resource is not valid", (Object)moduleNode, (Object)schemaUriAsString.get());
            return Optional.empty();
        }
    }

    private static Optional<String> getSingleChildNodeValue(DataContainerNode<?> schemaNode, YangInstanceIdentifier.NodeIdentifier childNodeId) {
        Optional node = schemaNode.getChild((YangInstanceIdentifier.PathArgument)childNodeId);
        Preconditions.checkArgument((boolean)node.isPresent(), (String)"Child node %s not present", (Object)childNodeId.getNodeType());
        return LibraryModulesSchemas.getValueOfSimpleNode((NormalizedNode)node.get());
    }

    private static Optional<String> getValueOfSimpleNode(NormalizedNode<? extends YangInstanceIdentifier.PathArgument, ?> node) {
        String valueStr = node.getValue().toString();
        return Strings.isNullOrEmpty((String)valueStr) ? Optional.empty() : Optional.of(valueStr.trim());
    }

    @Override
    public Set<QName> getAvailableYangSchemasQNames() {
        return null;
    }

    static {
        ModuleInfoBackedContext moduleInfoBackedContext = ModuleInfoBackedContext.create();
        moduleInfoBackedContext.registerModuleInfo(.YangModuleInfoImpl.getInstance());
        LIBRARY_CONTEXT = (SchemaContext)moduleInfoBackedContext.tryToCreateSchemaContext().get();
        MODULES_STATE_MODULE_LIST = YangInstanceIdentifier.builder().node(ModulesState.QNAME).node(Module.QNAME).build();
        GET_MODULES_STATE_MODULE_LIST_RPC = (ContainerNode)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.NETCONF_GET_NODEID).withChild(NetconfMessageTransformUtil.toFilterStructure(MODULES_STATE_MODULE_LIST, LIBRARY_CONTEXT)).build();
    }
}

