/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.connect.netconf;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import org.opendaylight.mdsal.dom.api.DOMNotification;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.netconf.api.NetconfMessage;
import org.opendaylight.netconf.sal.connect.api.DeviceActionFactory;
import org.opendaylight.netconf.sal.connect.api.MessageTransformer;
import org.opendaylight.netconf.sal.connect.api.NetconfDeviceSchemas;
import org.opendaylight.netconf.sal.connect.api.NetconfDeviceSchemasResolver;
import org.opendaylight.netconf.sal.connect.api.RemoteDevice;
import org.opendaylight.netconf.sal.connect.api.RemoteDeviceCommunicator;
import org.opendaylight.netconf.sal.connect.api.RemoteDeviceHandler;
import org.opendaylight.netconf.sal.connect.netconf.LibraryModulesSchemas;
import org.opendaylight.netconf.sal.connect.netconf.NotificationHandler;
import org.opendaylight.netconf.sal.connect.netconf.listener.NetconfDeviceCapabilities;
import org.opendaylight.netconf.sal.connect.netconf.listener.NetconfDeviceCommunicator;
import org.opendaylight.netconf.sal.connect.netconf.listener.NetconfSessionPreferences;
import org.opendaylight.netconf.sal.connect.netconf.sal.NetconfDeviceRpc;
import org.opendaylight.netconf.sal.connect.netconf.schema.NetconfRemoteSchemaYangSourceProvider;
import org.opendaylight.netconf.sal.connect.netconf.schema.YangLibrarySchemaYangSourceProvider;
import org.opendaylight.netconf.sal.connect.netconf.schema.mapping.BaseSchema;
import org.opendaylight.netconf.sal.connect.netconf.schema.mapping.NetconfMessageTransformer;
import org.opendaylight.netconf.sal.connect.netconf.util.NetconfMessageTransformUtil;
import org.opendaylight.netconf.sal.connect.util.RemoteDeviceId;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfCapabilityChange;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.connection.status.available.capabilities.AvailableCapabilityBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.connection.status.unavailable.capabilities.UnavailableCapability;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.repo.api.MissingSchemaSourceException;
import org.opendaylight.yangtools.yang.model.repo.api.RevisionSourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaContextFactory;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaRepository;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaResolutionException;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaSourceRepresentation;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.spi.PotentialSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceProvider;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceRegistration;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetconfDevice
implements RemoteDevice<NetconfSessionPreferences, NetconfMessage, NetconfDeviceCommunicator> {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfDevice.class);
    protected final RemoteDeviceId id;
    protected final SchemaContextFactory schemaContextFactory;
    protected final SchemaSourceRegistry schemaRegistry;
    protected final SchemaRepository schemaRepository;
    protected final List<SchemaSourceRegistration<? extends SchemaSourceRepresentation>> sourceRegistrations = new ArrayList<SchemaSourceRegistration<? extends SchemaSourceRepresentation>>();
    private final RemoteDeviceHandler<NetconfSessionPreferences> salFacade;
    private final ListeningExecutorService processingExecutor;
    private final DeviceActionFactory deviceActionFactory;
    private final NetconfDeviceSchemasResolver stateSchemasResolver;
    private final NotificationHandler notificationHandler;
    private final boolean reconnectOnSchemasChange;
    @GuardedBy(value="this")
    private boolean connected = false;
    private MessageTransformer<NetconfMessage> messageTransformer;

    static NetconfDeviceRpc getRpcForInitialization(NetconfDeviceCommunicator listener, boolean notificationSupport) {
        BaseSchema baseSchema = notificationSupport ? BaseSchema.BASE_NETCONF_CTX_WITH_NOTIFICATIONS : BaseSchema.BASE_NETCONF_CTX;
        return new NetconfDeviceRpc(baseSchema.getSchemaContext(), listener, new NetconfMessageTransformer(baseSchema.getSchemaContext(), false, baseSchema));
    }

    public NetconfDevice(SchemaResourcesDTO schemaResourcesDTO, RemoteDeviceId id, RemoteDeviceHandler<NetconfSessionPreferences> salFacade, ListeningExecutorService globalProcessingExecutor, boolean reconnectOnSchemasChange) {
        this(schemaResourcesDTO, id, salFacade, globalProcessingExecutor, reconnectOnSchemasChange, null);
    }

    public NetconfDevice(SchemaResourcesDTO schemaResourcesDTO, RemoteDeviceId id, RemoteDeviceHandler<NetconfSessionPreferences> salFacade, ListeningExecutorService globalProcessingExecutor, boolean reconnectOnSchemasChange, DeviceActionFactory deviceActionFactory) {
        this.id = id;
        this.reconnectOnSchemasChange = reconnectOnSchemasChange;
        this.deviceActionFactory = deviceActionFactory;
        this.schemaRegistry = schemaResourcesDTO.getSchemaRegistry();
        this.schemaRepository = schemaResourcesDTO.getSchemaRepository();
        this.schemaContextFactory = schemaResourcesDTO.getSchemaContextFactory();
        this.salFacade = salFacade;
        this.stateSchemasResolver = schemaResourcesDTO.getStateSchemasResolver();
        this.processingExecutor = Objects.requireNonNull(globalProcessingExecutor);
        this.notificationHandler = new NotificationHandler(salFacade, id);
    }

    @Override
    public void onRemoteSessionUp(final NetconfSessionPreferences remoteSessionCapabilities, final NetconfDeviceCommunicator listener) {
        this.setConnected(true);
        LOG.debug("{}: Session to remote device established with {}", (Object)this.id, (Object)remoteSessionCapabilities);
        NetconfDeviceRpc initRpc = NetconfDevice.getRpcForInitialization(listener, remoteSessionCapabilities.isNotificationsSupported());
        DeviceSourcesResolver task = new DeviceSourcesResolver(remoteSessionCapabilities, this.id, this.stateSchemasResolver, initRpc);
        ListenableFuture sourceResolverFuture = this.processingExecutor.submit((Callable)task);
        if (this.shouldListenOnSchemaChange(remoteSessionCapabilities)) {
            this.registerToBaseNetconfStream(initRpc, listener);
        }
        FutureCallback<DeviceSources> resolvedSourceCallback = new FutureCallback<DeviceSources>(){

            public void onSuccess(@Nonnull DeviceSources result) {
                NetconfDevice.this.addProvidedSourcesToSchemaRegistry(result);
                this.setUpSchema(result);
            }

            private void setUpSchema(DeviceSources result) {
                NetconfDevice.this.processingExecutor.submit((Runnable)new SchemaSetup(result, remoteSessionCapabilities, listener));
            }

            public void onFailure(Throwable throwable) {
                LOG.warn("{}: Unexpected error resolving device sources", (Object)NetconfDevice.this.id, (Object)throwable);
                NetconfDevice.this.handleSalInitializationFailure(throwable, listener);
            }
        };
        Futures.addCallback((ListenableFuture)sourceResolverFuture, (FutureCallback)resolvedSourceCallback, (Executor)MoreExecutors.directExecutor());
    }

    private void registerToBaseNetconfStream(NetconfDeviceRpc deviceRpc, final NetconfDeviceCommunicator listener) {
        FluentFuture<DOMRpcResult> rpcResultListenableFuture = deviceRpc.invokeRpc(NetconfMessageTransformUtil.toPath(NetconfMessageTransformUtil.CREATE_SUBSCRIPTION_RPC_QNAME), (NormalizedNode<?, ?>)NetconfMessageTransformUtil.CREATE_SUBSCRIPTION_RPC_CONTENT);
        final NotificationHandler.NotificationFilter filter = new NotificationHandler.NotificationFilter(){

            @Override
            public Optional<DOMNotification> filterNotification(DOMNotification notification) {
                if (this.isCapabilityChanged(notification)) {
                    LOG.info("{}: Schemas change detected, reconnecting", (Object)NetconfDevice.this.id);
                    listener.disconnect();
                    return Optional.empty();
                }
                return Optional.of(notification);
            }

            private boolean isCapabilityChanged(DOMNotification notification) {
                return notification.getBody().getNodeType().equals((Object)NetconfCapabilityChange.QNAME);
            }
        };
        Futures.addCallback(rpcResultListenableFuture, (FutureCallback)new FutureCallback<DOMRpcResult>(){

            public void onSuccess(DOMRpcResult domRpcResult) {
                NetconfDevice.this.notificationHandler.addNotificationFilter(filter);
            }

            public void onFailure(Throwable throwable) {
                LOG.warn("Unable to subscribe to base notification stream. Schemas will not be reloaded on the fly", throwable);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    private boolean shouldListenOnSchemaChange(NetconfSessionPreferences remoteSessionCapabilities) {
        return remoteSessionCapabilities.isNotificationsSupported() && this.reconnectOnSchemasChange;
    }

    private synchronized void handleSalInitializationSuccess(SchemaContext result, NetconfSessionPreferences remoteSessionCapabilities, DOMRpcService deviceRpc, RemoteDeviceCommunicator<NetconfMessage> listener) {
        if (this.connected) {
            BaseSchema baseSchema = remoteSessionCapabilities.isNotificationsSupported() ? BaseSchema.BASE_NETCONF_CTX_WITH_NOTIFICATIONS : BaseSchema.BASE_NETCONF_CTX;
            this.messageTransformer = new NetconfMessageTransformer(result, true, baseSchema);
            this.updateTransformer(this.messageTransformer);
            this.salFacade.onDeviceConnected(result, remoteSessionCapabilities, deviceRpc, this.deviceActionFactory == null ? null : this.deviceActionFactory.createDeviceAction(this.messageTransformer, listener, result));
            this.notificationHandler.onRemoteSchemaUp(this.messageTransformer);
            LOG.info("{}: Netconf connector initialized successfully", (Object)this.id);
        } else {
            LOG.warn("{}: Device communicator was closed before schema setup finished.", (Object)this.id);
        }
    }

    private void handleSalInitializationFailure(Throwable throwable, RemoteDeviceCommunicator<NetconfMessage> listener) {
        LOG.error("{}: Initialization in sal failed, disconnecting from device", (Object)this.id, (Object)throwable);
        listener.close();
        this.onRemoteSessionDown();
        this.resetMessageTransformer();
    }

    private void resetMessageTransformer() {
        this.updateTransformer(null);
    }

    private synchronized void updateTransformer(MessageTransformer<NetconfMessage> transformer) {
        this.messageTransformer = transformer;
    }

    private synchronized void setConnected(boolean connected) {
        this.connected = connected;
    }

    private void addProvidedSourcesToSchemaRegistry(DeviceSources deviceSources) {
        SchemaSourceProvider<YangTextSchemaSource> yangProvider = deviceSources.getSourceProvider();
        Collection<SourceIdentifier> providedSources = deviceSources.getProvidedSources();
        for (SourceIdentifier sourceId : providedSources) {
            PotentialSchemaSource pss = PotentialSchemaSource.create((SourceIdentifier)sourceId, YangTextSchemaSource.class, (int)PotentialSchemaSource.Costs.REMOTE_IO.getValue());
            SchemaSourceRegistration ssr = this.schemaRegistry.registerSchemaSource(yangProvider, pss);
            this.sourceRegistrations.add((SchemaSourceRegistration<? extends SchemaSourceRepresentation>)ssr);
        }
    }

    @Override
    public void onRemoteSessionDown() {
        try {
            this.setConnected(false);
            this.salFacade.onDeviceDisconnected();
        }
        catch (Exception e) {
            LOG.error(e.toString(), (Throwable)e);
        }
        finally {
            this.releaseResource();
        }
    }

    @Override
    public void onRemoteSessionFailed(Throwable throwable) {
        try {
            this.setConnected(false);
            this.salFacade.onDeviceFailed(throwable);
        }
        catch (Exception e) {
            LOG.error(e.toString(), (Throwable)e);
        }
        finally {
            this.releaseResource();
        }
    }

    private void releaseResource() {
        try {
            this.notificationHandler.onRemoteSchemaDown();
            this.resetMessageTransformer();
        }
        catch (Exception e) {
            LOG.error(e.toString(), (Throwable)e);
        }
        finally {
            for (SchemaSourceRegistration<? extends SchemaSourceRepresentation> sourceRegistration : this.sourceRegistrations) {
                sourceRegistration.close();
            }
            this.sourceRegistrations.clear();
        }
    }

    @Override
    public void onNotification(NetconfMessage notification) {
        this.notificationHandler.handleNotification(notification);
    }

    private final class SchemaSetup
    implements Runnable {
        private final DeviceSources deviceSources;
        private final NetconfSessionPreferences remoteSessionCapabilities;
        private final RemoteDeviceCommunicator<NetconfMessage> listener;
        private final NetconfDeviceCapabilities capabilities;

        SchemaSetup(DeviceSources deviceSources, NetconfSessionPreferences remoteSessionCapabilities, RemoteDeviceCommunicator<NetconfMessage> listener) {
            this.deviceSources = deviceSources;
            this.remoteSessionCapabilities = remoteSessionCapabilities;
            this.listener = listener;
            this.capabilities = remoteSessionCapabilities.getNetconfDeviceCapabilities();
        }

        @Override
        public void run() {
            Collection<SourceIdentifier> requiredSources = this.deviceSources.getRequiredSources();
            Collection<SourceIdentifier> missingSources = this.filterMissingSources(requiredSources);
            this.capabilities.addUnresolvedCapabilities(this.getQNameFromSourceIdentifiers(missingSources), UnavailableCapability.FailureReason.MissingSource);
            requiredSources.removeAll(missingSources);
            this.setUpSchema(requiredSources);
        }

        private Collection<SourceIdentifier> filterMissingSources(Collection<SourceIdentifier> requiredSources) {
            return requiredSources.parallelStream().filter(sourceIdentifier -> {
                try {
                    NetconfDevice.this.schemaRepository.getSchemaSource(sourceIdentifier, YangTextSchemaSource.class).get();
                    return false;
                }
                catch (InterruptedException | ExecutionException e) {
                    return true;
                }
            }).collect(Collectors.toList());
        }

        private void setUpSchema(Collection<SourceIdentifier> requiredSources) {
            while (!requiredSources.isEmpty()) {
                LOG.trace("{}: Trying to build schema context from {}", (Object)NetconfDevice.this.id, requiredSources);
                try {
                    ListenableFuture schemaBuilderFuture = NetconfDevice.this.schemaContextFactory.createSchemaContext(requiredSources);
                    SchemaContext result = (SchemaContext)schemaBuilderFuture.get();
                    LOG.debug("{}: Schema context built successfully from {}", (Object)NetconfDevice.this.id, requiredSources);
                    Sets.SetView filteredQNames = Sets.difference(this.deviceSources.getRequiredSourcesQName(), this.capabilities.getUnresolvedCapabilites().keySet());
                    this.capabilities.addCapabilities(filteredQNames.stream().map(entry -> new AvailableCapabilityBuilder().setCapability(entry.toString()).setCapabilityOrigin(this.remoteSessionCapabilities.getModuleBasedCapsOrigin().get(entry)).build()).collect(Collectors.toList()));
                    this.capabilities.addNonModuleBasedCapabilities(this.remoteSessionCapabilities.getNonModuleCaps().stream().map(entry -> new AvailableCapabilityBuilder().setCapability((String)entry).setCapabilityOrigin(this.remoteSessionCapabilities.getNonModuleBasedCapsOrigin().get(entry)).build()).collect(Collectors.toList()));
                    NetconfDevice.this.handleSalInitializationSuccess(result, this.remoteSessionCapabilities, this.getDeviceSpecificRpc(this.remoteSessionCapabilities.isNotificationsSupported(), result), this.listener);
                    return;
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof MissingSchemaSourceException) {
                        requiredSources = this.handleMissingSchemaSourceException(requiredSources, (MissingSchemaSourceException)cause);
                        continue;
                    }
                    if (cause instanceof SchemaResolutionException) {
                        requiredSources = this.handleSchemaResolutionException(requiredSources, (SchemaResolutionException)cause);
                        continue;
                    }
                    NetconfDevice.this.handleSalInitializationFailure(e, this.listener);
                    return;
                }
                catch (Exception e) {
                    NetconfDevice.this.handleSalInitializationFailure(e, this.listener);
                    return;
                }
            }
            IllegalStateException cause = new IllegalStateException(NetconfDevice.this.id + ": No more sources for schema context");
            NetconfDevice.this.handleSalInitializationFailure(cause, this.listener);
            NetconfDevice.this.salFacade.onDeviceFailed(cause);
        }

        private Collection<SourceIdentifier> handleMissingSchemaSourceException(Collection<SourceIdentifier> requiredSources, MissingSchemaSourceException exception) {
            SourceIdentifier missingSource = exception.getSourceId();
            LOG.warn("{}: Unable to build schema context, missing source {}, will reattempt without it", (Object)NetconfDevice.this.id, (Object)missingSource);
            LOG.debug("{}: Unable to build schema context, missing source {}, will reattempt without it", new Object[]{NetconfDevice.this.id, missingSource, exception});
            Collection<QName> qNameOfMissingSource = this.getQNameFromSourceIdentifiers(Sets.newHashSet((Object[])new SourceIdentifier[]{missingSource}));
            if (!qNameOfMissingSource.isEmpty()) {
                this.capabilities.addUnresolvedCapabilities(qNameOfMissingSource, UnavailableCapability.FailureReason.MissingSource);
            }
            return this.stripUnavailableSource(requiredSources, missingSource);
        }

        private Collection<SourceIdentifier> handleSchemaResolutionException(Collection<SourceIdentifier> requiredSources, SchemaResolutionException resolutionException) {
            if (resolutionException.getFailedSource() != null) {
                SourceIdentifier failedSourceId = resolutionException.getFailedSource();
                LOG.warn("{}: Unable to build schema context, failed to resolve source {}, will reattempt without it", (Object)NetconfDevice.this.id, (Object)failedSourceId);
                LOG.warn("{}: Unable to build schema context, failed to resolve source {}, will reattempt without it", new Object[]{NetconfDevice.this.id, failedSourceId, resolutionException});
                this.capabilities.addUnresolvedCapabilities(this.getQNameFromSourceIdentifiers(Collections.singleton(failedSourceId)), UnavailableCapability.FailureReason.UnableToResolve);
                return this.stripUnavailableSource(requiredSources, resolutionException.getFailedSource());
            }
            Set unresolvedSources = resolutionException.getUnsatisfiedImports().keySet();
            this.capabilities.addUnresolvedCapabilities(this.getQNameFromSourceIdentifiers(unresolvedSources), UnavailableCapability.FailureReason.UnableToResolve);
            LOG.warn("{}: Unable to build schema context, unsatisfied imports {}, will reattempt with resolved only", (Object)NetconfDevice.this.id, (Object)resolutionException.getUnsatisfiedImports());
            LOG.debug("{}: Unable to build schema context, unsatisfied imports {}, will reattempt with resolved only", new Object[]{NetconfDevice.this.id, resolutionException.getUnsatisfiedImports(), resolutionException});
            return resolutionException.getResolvedSources();
        }

        protected NetconfDeviceRpc getDeviceSpecificRpc(boolean isNoteSupported, SchemaContext result) {
            NetconfMessageTransformer transformer = isNoteSupported ? new NetconfMessageTransformer(result, true, BaseSchema.BASE_NETCONF_CTX_WITH_NOTIFICATIONS) : new NetconfMessageTransformer(result, true);
            return new NetconfDeviceRpc(result, this.listener, transformer);
        }

        private Collection<SourceIdentifier> stripUnavailableSource(Collection<SourceIdentifier> requiredSources, SourceIdentifier sourceIdToRemove) {
            LinkedList sourceIdentifiers = Lists.newLinkedList(requiredSources);
            boolean removed = sourceIdentifiers.remove(sourceIdToRemove);
            Preconditions.checkState((boolean)removed, (String)"{}: Trying to remove {} from {} failed", (Object)NetconfDevice.this.id, (Object)sourceIdToRemove, requiredSources);
            return sourceIdentifiers;
        }

        private Collection<QName> getQNameFromSourceIdentifiers(Collection<SourceIdentifier> identifiers) {
            Collection qNames = Collections2.transform(identifiers, this::getQNameFromSourceIdentifier);
            if (qNames.isEmpty()) {
                LOG.debug("{}: Unable to map any source identifiers to a capability reported by device : {}", (Object)NetconfDevice.this.id, identifiers);
            }
            return Collections2.filter((Collection)qNames, (Predicate)Predicates.notNull());
        }

        private QName getQNameFromSourceIdentifier(SourceIdentifier identifier) {
            for (QName qname : this.deviceSources.getRequiredSourcesQName()) {
                if (!qname.getLocalName().equals(identifier.getName()) || !identifier.getRevision().equals(qname.getRevision())) continue;
                return qname;
            }
            LOG.warn("Unable to map identifier to a devices reported capability: {} Available: {}", (Object)identifier, this.deviceSources.getRequiredSourcesQName());
            return null;
        }
    }

    private static final class DeviceSources {
        private final Set<QName> requiredSources;
        private final Set<QName> providedSources;
        private final SchemaSourceProvider<YangTextSchemaSource> sourceProvider;

        DeviceSources(Set<QName> requiredSources, Set<QName> providedSources, SchemaSourceProvider<YangTextSchemaSource> sourceProvider) {
            this.requiredSources = requiredSources;
            this.providedSources = providedSources;
            this.sourceProvider = sourceProvider;
        }

        public Set<QName> getRequiredSourcesQName() {
            return this.requiredSources;
        }

        public Set<QName> getProvidedSourcesQName() {
            return this.providedSources;
        }

        public Collection<SourceIdentifier> getRequiredSources() {
            return Collections2.transform(this.requiredSources, DeviceSources::toSourceId);
        }

        public Collection<SourceIdentifier> getProvidedSources() {
            return Collections2.transform(this.providedSources, DeviceSources::toSourceId);
        }

        public SchemaSourceProvider<YangTextSchemaSource> getSourceProvider() {
            return this.sourceProvider;
        }

        private static SourceIdentifier toSourceId(QName input) {
            return RevisionSourceIdentifier.create((String)input.getLocalName(), (Optional)input.getRevision());
        }
    }

    private static class DeviceSourcesResolver
    implements Callable<DeviceSources> {
        private final NetconfDeviceRpc deviceRpc;
        private final NetconfSessionPreferences remoteSessionCapabilities;
        private final RemoteDeviceId id;
        private final NetconfDeviceSchemasResolver stateSchemasResolver;

        DeviceSourcesResolver(NetconfDeviceRpc deviceRpc, NetconfSessionPreferences remoteSessionCapabilities, RemoteDeviceId id, NetconfDeviceSchemasResolver stateSchemasResolver) {
            this.deviceRpc = deviceRpc;
            this.remoteSessionCapabilities = remoteSessionCapabilities;
            this.id = id;
            this.stateSchemasResolver = stateSchemasResolver;
        }

        DeviceSourcesResolver(NetconfSessionPreferences remoteSessionCapabilities, RemoteDeviceId id, NetconfDeviceSchemasResolver stateSchemasResolver, NetconfDeviceRpc rpcForMonitoring) {
            this(rpcForMonitoring, remoteSessionCapabilities, id, stateSchemasResolver);
        }

        @Override
        public DeviceSources call() {
            Sets.SetView providedSourcesNotRequired;
            NetconfDeviceSchemas availableSchemas = this.stateSchemasResolver.resolve(this.deviceRpc, this.remoteSessionCapabilities, this.id);
            LOG.debug("{}: Schemas exposed by ietf-netconf-monitoring: {}", (Object)this.id, availableSchemas.getAvailableYangSchemasQNames());
            HashSet requiredSources = Sets.newHashSet(this.remoteSessionCapabilities.getModuleBasedCaps());
            Set<QName> providedSources = availableSchemas.getAvailableYangSchemasQNames();
            Sets.SetView requiredSourcesNotProvided = Sets.difference((Set)requiredSources, providedSources);
            if (!requiredSourcesNotProvided.isEmpty()) {
                LOG.warn("{}: Netconf device does not provide all yang models reported in hello message capabilities, required but not provided: {}", (Object)this.id, (Object)requiredSourcesNotProvided);
                LOG.warn("{}: Attempting to build schema context from required sources", (Object)this.id);
            }
            if (!(providedSourcesNotRequired = Sets.difference(providedSources, (Set)requiredSources)).isEmpty()) {
                LOG.warn("{}: Netconf device provides additional yang models not reported in hello message capabilities: {}", (Object)this.id, (Object)providedSourcesNotRequired);
                LOG.warn("{}: Adding provided but not required sources as required to prevent failures", (Object)this.id);
                LOG.debug("{}: Netconf device reported in hello: {}", (Object)this.id, (Object)requiredSources);
                requiredSources.addAll(providedSourcesNotRequired);
            }
            Object sourceProvider = availableSchemas instanceof LibraryModulesSchemas ? new YangLibrarySchemaYangSourceProvider(this.id, ((LibraryModulesSchemas)availableSchemas).getAvailableModels()) : new NetconfRemoteSchemaYangSourceProvider(this.id, this.deviceRpc);
            return new DeviceSources(requiredSources, providedSources, (SchemaSourceProvider<YangTextSchemaSource>)sourceProvider);
        }
    }

    public static class SchemaResourcesDTO {
        private final SchemaSourceRegistry schemaRegistry;
        private final SchemaRepository schemaRepository;
        private final SchemaContextFactory schemaContextFactory;
        private final NetconfDeviceSchemasResolver stateSchemasResolver;

        public SchemaResourcesDTO(SchemaSourceRegistry schemaRegistry, SchemaRepository schemaRepository, SchemaContextFactory schemaContextFactory, NetconfDeviceSchemasResolver deviceSchemasResolver) {
            this.schemaRegistry = (SchemaSourceRegistry)Preconditions.checkNotNull((Object)schemaRegistry);
            this.schemaRepository = (SchemaRepository)Preconditions.checkNotNull((Object)schemaRepository);
            this.schemaContextFactory = (SchemaContextFactory)Preconditions.checkNotNull((Object)schemaContextFactory);
            this.stateSchemasResolver = (NetconfDeviceSchemasResolver)Preconditions.checkNotNull((Object)deviceSchemasResolver);
        }

        public SchemaSourceRegistry getSchemaRegistry() {
            return this.schemaRegistry;
        }

        public SchemaRepository getSchemaRepository() {
            return this.schemaRepository;
        }

        public SchemaContextFactory getSchemaContextFactory() {
            return this.schemaContextFactory;
        }

        public NetconfDeviceSchemasResolver getStateSchemasResolver() {
            return this.stateSchemasResolver;
        }
    }
}

