/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.connect.netconf;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.netconf.sal.connect.api.NetconfDeviceSchemas;
import org.opendaylight.netconf.sal.connect.netconf.listener.NetconfSessionPreferences;
import org.opendaylight.netconf.sal.connect.netconf.schema.mapping.BaseSchema;
import org.opendaylight.netconf.sal.connect.netconf.util.NetconfMessageTransformUtil;
import org.opendaylight.netconf.sal.connect.util.RemoteDeviceId;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.NetconfState;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.Yang;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.Schemas;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.schemas.Schema;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetconfStateSchemas
implements NetconfDeviceSchemas {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfStateSchemas.class);
    public static final NetconfStateSchemas EMPTY = new NetconfStateSchemas((Set<RemoteYangSchema>)ImmutableSet.of());
    private static final YangInstanceIdentifier STATE_SCHEMAS_IDENTIFIER = YangInstanceIdentifier.builder().node(NetconfState.QNAME).node(Schemas.QNAME).build();
    private static final ContainerNode GET_SCHEMAS_RPC;
    private static final int DEFAULT_REQUEST_TIMEOUT = 30;
    private final Set<RemoteYangSchema> availableYangSchemas;

    public NetconfStateSchemas(Set<RemoteYangSchema> availableYangSchemas) {
        this.availableYangSchemas = availableYangSchemas;
    }

    public Set<RemoteYangSchema> getAvailableYangSchemas() {
        return this.availableYangSchemas;
    }

    @Override
    public Set<QName> getAvailableYangSchemasQNames() {
        return (Set)this.getAvailableYangSchemas().stream().map(RemoteYangSchema::getQName).collect(ImmutableSet.toImmutableSet());
    }

    static NetconfStateSchemas create(DOMRpcService deviceRpc, NetconfSessionPreferences remoteSessionCapabilities, RemoteDeviceId id) {
        DOMRpcResult schemasNodeResult;
        if (!remoteSessionCapabilities.isMonitoringSupported()) {
            LOG.warn("{}: Netconf monitoring not supported on device, cannot detect provided schemas", (Object)id);
            return EMPTY;
        }
        try {
            schemasNodeResult = (DOMRpcResult)deviceRpc.invokeRpc(NetconfMessageTransformUtil.NETCONF_GET_PATH, (NormalizedNode)GET_SCHEMAS_RPC).get(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | TimeoutException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(id + ": Interrupted while waiting for response to " + STATE_SCHEMAS_IDENTIFIER, e);
        }
        catch (ExecutionException e) {
            LOG.warn("{}: Unable to detect available schemas, get to {} failed", new Object[]{id, STATE_SCHEMAS_IDENTIFIER, e});
            return EMPTY;
        }
        if (!schemasNodeResult.getErrors().isEmpty()) {
            LOG.warn("{}: Unable to detect available schemas, get to {} failed, {}", new Object[]{id, STATE_SCHEMAS_IDENTIFIER, schemasNodeResult.getErrors()});
            return EMPTY;
        }
        Optional<NormalizedNode<?, ?>> optSchemasNode = NetconfStateSchemas.findSchemasNode(schemasNodeResult.getResult());
        if (!optSchemasNode.isPresent()) {
            LOG.warn("{}: Unable to detect available schemas, get to {} was empty", (Object)id, (Object)STATE_SCHEMAS_IDENTIFIER);
            return EMPTY;
        }
        NormalizedNode<?, ?> schemasNode = optSchemasNode.get();
        Preconditions.checkState((boolean)(schemasNode instanceof ContainerNode), (String)"Expecting container containing schemas, but was %s", schemasNode);
        return NetconfStateSchemas.create(id, (ContainerNode)schemasNode);
    }

    @VisibleForTesting
    protected static NetconfStateSchemas create(RemoteDeviceId id, ContainerNode schemasNode) {
        HashSet<RemoteYangSchema> availableYangSchemas = new HashSet<RemoteYangSchema>();
        Optional child = schemasNode.getChild((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.toId(Schema.QNAME));
        Preconditions.checkState((boolean)child.isPresent(), (String)"Unable to find list: %s in response: %s", (Object)Schema.QNAME.withoutRevision(), (Object)schemasNode);
        Preconditions.checkState((boolean)(child.get() instanceof MapNode), (String)"Unexpected structure for container: %s in response: %s. Expecting a list", (Object)Schema.QNAME.withoutRevision(), (Object)schemasNode);
        for (MapEntryNode schemaNode : ((MapNode)child.get()).getValue()) {
            Optional<RemoteYangSchema> fromCompositeNode = RemoteYangSchema.createFromNormalizedNode(id, schemaNode);
            if (!fromCompositeNode.isPresent()) continue;
            availableYangSchemas.add(fromCompositeNode.get());
        }
        return new NetconfStateSchemas(availableYangSchemas);
    }

    private static Optional<? extends NormalizedNode<?, ?>> findSchemasNode(NormalizedNode<?, ?> result) {
        if (result == null) {
            return Optional.empty();
        }
        Optional dataNode = ((DataContainerNode)result).getChild((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.NETCONF_DATA_NODEID);
        if (!dataNode.isPresent()) {
            return Optional.empty();
        }
        Optional nStateNode = ((DataContainerNode)dataNode.get()).getChild((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.toId(NetconfState.QNAME));
        if (!nStateNode.isPresent()) {
            return Optional.empty();
        }
        return ((DataContainerNode)nStateNode.get()).getChild((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.toId(Schemas.QNAME));
    }

    static {
        DataContainerChild<?, ?> filter = NetconfMessageTransformUtil.toFilterStructure(STATE_SCHEMAS_IDENTIFIER, BaseSchema.BASE_NETCONF_CTX_WITH_NOTIFICATIONS.getSchemaContext());
        GET_SCHEMAS_RPC = (ContainerNode)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.NETCONF_GET_NODEID).withChild(filter).build();
    }

    public static final class RemoteYangSchema {
        private final QName qname;

        RemoteYangSchema(QName qname) {
            this.qname = qname;
        }

        public QName getQName() {
            return this.qname;
        }

        static Optional<RemoteYangSchema> createFromNormalizedNode(RemoteDeviceId id, MapEntryNode schemaNode) {
            Preconditions.checkArgument((boolean)schemaNode.getNodeType().equals((Object)Schema.QNAME), (String)"Wrong QName %s", (Object)schemaNode.getNodeType());
            QName childNode = NetconfMessageTransformUtil.IETF_NETCONF_MONITORING_SCHEMA_FORMAT;
            String formatAsString = RemoteYangSchema.getSingleChildNodeValue(schemaNode, childNode).get();
            if (!formatAsString.equals(Yang.QNAME.toString())) {
                LOG.debug("{}: Ignoring schema due to unsupported format: {}", (Object)id, (Object)formatAsString);
                return Optional.empty();
            }
            childNode = NetconfMessageTransformUtil.IETF_NETCONF_MONITORING_SCHEMA_LOCATION;
            Set<String> locationsAsString = RemoteYangSchema.getAllChildNodeValues(schemaNode, childNode);
            if (!locationsAsString.contains(Schema.Location.Enumeration.NETCONF.toString())) {
                LOG.debug("{}: Ignoring schema due to unsupported location: {}", (Object)id, locationsAsString);
                return Optional.empty();
            }
            childNode = NetconfMessageTransformUtil.IETF_NETCONF_MONITORING_SCHEMA_NAMESPACE;
            Optional<String> namespaceValue = RemoteYangSchema.getSingleChildNodeValue(schemaNode, childNode);
            if (!namespaceValue.isPresent()) {
                LOG.warn("{}: Ignoring schema due to missing namespace", (Object)id);
                return Optional.empty();
            }
            String namespaceAsString = namespaceValue.get();
            childNode = NetconfMessageTransformUtil.IETF_NETCONF_MONITORING_SCHEMA_VERSION;
            Optional<String> revisionAsString = RemoteYangSchema.getSingleChildNodeValue(schemaNode, childNode);
            childNode = NetconfMessageTransformUtil.IETF_NETCONF_MONITORING_SCHEMA_IDENTIFIER;
            String moduleNameAsString = RemoteYangSchema.getSingleChildNodeValue(schemaNode, childNode).get();
            QName moduleQName = revisionAsString.isPresent() ? QName.create((String)namespaceAsString, (String)revisionAsString.get(), (String)moduleNameAsString) : QName.create((URI)URI.create(namespaceAsString), (String)moduleNameAsString);
            return Optional.of(new RemoteYangSchema(moduleQName));
        }

        private static Set<String> getAllChildNodeValues(DataContainerNode<?> schemaNode, QName childNodeQName) {
            HashSet<String> extractedValues = new HashSet<String>();
            Optional child = schemaNode.getChild((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.toId(childNodeQName));
            Preconditions.checkArgument((boolean)child.isPresent(), (String)"Child nodes %s not present", (Object)childNodeQName);
            Preconditions.checkArgument((boolean)(child.get() instanceof LeafSetNode), (String)"Child nodes %s not present", (Object)childNodeQName);
            for (LeafSetEntryNode childNode : ((LeafSetNode)child.get()).getValue()) {
                extractedValues.add(RemoteYangSchema.getValueOfSimpleNode(childNode).get());
            }
            return extractedValues;
        }

        private static Optional<String> getSingleChildNodeValue(DataContainerNode<?> schemaNode, QName childNode) {
            Optional node = schemaNode.getChild((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.toId(childNode));
            if (node.isPresent()) {
                return RemoteYangSchema.getValueOfSimpleNode((NormalizedNode)node.get());
            }
            LOG.debug("Child node {} not present", (Object)childNode);
            return Optional.empty();
        }

        private static Optional<String> getValueOfSimpleNode(NormalizedNode<? extends YangInstanceIdentifier.PathArgument, ?> node) {
            String valueStr = node.getValue().toString();
            return Strings.isNullOrEmpty((String)valueStr) ? Optional.empty() : Optional.of(valueStr.trim());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            RemoteYangSchema that = (RemoteYangSchema)obj;
            return this.qname.equals((Object)that.qname);
        }

        public int hashCode() {
            return this.qname.hashCode();
        }
    }
}

