/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.connect.netconf;

import com.google.common.annotations.VisibleForTesting;
import org.opendaylight.netconf.api.NetconfMessage;
import org.opendaylight.netconf.sal.connect.api.RemoteDevice;
import org.opendaylight.netconf.sal.connect.api.RemoteDeviceHandler;
import org.opendaylight.netconf.sal.connect.netconf.listener.NetconfDeviceCommunicator;
import org.opendaylight.netconf.sal.connect.netconf.listener.NetconfSessionPreferences;
import org.opendaylight.netconf.sal.connect.netconf.sal.SchemalessNetconfDeviceRpc;
import org.opendaylight.netconf.sal.connect.netconf.schema.mapping.BaseRpcSchemalessTransformer;
import org.opendaylight.netconf.sal.connect.netconf.schema.mapping.BaseSchema;
import org.opendaylight.netconf.sal.connect.netconf.schema.mapping.SchemalessMessageTransformer;
import org.opendaylight.netconf.sal.connect.util.MessageCounter;
import org.opendaylight.netconf.sal.connect.util.RemoteDeviceId;

public class SchemalessNetconfDevice
implements RemoteDevice<NetconfSessionPreferences, NetconfMessage, NetconfDeviceCommunicator> {
    private RemoteDeviceId id;
    private RemoteDeviceHandler<NetconfSessionPreferences> salFacade;
    private final SchemalessMessageTransformer messageTransformer;
    private final BaseRpcSchemalessTransformer rpcTransformer;

    public SchemalessNetconfDevice(RemoteDeviceId id, RemoteDeviceHandler<NetconfSessionPreferences> salFacade) {
        this.id = id;
        this.salFacade = salFacade;
        MessageCounter counter = new MessageCounter();
        this.rpcTransformer = new BaseRpcSchemalessTransformer(counter);
        this.messageTransformer = new SchemalessMessageTransformer(counter);
    }

    @VisibleForTesting
    SchemalessNetconfDevice(RemoteDeviceId id, RemoteDeviceHandler<NetconfSessionPreferences> salFacade, SchemalessMessageTransformer messageTransformer) {
        this.id = id;
        this.salFacade = salFacade;
        MessageCounter counter = new MessageCounter();
        this.rpcTransformer = new BaseRpcSchemalessTransformer(counter);
        this.messageTransformer = messageTransformer;
    }

    @Override
    public void onRemoteSessionUp(NetconfSessionPreferences remoteSessionCapabilities, NetconfDeviceCommunicator netconfDeviceCommunicator) {
        SchemalessNetconfDeviceRpc schemalessNetconfDeviceRpc = new SchemalessNetconfDeviceRpc(this.id, netconfDeviceCommunicator, this.rpcTransformer, this.messageTransformer);
        this.salFacade.onDeviceConnected(BaseSchema.BASE_NETCONF_CTX.getSchemaContext(), remoteSessionCapabilities, schemalessNetconfDeviceRpc);
    }

    @Override
    public void onRemoteSessionDown() {
        this.salFacade.onDeviceDisconnected();
    }

    @Override
    public void onRemoteSessionFailed(Throwable throwable) {
        this.salFacade.onDeviceFailed(throwable);
    }

    @Override
    public void onNotification(NetconfMessage notification) {
        this.salFacade.onNotification(this.messageTransformer.toNotification(notification));
    }
}

