/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.connect.netconf.auth;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.StringReader;
import java.security.KeyPair;
import java.util.Optional;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.client.session.ClientSession;
import org.opendaylight.aaa.encrypt.AAAEncryptionService;
import org.opendaylight.aaa.encrypt.PKIUtil;
import org.opendaylight.netconf.nettyutil.handler.ssh.authentication.AuthenticationHandler;
import org.opendaylight.netconf.sal.connect.netconf.sal.NetconfKeystoreAdapter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017.keystore.entry.KeyCredential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatastoreBackedPublicKeyAuth
extends AuthenticationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DatastoreBackedPublicKeyAuth.class);
    private final String username;
    private final String pairId;
    private final NetconfKeystoreAdapter keystoreAdapter;
    private final AAAEncryptionService encryptionService;
    private Optional<KeyPair> keyPair = Optional.empty();

    public DatastoreBackedPublicKeyAuth(String username, String pairId, NetconfKeystoreAdapter keystoreAdapter, AAAEncryptionService encryptionService) {
        this.username = username;
        this.pairId = pairId;
        this.keystoreAdapter = keystoreAdapter;
        this.encryptionService = encryptionService;
        this.tryToSetKeyPair();
    }

    public String getUsername() {
        return this.username;
    }

    public AuthFuture authenticate(ClientSession session) throws IOException {
        if (this.keyPair.isPresent() || this.tryToSetKeyPair()) {
            session.addPublicKeyIdentity(this.keyPair.get());
        }
        return session.auth();
    }

    private boolean tryToSetKeyPair() {
        LOG.debug("Trying to retrieve keypair for: {}", (Object)this.pairId);
        Optional<KeyCredential> keypairOptional = this.keystoreAdapter.getKeypairFromId(this.pairId);
        if (keypairOptional.isPresent()) {
            KeyCredential dsKeypair = keypairOptional.get();
            String passPhrase = Strings.isNullOrEmpty((String)dsKeypair.getPassphrase()) ? "" : dsKeypair.getPassphrase();
            try {
                this.keyPair = Optional.of(new PKIUtil().decodePrivateKey(new StringReader(this.encryptionService.decrypt(dsKeypair.getPrivateKey()).replaceAll("\\\\n", "\n")), this.encryptionService.decrypt(passPhrase)));
            }
            catch (IOException exception) {
                LOG.warn("Unable to decode private key, id={}", (Object)this.pairId, (Object)exception);
                return false;
            }
            return true;
        }
        LOG.debug("Unable to retrieve keypair for: {}", (Object)this.pairId);
        return false;
    }
}

