/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.connect.netconf.listener;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.opendaylight.netconf.client.NetconfClientSession;
import org.opendaylight.netconf.sal.connect.netconf.listener.NetconfDeviceCapabilities;
import org.opendaylight.netconf.sal.connect.netconf.util.NetconfMessageTransformUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.connection.status.available.capabilities.AvailableCapability;
import org.opendaylight.yangtools.yang.common.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetconfSessionPreferences {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfSessionPreferences.class);
    private static final ParameterMatcher MODULE_PARAM = new ParameterMatcher("module=");
    private static final ParameterMatcher REVISION_PARAM = new ParameterMatcher("revision=");
    private static final ParameterMatcher BROKEN_REVISON_PARAM = new ParameterMatcher("amp;revision=");
    private static final Splitter AMP_SPLITTER = Splitter.on((char)'&');
    private static final Predicate<String> CONTAINS_REVISION = input -> input.contains("revision=");
    private final Map<QName, AvailableCapability.CapabilityOrigin> moduleBasedCaps;
    private final Map<String, AvailableCapability.CapabilityOrigin> nonModuleCaps;
    private final NetconfDeviceCapabilities capabilities = new NetconfDeviceCapabilities();

    NetconfSessionPreferences(Map<String, AvailableCapability.CapabilityOrigin> nonModuleCaps, Map<QName, AvailableCapability.CapabilityOrigin> moduleBasedCaps) {
        this.nonModuleCaps = (Map)Preconditions.checkNotNull(nonModuleCaps);
        this.moduleBasedCaps = (Map)Preconditions.checkNotNull(moduleBasedCaps);
    }

    public Set<QName> getModuleBasedCaps() {
        return this.moduleBasedCaps.keySet();
    }

    public Map<QName, AvailableCapability.CapabilityOrigin> getModuleBasedCapsOrigin() {
        return this.moduleBasedCaps;
    }

    public Set<String> getNonModuleCaps() {
        return this.nonModuleCaps.keySet();
    }

    public Map<String, AvailableCapability.CapabilityOrigin> getNonModuleBasedCapsOrigin() {
        return this.nonModuleCaps;
    }

    public boolean containsPartialNonModuleCapability(String capability) {
        for (String nonModuleCap : this.getNonModuleCaps()) {
            if (!nonModuleCap.startsWith(capability)) continue;
            LOG.trace("capability {} partially matches {}", (Object)capability, this.nonModuleCaps);
            return true;
        }
        return false;
    }

    public boolean containsNonModuleCapability(String capability) {
        return this.nonModuleCaps.containsKey(capability);
    }

    public boolean containsModuleCapability(QName capability) {
        return this.moduleBasedCaps.containsKey(capability);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("capabilities", this.nonModuleCaps).add("moduleBasedCapabilities", this.moduleBasedCaps).add("rollback", this.isRollbackSupported()).add("monitoring", this.isMonitoringSupported()).add("candidate", this.isCandidateSupported()).add("writableRunning", this.isRunningWritable()).toString();
    }

    public boolean isRollbackSupported() {
        return this.containsNonModuleCapability(NetconfMessageTransformUtil.NETCONF_ROLLBACK_ON_ERROR_URI.toString());
    }

    public boolean isCandidateSupported() {
        return this.containsNonModuleCapability(NetconfMessageTransformUtil.NETCONF_CANDIDATE_URI.toString());
    }

    public boolean isRunningWritable() {
        return this.containsNonModuleCapability(NetconfMessageTransformUtil.NETCONF_RUNNING_WRITABLE_URI.toString());
    }

    public boolean isNotificationsSupported() {
        return this.containsPartialNonModuleCapability(NetconfMessageTransformUtil.NETCONF_NOTIFICATONS_URI.toString()) || this.containsModuleCapability(NetconfMessageTransformUtil.IETF_NETCONF_NOTIFICATIONS);
    }

    public boolean isMonitoringSupported() {
        return this.containsModuleCapability(NetconfMessageTransformUtil.IETF_NETCONF_MONITORING) || this.containsPartialNonModuleCapability(NetconfMessageTransformUtil.IETF_NETCONF_MONITORING.getNamespace().toString());
    }

    public NetconfSessionPreferences addModuleCaps(NetconfSessionPreferences netconfSessionModuleCapabilities) {
        HashMap mergedCaps = Maps.newHashMapWithExpectedSize((int)(this.moduleBasedCaps.size() + netconfSessionModuleCapabilities.getModuleBasedCaps().size()));
        mergedCaps.putAll(this.moduleBasedCaps);
        mergedCaps.putAll(netconfSessionModuleCapabilities.getModuleBasedCapsOrigin());
        return new NetconfSessionPreferences(this.getNonModuleBasedCapsOrigin(), mergedCaps);
    }

    public NetconfSessionPreferences replaceModuleCaps(NetconfSessionPreferences netconfSessionPreferences) {
        return new NetconfSessionPreferences(this.getNonModuleBasedCapsOrigin(), netconfSessionPreferences.getModuleBasedCapsOrigin());
    }

    public NetconfSessionPreferences replaceModuleCaps(Map<QName, AvailableCapability.CapabilityOrigin> newModuleBasedCaps) {
        return new NetconfSessionPreferences(this.getNonModuleBasedCapsOrigin(), newModuleBasedCaps);
    }

    public NetconfSessionPreferences addNonModuleCaps(NetconfSessionPreferences netconfSessionNonModuleCapabilities) {
        HashMap mergedCaps = Maps.newHashMapWithExpectedSize((int)(this.nonModuleCaps.size() + netconfSessionNonModuleCapabilities.getNonModuleCaps().size()));
        mergedCaps.putAll(this.getNonModuleBasedCapsOrigin());
        mergedCaps.putAll(netconfSessionNonModuleCapabilities.getNonModuleBasedCapsOrigin());
        return new NetconfSessionPreferences(mergedCaps, this.getModuleBasedCapsOrigin());
    }

    public NetconfSessionPreferences replaceNonModuleCaps(NetconfSessionPreferences netconfSessionPreferences) {
        return new NetconfSessionPreferences(netconfSessionPreferences.getNonModuleBasedCapsOrigin(), this.getModuleBasedCapsOrigin());
    }

    public static NetconfSessionPreferences fromNetconfSession(NetconfClientSession session) {
        return NetconfSessionPreferences.fromStrings(session.getServerCapabilities());
    }

    private static QName cachedQName(String namespace, String revision, String moduleName) {
        return QName.create((String)namespace, (String)revision, (String)moduleName).intern();
    }

    private static QName cachedQName(String namespace, String moduleName) {
        return QName.create((URI)URI.create(namespace), (String)moduleName).withoutRevision().intern();
    }

    public static NetconfSessionPreferences fromStrings(Collection<String> capabilities) {
        return NetconfSessionPreferences.fromStrings(capabilities, AvailableCapability.CapabilityOrigin.DeviceAdvertised);
    }

    public static NetconfSessionPreferences fromStrings(Collection<String> capabilities, AvailableCapability.CapabilityOrigin capabilityOrigin) {
        HashMap<QName, AvailableCapability.CapabilityOrigin> moduleBasedCaps = new HashMap<QName, AvailableCapability.CapabilityOrigin>();
        HashMap<String, AvailableCapability.CapabilityOrigin> nonModuleCaps = new HashMap<String, AvailableCapability.CapabilityOrigin>();
        for (String capability : capabilities) {
            nonModuleCaps.put(capability, capabilityOrigin);
            int qmark = capability.indexOf(63);
            if (qmark == -1) continue;
            String namespace = capability.substring(0, qmark);
            Iterable queryParams = AMP_SPLITTER.split((CharSequence)capability.substring(qmark + 1));
            String moduleName = NetconfSessionPreferences.MODULE_PARAM.from(queryParams);
            if (Strings.isNullOrEmpty((String)moduleName)) continue;
            String revision = NetconfSessionPreferences.REVISION_PARAM.from(queryParams);
            if (!Strings.isNullOrEmpty((String)revision)) {
                NetconfSessionPreferences.addModuleQName(moduleBasedCaps, nonModuleCaps, capability, NetconfSessionPreferences.cachedQName(namespace, revision, moduleName), capabilityOrigin);
                continue;
            }
            if (Iterables.any((Iterable)queryParams, CONTAINS_REVISION)) {
                LOG.debug("Netconf device was not reporting revision correctly, trying to get amp;revision=");
                revision = NetconfSessionPreferences.BROKEN_REVISON_PARAM.from(queryParams);
                if (Strings.isNullOrEmpty((String)revision)) {
                    LOG.warn("Netconf device returned revision incorrectly escaped for {}, ignoring it", (Object)capability);
                    NetconfSessionPreferences.addModuleQName(moduleBasedCaps, nonModuleCaps, capability, NetconfSessionPreferences.cachedQName(namespace, moduleName), capabilityOrigin);
                    continue;
                }
                NetconfSessionPreferences.addModuleQName(moduleBasedCaps, nonModuleCaps, capability, NetconfSessionPreferences.cachedQName(namespace, revision, moduleName), capabilityOrigin);
                continue;
            }
            NetconfSessionPreferences.addModuleQName(moduleBasedCaps, nonModuleCaps, capability, NetconfSessionPreferences.cachedQName(namespace, moduleName), capabilityOrigin);
        }
        return new NetconfSessionPreferences((Map<String, AvailableCapability.CapabilityOrigin>)ImmutableMap.copyOf(nonModuleCaps), (Map<QName, AvailableCapability.CapabilityOrigin>)ImmutableMap.copyOf(moduleBasedCaps));
    }

    private static void addModuleQName(Map<QName, AvailableCapability.CapabilityOrigin> moduleBasedCaps, Map<String, AvailableCapability.CapabilityOrigin> nonModuleCaps, String capability, QName qualifiedName, AvailableCapability.CapabilityOrigin capabilityOrigin) {
        moduleBasedCaps.put(qualifiedName, capabilityOrigin);
        nonModuleCaps.remove(capability);
    }

    public NetconfDeviceCapabilities getNetconfDeviceCapabilities() {
        return this.capabilities;
    }

    private static final class ParameterMatcher {
        private final Predicate<String> predicate = input -> input.startsWith(name);
        private final int skipLength;

        ParameterMatcher(String name) {
            this.skipLength = name.length();
        }

        private String from(Iterable<String> params) {
            Optional o = Iterables.tryFind(params, this.predicate);
            if (!o.isPresent()) {
                return null;
            }
            return ((String)o.get()).substring(this.skipLength);
        }
    }
}

