/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.connect.netconf.sal;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.dom.api.DOMActionService;
import org.opendaylight.mdsal.dom.api.DOMNotification;
import org.opendaylight.mdsal.dom.api.DOMRpcAvailabilityListener;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.netconf.sal.connect.api.RemoteDeviceHandler;
import org.opendaylight.netconf.sal.connect.netconf.listener.NetconfDeviceCommunicator;
import org.opendaylight.netconf.sal.connect.netconf.listener.NetconfSessionPreferences;
import org.opendaylight.netconf.sal.connect.netconf.util.NetconfBaseOps;
import org.opendaylight.netconf.sal.connect.netconf.util.NetconfMessageTransformUtil;
import org.opendaylight.netconf.sal.connect.util.RemoteDeviceId;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KeepaliveSalFacade
implements RemoteDeviceHandler<NetconfSessionPreferences> {
    private static final Logger LOG = LoggerFactory.getLogger(KeepaliveSalFacade.class);
    private static final long DEFAULT_DELAY = TimeUnit.MINUTES.toSeconds(9L);
    private static final long DEFAULT_TRANSACTION_TIMEOUT_MILLI = TimeUnit.MILLISECONDS.toMillis(600000L);
    private final RemoteDeviceId id;
    private final RemoteDeviceHandler<NetconfSessionPreferences> salFacade;
    private final ScheduledExecutorService executor;
    private final long keepaliveDelaySeconds;
    private final ResetKeepalive resetKeepaliveTask;
    private final long defaultRequestTimeoutMillis;
    private volatile NetconfDeviceCommunicator listener;
    private volatile ScheduledFuture<?> currentKeepalive;
    private volatile DOMRpcService currentDeviceRpc;
    private final AtomicBoolean lastKeepAliveSucceeded = new AtomicBoolean(false);
    private static final ContainerNode KEEPALIVE_PAYLOAD = NetconfMessageTransformUtil.wrap(NetconfMessageTransformUtil.NETCONF_GET_CONFIG_NODEID, NetconfBaseOps.getSourceNode(NetconfMessageTransformUtil.NETCONF_RUNNING_QNAME), NetconfMessageTransformUtil.EMPTY_FILTER);

    public KeepaliveSalFacade(RemoteDeviceId id, RemoteDeviceHandler<NetconfSessionPreferences> salFacade, ScheduledExecutorService executor, long keepaliveDelaySeconds, long defaultRequestTimeoutMillis) {
        this.id = id;
        this.salFacade = salFacade;
        this.executor = executor;
        this.keepaliveDelaySeconds = keepaliveDelaySeconds;
        this.defaultRequestTimeoutMillis = defaultRequestTimeoutMillis;
        this.resetKeepaliveTask = new ResetKeepalive();
    }

    public KeepaliveSalFacade(RemoteDeviceId id, RemoteDeviceHandler<NetconfSessionPreferences> salFacade, ScheduledExecutorService executor) {
        this(id, salFacade, executor, DEFAULT_DELAY, DEFAULT_TRANSACTION_TIMEOUT_MILLI);
    }

    public void setListener(NetconfDeviceCommunicator listener) {
        this.listener = listener;
    }

    void resetKeepalive() {
        LOG.trace("{}: Resetting netconf keepalive timer", (Object)this.id);
        if (this.currentKeepalive != null) {
            this.currentKeepalive.cancel(false);
        }
        this.scheduleKeepalives();
    }

    private void stopKeepalives() {
        if (this.currentKeepalive != null) {
            this.currentKeepalive.cancel(false);
        }
        this.currentDeviceRpc = null;
    }

    void reconnect() {
        Preconditions.checkState((this.listener != null ? 1 : 0) != 0, (String)"%s: Unable to reconnect, session listener is missing", (Object)this.id);
        this.stopKeepalives();
        LOG.info("{}: Reconnecting inactive netconf session", (Object)this.id);
        this.listener.disconnect();
    }

    @Override
    public void onDeviceConnected(SchemaContext remoteSchemaContext, NetconfSessionPreferences netconfSessionPreferences, DOMRpcService deviceRpc) {
        this.onDeviceConnected(remoteSchemaContext, netconfSessionPreferences, deviceRpc, (DOMActionService)null);
    }

    @Override
    public void onDeviceConnected(SchemaContext remoteSchemaContext, NetconfSessionPreferences netconfSessionPreferences, DOMRpcService deviceRpc, DOMActionService deviceAction) {
        this.currentDeviceRpc = deviceRpc;
        KeepaliveDOMRpcService deviceRpc1 = new KeepaliveDOMRpcService(deviceRpc, this.resetKeepaliveTask, this.defaultRequestTimeoutMillis, this.executor);
        this.salFacade.onDeviceConnected(remoteSchemaContext, netconfSessionPreferences, deviceRpc1, deviceAction);
        LOG.debug("{}: Netconf session initiated, starting keepalives", (Object)this.id);
        this.scheduleKeepalives();
    }

    private void scheduleKeepalives() {
        this.lastKeepAliveSucceeded.set(true);
        Preconditions.checkState((this.currentDeviceRpc != null ? 1 : 0) != 0);
        LOG.trace("{}: Scheduling keepalives every  {} {}", new Object[]{this.id, this.keepaliveDelaySeconds, TimeUnit.SECONDS});
        this.currentKeepalive = this.executor.scheduleWithFixedDelay(new Keepalive(), this.keepaliveDelaySeconds, this.keepaliveDelaySeconds, TimeUnit.SECONDS);
    }

    @Override
    public void onDeviceDisconnected() {
        this.stopKeepalives();
        this.salFacade.onDeviceDisconnected();
    }

    @Override
    public void onDeviceFailed(Throwable throwable) {
        this.stopKeepalives();
        this.salFacade.onDeviceFailed(throwable);
    }

    @Override
    public void onNotification(DOMNotification domNotification) {
        this.resetKeepalive();
        this.salFacade.onNotification(domNotification);
    }

    @Override
    public void close() {
        this.stopKeepalives();
        this.salFacade.close();
    }

    public static final class KeepaliveDOMRpcService
    implements DOMRpcService {
        private final DOMRpcService deviceRpc;
        private final ResetKeepalive resetKeepaliveTask;
        private final long defaultRequestTimeoutMillis;
        private final ScheduledExecutorService executor;

        KeepaliveDOMRpcService(DOMRpcService deviceRpc, ResetKeepalive resetKeepaliveTask, long defaultRequestTimeoutMillis, ScheduledExecutorService executor) {
            this.deviceRpc = deviceRpc;
            this.resetKeepaliveTask = resetKeepaliveTask;
            this.defaultRequestTimeoutMillis = defaultRequestTimeoutMillis;
            this.executor = executor;
        }

        public DOMRpcService getDeviceRpc() {
            return this.deviceRpc;
        }

        @Nonnull
        public @NonNull FluentFuture<DOMRpcResult> invokeRpc(@Nonnull SchemaPath type, NormalizedNode<?, ?> input) {
            FluentFuture rpcResultFuture = this.deviceRpc.invokeRpc(type, input);
            Futures.addCallback((ListenableFuture)rpcResultFuture, (FutureCallback)this.resetKeepaliveTask, (Executor)MoreExecutors.directExecutor());
            RequestTimeoutTask timeoutTask = new RequestTimeoutTask((FluentFuture<DOMRpcResult>)rpcResultFuture);
            this.executor.schedule(timeoutTask, this.defaultRequestTimeoutMillis, TimeUnit.MILLISECONDS);
            return rpcResultFuture;
        }

        public <T extends DOMRpcAvailabilityListener> ListenerRegistration<T> registerRpcListener(@Nonnull T listener) {
            return this.deviceRpc.registerRpcListener(listener);
        }
    }

    private static final class RequestTimeoutTask
    implements Runnable {
        private final FluentFuture<DOMRpcResult> rpcResultFuture;

        RequestTimeoutTask(FluentFuture<DOMRpcResult> rpcResultFuture) {
            this.rpcResultFuture = rpcResultFuture;
        }

        @Override
        public void run() {
            if (!this.rpcResultFuture.isDone()) {
                this.rpcResultFuture.cancel(true);
            }
        }
    }

    private class ResetKeepalive
    implements FutureCallback<DOMRpcResult> {
        private ResetKeepalive() {
        }

        public void onSuccess(@Nullable DOMRpcResult result) {
            KeepaliveSalFacade.this.resetKeepalive();
        }

        public void onFailure(@Nonnull Throwable throwable) {
            LOG.warn("{}: Rpc failure detected. Reconnecting netconf session", (Object)KeepaliveSalFacade.this.id, (Object)throwable);
            KeepaliveSalFacade.this.reconnect();
        }
    }

    private class Keepalive
    implements Runnable,
    FutureCallback<DOMRpcResult> {
        private Keepalive() {
        }

        @Override
        public void run() {
            LOG.trace("{}: Invoking keepalive RPC", (Object)KeepaliveSalFacade.this.id);
            try {
                boolean lastJobSucceeded = KeepaliveSalFacade.this.lastKeepAliveSucceeded.getAndSet(false);
                if (!lastJobSucceeded) {
                    this.onFailure(new IllegalStateException("Previous keepalive timed out"));
                } else {
                    Futures.addCallback((ListenableFuture)KeepaliveSalFacade.this.currentDeviceRpc.invokeRpc(NetconfMessageTransformUtil.NETCONF_GET_CONFIG_PATH, (NormalizedNode)KEEPALIVE_PAYLOAD), (FutureCallback)this, (Executor)MoreExecutors.directExecutor());
                }
            }
            catch (NullPointerException e) {
                LOG.debug("{}: Skipping keepalive while reconnecting", (Object)KeepaliveSalFacade.this.id);
            }
        }

        @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="Unrecognised NullableDecl")
        public void onSuccess(DOMRpcResult result) {
            if (result != null && result.getResult() != null) {
                KeepaliveSalFacade.this.lastKeepAliveSucceeded.set(true);
            } else if (result != null && result.getErrors() != null) {
                LOG.warn("{}: Keepalive RPC failed with error: {}", (Object)KeepaliveSalFacade.this.id, (Object)result.getErrors());
                KeepaliveSalFacade.this.lastKeepAliveSucceeded.set(true);
            } else {
                LOG.warn("{} Keepalive RPC returned null with response.", (Object)KeepaliveSalFacade.this.id);
                KeepaliveSalFacade.this.lastKeepAliveSucceeded.set(true);
            }
        }

        public void onFailure(@Nonnull Throwable throwable) {
            LOG.warn("{}: Keepalive RPC failed. Reconnecting netconf session.", (Object)KeepaliveSalFacade.this.id, (Object)throwable);
            KeepaliveSalFacade.this.reconnect();
        }
    }
}

