/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.connect.netconf.sal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableClassToInstanceMap;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMDataBrokerExtension;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.mdsal.dom.api.DOMTransactionChain;
import org.opendaylight.mdsal.dom.api.DOMTransactionChainListener;
import org.opendaylight.netconf.sal.connect.netconf.listener.NetconfSessionPreferences;
import org.opendaylight.netconf.sal.connect.netconf.sal.tx.ReadOnlyTx;
import org.opendaylight.netconf.sal.connect.netconf.sal.tx.ReadWriteTx;
import org.opendaylight.netconf.sal.connect.netconf.sal.tx.TxChain;
import org.opendaylight.netconf.sal.connect.netconf.sal.tx.WriteCandidateRunningTx;
import org.opendaylight.netconf.sal.connect.netconf.sal.tx.WriteCandidateTx;
import org.opendaylight.netconf.sal.connect.netconf.sal.tx.WriteRunningTx;
import org.opendaylight.netconf.sal.connect.netconf.util.NetconfBaseOps;
import org.opendaylight.netconf.sal.connect.util.RemoteDeviceId;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

public final class NetconfDeviceDataBroker
implements DOMDataBroker {
    private final RemoteDeviceId id;
    private final NetconfBaseOps netconfOps;
    private final boolean rollbackSupport;
    private final boolean candidateSupported;
    private final boolean runningWritable;

    public NetconfDeviceDataBroker(RemoteDeviceId id, SchemaContext schemaContext, DOMRpcService rpc, NetconfSessionPreferences netconfSessionPreferences) {
        this.id = id;
        this.netconfOps = new NetconfBaseOps(rpc, schemaContext);
        this.candidateSupported = netconfSessionPreferences.isCandidateSupported();
        this.runningWritable = netconfSessionPreferences.isRunningWritable();
        this.rollbackSupport = netconfSessionPreferences.isRollbackSupported();
        Preconditions.checkArgument((this.candidateSupported || this.runningWritable ? 1 : 0) != 0, (String)"Device %s has advertised neither :writable-running nor :candidate capability.At least one of these should be advertised. Failed to establish a session.", (Object)id.getName());
    }

    public DOMDataTreeReadTransaction newReadOnlyTransaction() {
        return new ReadOnlyTx(this.netconfOps, this.id);
    }

    public DOMDataTreeReadWriteTransaction newReadWriteTransaction() {
        return new ReadWriteTx(this.newReadOnlyTransaction(), this.newWriteOnlyTransaction());
    }

    public DOMDataTreeWriteTransaction newWriteOnlyTransaction() {
        if (this.candidateSupported) {
            if (this.runningWritable) {
                return new WriteCandidateRunningTx(this.id, this.netconfOps, this.rollbackSupport);
            }
            return new WriteCandidateTx(this.id, this.netconfOps, this.rollbackSupport);
        }
        return new WriteRunningTx(this.id, this.netconfOps, this.rollbackSupport);
    }

    public DOMTransactionChain createTransactionChain(DOMTransactionChainListener listener) {
        return new TxChain(this, listener);
    }

    public ClassToInstanceMap<DOMDataBrokerExtension> getExtensions() {
        return ImmutableClassToInstanceMap.of();
    }
}

