/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.connect.netconf.sal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.opendaylight.mdsal.binding.api.ClusteredDataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.DataObjectModification;
import org.opendaylight.mdsal.binding.api.DataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.api.DataTreeModification;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017.Keystore;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017.keystore.entry.KeyCredential;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017.trusted.certificates.TrustedCertificate;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetconfKeystoreAdapter
implements ClusteredDataTreeChangeListener<Keystore> {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfKeystoreAdapter.class);
    private final InstanceIdentifier<Keystore> keystoreIid = InstanceIdentifier.create(Keystore.class);
    private final DataBroker dataBroker;
    private final Map<String, KeyCredential> pairs = Collections.synchronizedMap(new HashMap());
    private final Map<String, org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017._private.keys.PrivateKey> privateKeys = Collections.synchronizedMap(new HashMap());
    private final Map<String, TrustedCertificate> trustedCertificates = Collections.synchronizedMap(new HashMap());

    public NetconfKeystoreAdapter(DataBroker dataBroker) {
        this.dataBroker = dataBroker;
        dataBroker.registerDataTreeChangeListener(DataTreeIdentifier.create((LogicalDatastoreType)LogicalDatastoreType.CONFIGURATION, this.keystoreIid), (DataTreeChangeListener)this);
    }

    public Optional<KeyCredential> getKeypairFromId(String keyId) {
        KeyCredential keypair = this.pairs.get(keyId);
        return Optional.ofNullable(keypair);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyStore getJavaKeyStore() throws GeneralSecurityException, IOException {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null, null);
        Map<String, Object> map = this.privateKeys;
        synchronized (map) {
            if (this.privateKeys.isEmpty()) {
                throw new KeyStoreException("No keystore private key found");
            }
            for (Map.Entry<String, org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017._private.keys.PrivateKey> entry : this.privateKeys.entrySet()) {
                PrivateKey key = NetconfKeystoreAdapter.getJavaPrivateKey(entry.getValue().getData());
                List<X509Certificate> certificateChain = NetconfKeystoreAdapter.getCertificateChain(entry.getValue().getCertificateChain().toArray(new String[0]));
                if (certificateChain.isEmpty()) {
                    throw new CertificateException("No certificate chain associated with private key found");
                }
                keyStore.setKeyEntry(entry.getKey(), key, "".toCharArray(), (Certificate[])certificateChain.stream().toArray(Certificate[]::new));
            }
        }
        map = this.trustedCertificates;
        synchronized (map) {
            for (Map.Entry<String, Object> entry : this.trustedCertificates.entrySet()) {
                List<X509Certificate> x509Certificates = NetconfKeystoreAdapter.getCertificateChain(new String[]{((TrustedCertificate)entry.getValue()).getCertificate()});
                keyStore.setCertificateEntry(entry.getKey(), x509Certificates.get(0));
            }
        }
        return keyStore;
    }

    private static PrivateKey getJavaPrivateKey(String base64PrivateKey) throws GeneralSecurityException {
        PrivateKey key;
        byte[] encodedKey = NetconfKeystoreAdapter.base64Decode(base64PrivateKey);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encodedKey);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            key = keyFactory.generatePrivate(keySpec);
        }
        catch (InvalidKeySpecException ignore) {
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            key = keyFactory.generatePrivate(keySpec);
        }
        return key;
    }

    private static List<X509Certificate> getCertificateChain(String[] base64Certificates) throws GeneralSecurityException {
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        for (String cert : base64Certificates) {
            byte[] buffer = NetconfKeystoreAdapter.base64Decode(cert);
            certificates.add((X509Certificate)factory.generateCertificate(new ByteArrayInputStream(buffer)));
        }
        return certificates;
    }

    private static byte[] base64Decode(String base64) {
        return Base64.getMimeDecoder().decode(base64.getBytes(StandardCharsets.US_ASCII));
    }

    public void onDataTreeChanged(@Nonnull Collection<DataTreeModification<Keystore>> changes) {
        LOG.debug("Keystore updated: {}", changes);
        for (DataTreeModification<Keystore> change : changes) {
            DataObjectModification rootNode = change.getRootNode();
            for (DataObjectModification changedChild : rootNode.getModifiedChildren()) {
                if (changedChild.getDataType().equals(KeyCredential.class)) {
                    Keystore dataAfter = (Keystore)rootNode.getDataAfter();
                    this.pairs.clear();
                    if (dataAfter == null) continue;
                    dataAfter.getKeyCredential().forEach(pair -> this.pairs.put(pair.key().getKeyId(), (KeyCredential)pair));
                    continue;
                }
                if (changedChild.getDataType().equals(org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017._private.keys.PrivateKey.class)) {
                    this.onPrivateKeyChanged((DataObjectModification<org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017._private.keys.PrivateKey>)changedChild);
                    continue;
                }
                if (!changedChild.getDataType().equals(TrustedCertificate.class)) continue;
                this.onTrustedCertificateChanged((DataObjectModification<TrustedCertificate>)changedChild);
            }
        }
    }

    private void onPrivateKeyChanged(DataObjectModification<org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017._private.keys.PrivateKey> objectModification) {
        switch (objectModification.getModificationType()) {
            case SUBTREE_MODIFIED: 
            case WRITE: {
                org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017._private.keys.PrivateKey privateKey = (org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017._private.keys.PrivateKey)objectModification.getDataAfter();
                this.privateKeys.put(privateKey.getName(), privateKey);
                break;
            }
            case DELETE: {
                this.privateKeys.remove(((org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017._private.keys.PrivateKey)objectModification.getDataBefore()).getName());
                break;
            }
        }
    }

    private void onTrustedCertificateChanged(DataObjectModification<TrustedCertificate> objectModification) {
        switch (objectModification.getModificationType()) {
            case SUBTREE_MODIFIED: 
            case WRITE: {
                TrustedCertificate trustedCertificate = (TrustedCertificate)objectModification.getDataAfter();
                this.trustedCertificates.put(trustedCertificate.getName(), trustedCertificate);
                break;
            }
            case DELETE: {
                this.trustedCertificates.remove(((TrustedCertificate)objectModification.getDataBefore()).getName());
                break;
            }
        }
    }
}

