/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.connect.netconf.sal;

import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opendaylight.mdsal.dom.api.DOMRpcAvailabilityListener;
import org.opendaylight.mdsal.dom.api.DOMRpcImplementationNotAvailableException;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.mdsal.dom.spi.DefaultDOMRpcResult;
import org.opendaylight.netconf.api.NetconfMessage;
import org.opendaylight.netconf.sal.connect.api.MessageTransformer;
import org.opendaylight.netconf.sal.connect.api.RemoteDeviceCommunicator;
import org.opendaylight.netconf.sal.connect.netconf.schema.mapping.BaseRpcSchemalessTransformer;
import org.opendaylight.netconf.sal.connect.netconf.schema.mapping.SchemalessMessageTransformer;
import org.opendaylight.netconf.sal.connect.netconf.util.NetconfMessageTransformUtil;
import org.opendaylight.netconf.sal.connect.util.RemoteDeviceId;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.util.concurrent.FluentFutures;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.data.api.schema.AnyXmlNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

public final class SchemalessNetconfDeviceRpc
implements DOMRpcService {
    private final RemoteDeviceCommunicator<NetconfMessage> listener;
    private final BaseRpcSchemalessTransformer baseRpcTransformer;
    private final SchemalessMessageTransformer schemalessTransformer;
    private final RemoteDeviceId deviceId;

    public SchemalessNetconfDeviceRpc(RemoteDeviceId deviceId, RemoteDeviceCommunicator<NetconfMessage> listener, BaseRpcSchemalessTransformer baseRpcTransformer, SchemalessMessageTransformer messageTransformer) {
        this.deviceId = deviceId;
        this.listener = listener;
        this.baseRpcTransformer = baseRpcTransformer;
        this.schemalessTransformer = messageTransformer;
    }

    public FluentFuture<DOMRpcResult> invokeRpc(SchemaPath type, NormalizedNode<?, ?> input) {
        MessageTransformer<NetconfMessage> transformer;
        if (input instanceof AnyXmlNode) {
            transformer = this.schemalessTransformer;
        } else if (SchemalessNetconfDeviceRpc.isBaseRpc(type)) {
            transformer = this.baseRpcTransformer;
        } else {
            return FluentFutures.immediateFailedFluentFuture((Throwable)new DOMRpcImplementationNotAvailableException("Unable to invoke rpc %s", new Object[]{type}));
        }
        return this.handleRpc(type, input, transformer);
    }

    private FluentFuture<DOMRpcResult> handleRpc(final @Nonnull SchemaPath type, @Nullable NormalizedNode<?, ?> input, final MessageTransformer<NetconfMessage> transformer) {
        FluentFuture<RpcResult<NetconfMessage>> delegateFuture = this.listener.sendRequest(transformer.toRpcRequest(type, input), type.getLastComponent());
        final SettableFuture ret = SettableFuture.create();
        delegateFuture.addCallback((FutureCallback)new FutureCallback<RpcResult<NetconfMessage>>(){

            public void onSuccess(RpcResult<NetconfMessage> result) {
                ret.set(result.isSuccessful() ? transformer.toRpcResult(result.getResult(), type) : new DefaultDOMRpcResult(result.getErrors()));
            }

            public void onFailure(Throwable cause) {
                ret.setException((Throwable)new DOMRpcImplementationNotAvailableException(cause, "Unable to invoke rpc %s on device %s", new Object[]{type, SchemalessNetconfDeviceRpc.this.deviceId}));
            }
        }, MoreExecutors.directExecutor());
        return ret;
    }

    private static boolean isBaseRpc(SchemaPath type) {
        return NetconfMessageTransformUtil.NETCONF_URI.equals(type.getLastComponent().getNamespace());
    }

    @Nonnull
    public <T extends DOMRpcAvailabilityListener> ListenerRegistration<T> registerRpcListener(@Nonnull T lsnr) {
        throw new UnsupportedOperationException("Not available for netconf 1.0");
    }
}

