/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.connect.netconf.sal.tx;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.common.api.TransactionCommitFailedException;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.NetconfDocumentedException;
import org.opendaylight.netconf.sal.connect.netconf.sal.tx.TxListener;
import org.opendaylight.netconf.sal.connect.netconf.util.NetconfBaseOps;
import org.opendaylight.netconf.sal.connect.util.RemoteDeviceId;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.opendaylight.yangtools.yang.data.api.ModifyAction;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.MixinNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWriteTx
implements DOMDataTreeWriteTransaction {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractWriteTx.class);
    protected final RemoteDeviceId id;
    protected final NetconfBaseOps netOps;
    protected final boolean rollbackSupport;
    protected final List<ListenableFuture<DOMRpcResult>> resultsFutures = new ArrayList<ListenableFuture<DOMRpcResult>>();
    private final List<TxListener> listeners = new CopyOnWriteArrayList<TxListener>();
    protected volatile boolean finished = false;

    public AbstractWriteTx(NetconfBaseOps netOps, RemoteDeviceId id, boolean rollbackSupport) {
        this.netOps = netOps;
        this.id = id;
        this.rollbackSupport = rollbackSupport;
        this.init();
    }

    protected static boolean isSuccess(DOMRpcResult result) {
        return result.getErrors().isEmpty();
    }

    protected void checkNotFinished() {
        Preconditions.checkState((!this.isFinished() ? 1 : 0) != 0, (String)"%s: Transaction %s already finished", (Object)this.id, (Object)this.getIdentifier());
    }

    protected boolean isFinished() {
        return this.finished;
    }

    public synchronized boolean cancel() {
        if (this.isFinished()) {
            return false;
        }
        this.listeners.forEach(listener -> listener.onTransactionCancelled(this));
        this.finished = true;
        this.cleanup();
        return true;
    }

    protected abstract void init();

    protected abstract void cleanup();

    public Object getIdentifier() {
        return this;
    }

    public synchronized void put(LogicalDatastoreType store, YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
        this.checkEditable(store);
        if (AbstractWriteTx.containsOnlyNonVisibleData(path, data)) {
            LOG.debug("Ignoring put for {} and data {}. Resulting data structure is empty.", (Object)path, data);
            return;
        }
        DataContainerChild<?, ?> editStructure = this.netOps.createEditConfigStrcture(Optional.ofNullable(data), Optional.of(ModifyAction.REPLACE), path);
        this.editConfig(path, Optional.ofNullable(data), editStructure, Optional.empty(), "put");
    }

    public synchronized void merge(LogicalDatastoreType store, YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
        this.checkEditable(store);
        if (AbstractWriteTx.containsOnlyNonVisibleData(path, data)) {
            LOG.debug("Ignoring merge for {} and data {}. Resulting data structure is empty.", (Object)path, data);
            return;
        }
        DataContainerChild<?, ?> editStructure = this.netOps.createEditConfigStrcture(Optional.ofNullable(data), Optional.empty(), path);
        this.editConfig(path, Optional.ofNullable(data), editStructure, Optional.empty(), "merge");
    }

    private static boolean containsOnlyNonVisibleData(YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
        return path.getPathArguments().size() == 1 && data instanceof MixinNode;
    }

    public synchronized void delete(LogicalDatastoreType store, YangInstanceIdentifier path) {
        this.checkEditable(store);
        DataContainerChild<?, ?> editStructure = this.netOps.createEditConfigStrcture(Optional.empty(), Optional.of(ModifyAction.DELETE), path);
        this.editConfig(path, Optional.empty(), editStructure, Optional.of(ModifyAction.NONE), "delete");
    }

    public @NonNull FluentFuture<? extends @NonNull CommitInfo> commit() {
        final SettableFuture resultFuture = SettableFuture.create();
        Futures.addCallback(this.commitConfiguration(), (FutureCallback)new FutureCallback<RpcResult<Void>>(){

            public void onSuccess(RpcResult<Void> result) {
                if (!result.isSuccessful()) {
                    Collection errors = result.getErrors();
                    resultFuture.setException((Throwable)new TransactionCommitFailedException(String.format("Commit of transaction %s failed", AbstractWriteTx.this.getIdentifier()), errors.toArray(new RpcError[errors.size()])));
                    return;
                }
                resultFuture.set((Object)CommitInfo.empty());
            }

            public void onFailure(Throwable failure) {
                resultFuture.setException((Throwable)new TransactionCommitFailedException(String.format("Commit of transaction %s failed", AbstractWriteTx.this.getIdentifier()), failure, new RpcError[0]));
            }
        }, (Executor)MoreExecutors.directExecutor());
        return FluentFuture.from((ListenableFuture)resultFuture);
    }

    protected final ListenableFuture<RpcResult<Void>> commitConfiguration() {
        this.listeners.forEach(listener -> listener.onTransactionSubmitted(this));
        this.checkNotFinished();
        this.finished = true;
        ListenableFuture<RpcResult<Void>> result = this.performCommit();
        Futures.addCallback(result, (FutureCallback)new FutureCallback<RpcResult<Void>>(){

            public void onSuccess(@Nonnull RpcResult<Void> rpcResult) {
                if (rpcResult.isSuccessful()) {
                    AbstractWriteTx.this.listeners.forEach(txListener -> txListener.onTransactionSuccessful(AbstractWriteTx.this));
                } else {
                    TransactionCommitFailedException cause = new TransactionCommitFailedException("Transaction failed", rpcResult.getErrors().toArray(new RpcError[rpcResult.getErrors().size()]));
                    AbstractWriteTx.this.listeners.forEach(listener -> listener.onTransactionFailed(AbstractWriteTx.this, (Throwable)cause));
                }
            }

            public void onFailure(Throwable throwable) {
                AbstractWriteTx.this.listeners.forEach(listener -> listener.onTransactionFailed(AbstractWriteTx.this, throwable));
            }
        }, (Executor)MoreExecutors.directExecutor());
        return result;
    }

    protected abstract ListenableFuture<RpcResult<Void>> performCommit();

    private void checkEditable(LogicalDatastoreType store) {
        this.checkNotFinished();
        Preconditions.checkArgument((store == LogicalDatastoreType.CONFIGURATION ? 1 : 0) != 0, (String)"Can edit only configuration data, not %s", (Object)store);
    }

    protected abstract void editConfig(YangInstanceIdentifier var1, Optional<NormalizedNode<?, ?>> var2, DataContainerChild<?, ?> var3, Optional<ModifyAction> var4, String var5);

    protected ListenableFuture<RpcResult<Void>> resultsToTxStatus() {
        final SettableFuture transformed = SettableFuture.create();
        Futures.addCallback((ListenableFuture)Futures.allAsList(this.resultsFutures), (FutureCallback)new FutureCallback<List<DOMRpcResult>>(){

            public void onSuccess(@Nonnull List<DOMRpcResult> domRpcResults) {
                if (!transformed.isDone()) {
                    AbstractWriteTx.this.extractResult(domRpcResults, (SettableFuture<RpcResult<Void>>)transformed);
                }
            }

            public void onFailure(Throwable throwable) {
                NetconfDocumentedException exception = new NetconfDocumentedException(AbstractWriteTx.this.id + ":RPC during tx returned an exception" + throwable.getMessage(), new Exception(throwable), DocumentedException.ErrorType.APPLICATION, DocumentedException.ErrorTag.OPERATION_FAILED, DocumentedException.ErrorSeverity.ERROR);
                transformed.setException((Throwable)exception);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return transformed;
    }

    private void extractResult(List<DOMRpcResult> domRpcResults, SettableFuture<RpcResult<Void>> transformed) {
        DocumentedException.ErrorType errType = DocumentedException.ErrorType.APPLICATION;
        DocumentedException.ErrorSeverity errSeverity = DocumentedException.ErrorSeverity.ERROR;
        StringBuilder msgBuilder = new StringBuilder();
        boolean errorsEncouneterd = false;
        String errorTag = "operation-failed";
        for (DOMRpcResult domRpcResult : domRpcResults) {
            if (domRpcResult.getErrors().isEmpty()) continue;
            errorsEncouneterd = true;
            RpcError error = (RpcError)domRpcResult.getErrors().iterator().next();
            RpcError.ErrorType errorType = error.getErrorType();
            switch (errorType) {
                case RPC: {
                    errType = DocumentedException.ErrorType.RPC;
                    break;
                }
                case PROTOCOL: {
                    errType = DocumentedException.ErrorType.PROTOCOL;
                    break;
                }
                case TRANSPORT: {
                    errType = DocumentedException.ErrorType.TRANSPORT;
                    break;
                }
                case APPLICATION: {
                    errType = DocumentedException.ErrorType.APPLICATION;
                    break;
                }
                default: {
                    errType = DocumentedException.ErrorType.APPLICATION;
                }
            }
            RpcError.ErrorSeverity severity = error.getSeverity();
            switch (severity) {
                case ERROR: {
                    errSeverity = DocumentedException.ErrorSeverity.ERROR;
                    break;
                }
                case WARNING: {
                    errSeverity = DocumentedException.ErrorSeverity.WARNING;
                    break;
                }
                default: {
                    errSeverity = DocumentedException.ErrorSeverity.ERROR;
                }
            }
            msgBuilder.append(error.getMessage());
            errorTag = error.getTag();
        }
        if (errorsEncouneterd) {
            NetconfDocumentedException exception = new NetconfDocumentedException(this.id + ":RPC during tx failed. " + msgBuilder.toString(), errType, DocumentedException.ErrorTag.from((String)errorTag), errSeverity);
            transformed.setException((Throwable)exception);
            return;
        }
        transformed.set((Object)RpcResultBuilder.success().build());
    }

    AutoCloseable addListener(TxListener listener) {
        this.listeners.add(listener);
        return () -> this.listeners.remove(listener);
    }
}

