/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.connect.netconf.sal.tx;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Optional;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.netconf.sal.connect.netconf.sal.tx.AbstractWriteTx;
import org.opendaylight.netconf.sal.connect.netconf.util.NetconfBaseOps;
import org.opendaylight.netconf.sal.connect.netconf.util.NetconfRpcFutureCallback;
import org.opendaylight.netconf.sal.connect.util.RemoteDeviceId;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.data.api.ModifyAction;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteCandidateTx
extends AbstractWriteTx {
    private static final Logger LOG = LoggerFactory.getLogger(WriteCandidateTx.class);

    public WriteCandidateTx(RemoteDeviceId id, NetconfBaseOps rpc, boolean rollbackSupport) {
        super(rpc, id, rollbackSupport);
    }

    @Override
    protected synchronized void init() {
        LOG.trace("{}: Initializing {} transaction", (Object)this.id, (Object)this.getClass().getSimpleName());
        this.lock();
    }

    private void lock() {
        FutureCallback<DOMRpcResult> lockCandidateCallback = new FutureCallback<DOMRpcResult>(){

            public void onSuccess(@Nonnull DOMRpcResult result) {
                if (AbstractWriteTx.isSuccess(result)) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Lock candidate successful");
                    }
                } else {
                    LOG.warn("{}: lock candidate invoked unsuccessfully: {}", (Object)WriteCandidateTx.this.id, (Object)result.getErrors());
                }
            }

            public void onFailure(Throwable throwable) {
                LOG.warn("Lock candidate operation failed", throwable);
                WriteCandidateTx.this.discardChanges();
            }
        };
        this.resultsFutures.add(this.netOps.lockCandidate(lockCandidateCallback));
    }

    @Override
    protected void cleanup() {
        this.discardChanges();
        this.cleanupOnSuccess();
    }

    private void discardChanges() {
        this.netOps.discardChanges(new NetconfRpcFutureCallback("Discarding candidate", this.id));
    }

    @Override
    public synchronized ListenableFuture<RpcResult<Void>> performCommit() {
        this.resultsFutures.add(this.netOps.commit(new NetconfRpcFutureCallback("Commit", this.id)));
        ListenableFuture<RpcResult<Void>> txResult = this.resultsToTxStatus();
        Futures.addCallback(txResult, (FutureCallback)new FutureCallback<RpcResult<Void>>(){

            public void onSuccess(@Nullable RpcResult<Void> result) {
                WriteCandidateTx.this.cleanupOnSuccess();
            }

            public void onFailure(Throwable throwable) {
                WriteCandidateTx.this.cleanup();
            }
        }, (Executor)MoreExecutors.directExecutor());
        return txResult;
    }

    protected void cleanupOnSuccess() {
        this.unlock();
    }

    @Override
    protected void editConfig(YangInstanceIdentifier path, Optional<NormalizedNode<?, ?>> data, DataContainerChild<?, ?> editStructure, Optional<ModifyAction> defaultOperation, String operation) {
        NetconfRpcFutureCallback editConfigCallback = new NetconfRpcFutureCallback("Edit candidate", this.id);
        if (defaultOperation.isPresent()) {
            this.resultsFutures.add(this.netOps.editConfigCandidate(editConfigCallback, editStructure, defaultOperation.get(), this.rollbackSupport));
        } else {
            this.resultsFutures.add(this.netOps.editConfigCandidate(editConfigCallback, editStructure, this.rollbackSupport));
        }
    }

    private void unlock() {
        this.netOps.unlockCandidate(new NetconfRpcFutureCallback("Unlock candidate", this.id));
    }
}

