/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.connect.netconf.schema.mapping;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.io.IOException;
import java.net.URISyntaxException;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.opendaylight.mdsal.dom.api.DOMActionResult;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.api.DOMEvent;
import org.opendaylight.mdsal.dom.api.DOMNotification;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.mdsal.dom.spi.DefaultDOMRpcResult;
import org.opendaylight.mdsal.dom.spi.SimpleDOMActionResult;
import org.opendaylight.netconf.api.NetconfMessage;
import org.opendaylight.netconf.api.xml.MissingNameSpaceException;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.sal.connect.api.MessageTransformer;
import org.opendaylight.netconf.sal.connect.netconf.schema.mapping.BaseSchema;
import org.opendaylight.netconf.sal.connect.netconf.util.NetconfMessageTransformUtil;
import org.opendaylight.netconf.sal.connect.util.MessageCounter;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.common.YangConstants;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.xml.XmlParserStream;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.NormalizedNodeResult;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextTree;
import org.opendaylight.yangtools.yang.model.api.ActionDefinition;
import org.opendaylight.yangtools.yang.model.api.ActionNodeContainer;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.OperationDefinition;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class NetconfMessageTransformer
implements MessageTransformer<NetconfMessage> {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfMessageTransformer.class);
    private final SchemaContext schemaContext;
    private final BaseSchema baseSchema;
    private final MessageCounter counter = new MessageCounter();
    private final Map<QName, RpcDefinition> mappedRpcs;
    private final Multimap<QName, NotificationDefinition> mappedNotifications;
    private final boolean strictParsing;
    private final Set<ActionDefinition> actions;

    public NetconfMessageTransformer(SchemaContext schemaContext, boolean strictParsing) {
        this(schemaContext, strictParsing, BaseSchema.BASE_NETCONF_CTX);
    }

    public NetconfMessageTransformer(SchemaContext schemaContext, boolean strictParsing, BaseSchema baseSchema) {
        this.schemaContext = schemaContext;
        this.mappedRpcs = Maps.uniqueIndex((Iterable)schemaContext.getOperations(), SchemaNode::getQName);
        this.actions = this.getActions();
        this.mappedNotifications = Multimaps.index((Iterable)schemaContext.getNotifications(), node -> node.getQName().withoutRevision());
        this.baseSchema = baseSchema;
        this.strictParsing = strictParsing;
    }

    @VisibleForTesting
    Set<ActionDefinition> getActions() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (DataSchemaNode dataSchemaNode : this.schemaContext.getChildNodes()) {
            if (!(dataSchemaNode instanceof ActionNodeContainer)) continue;
            this.findAction(dataSchemaNode, (ImmutableSet.Builder<ActionDefinition>)builder);
        }
        return builder.build();
    }

    private void findAction(DataSchemaNode dataSchemaNode, ImmutableSet.Builder<ActionDefinition> builder) {
        if (dataSchemaNode instanceof ActionNodeContainer) {
            ActionNodeContainer containerSchemaNode = (ActionNodeContainer)dataSchemaNode;
            for (ActionDefinition actionDefinition : containerSchemaNode.getActions()) {
                builder.add((Object)actionDefinition);
            }
        }
        if (dataSchemaNode instanceof DataNodeContainer) {
            for (DataSchemaNode innerDataSchemaNode : ((DataNodeContainer)dataSchemaNode).getChildNodes()) {
                this.findAction(innerDataSchemaNode, builder);
            }
        }
    }

    @Override
    public synchronized DOMNotification toNotification(NetconfMessage message) {
        ContainerNode content;
        QName notificationNoRev;
        Map.Entry<Instant, XmlElement> stripped = NetconfMessageTransformUtil.stripNotification(message);
        try {
            notificationNoRev = QName.create((String)stripped.getValue().getNamespace(), (String)stripped.getValue().getName()).withoutRevision();
        }
        catch (MissingNameSpaceException e) {
            throw new IllegalArgumentException("Unable to parse notification " + message + ", cannot find namespace", e);
        }
        Collection notificationDefinitions = this.mappedNotifications.get((Object)notificationNoRev);
        Preconditions.checkArgument((notificationDefinitions.size() > 0 ? 1 : 0) != 0, (String)"Unable to parse notification %s, unknown notification. Available notifications: %s", (Object)notificationNoRev, (Object)this.mappedNotifications.keySet());
        NotificationDefinition mostRecentNotification = NetconfMessageTransformer.getMostRecentNotification(notificationDefinitions);
        ContainerSchemaNode notificationAsContainerSchemaNode = NetconfMessageTransformUtil.createSchemaForNotification(mostRecentNotification);
        Element element = stripped.getValue().getDomElement();
        try {
            NormalizedNodeResult resultHolder = new NormalizedNodeResult();
            NormalizedNodeStreamWriter writer = ImmutableNormalizedNodeStreamWriter.from((NormalizedNodeResult)resultHolder);
            XmlParserStream xmlParser = XmlParserStream.create((NormalizedNodeStreamWriter)writer, (SchemaContext)this.schemaContext, (SchemaNode)notificationAsContainerSchemaNode, (boolean)this.strictParsing);
            xmlParser.traverse(new DOMSource(element));
            content = (ContainerNode)resultHolder.getResult();
        }
        catch (IOException | UnsupportedOperationException | URISyntaxException | ParserConfigurationException | XMLStreamException | SAXException e) {
            throw new IllegalArgumentException(String.format("Failed to parse notification %s", element), e);
        }
        return new NetconfDeviceNotification(content, stripped.getKey());
    }

    private static NotificationDefinition getMostRecentNotification(Collection<NotificationDefinition> notificationDefinitions) {
        return Collections.max(notificationDefinitions, (o1, o2) -> Revision.compare((Optional)o1.getQName().getRevision(), (Optional)o2.getQName().getRevision()));
    }

    @Override
    public NetconfMessage toRpcRequest(SchemaPath rpc, NormalizedNode<?, ?> payload) {
        QName rpcQName = rpc.getLastComponent();
        boolean needToUseBaseCtx = this.mappedRpcs.get(rpcQName) == null && NetconfMessageTransformer.isBaseOrNotificationRpc(rpcQName);
        Map<QName, RpcDefinition> currentMappedRpcs = needToUseBaseCtx ? this.baseSchema.getMappedRpcs() : this.mappedRpcs;
        RpcDefinition mappedRpc = (RpcDefinition)Preconditions.checkNotNull((Object)currentMappedRpcs.get(rpcQName), (String)"Unknown rpc %s, needToUseBaseCtx %s, available rpcs: %s", (Object)rpcQName, (Object)needToUseBaseCtx, currentMappedRpcs.keySet());
        if (mappedRpc.getInput().getChildNodes().isEmpty()) {
            return new NetconfMessage(NetconfMessageTransformUtil.prepareDomResultForRpcRequest(rpcQName, this.counter).getNode().getOwnerDocument());
        }
        Preconditions.checkNotNull(payload, (String)"Transforming an rpc with input: %s, payload cannot be null", (Object)rpcQName);
        Preconditions.checkArgument((boolean)(payload instanceof ContainerNode), (String)"Transforming an rpc with input: %s, payload has to be a container, but was: %s", (Object)rpcQName, payload);
        SchemaPath rpcInput = rpc.createChild(YangConstants.operationInputQName((QNameModule)rpcQName.getModule()));
        DOMResult result = NetconfMessageTransformUtil.prepareDomResultForRpcRequest(rpcQName, this.counter);
        try {
            SchemaContext ctx = needToUseBaseCtx ? this.baseSchema.getSchemaContext() : this.schemaContext;
            NetconfMessageTransformUtil.writeNormalizedRpc((ContainerNode)payload, result, rpcInput, ctx);
        }
        catch (IOException | IllegalStateException | XMLStreamException e) {
            throw new IllegalStateException("Unable to serialize " + rpcInput, e);
        }
        Document node = result.getNode().getOwnerDocument();
        return new NetconfMessage(node);
    }

    @Override
    public NetconfMessage toActionRequest(SchemaPath action, DOMDataTreeIdentifier domDataTreeIdentifier, NormalizedNode<?, ?> payload) {
        ActionDefinition actionDefinition = null;
        SchemaPath schemaPath = action;
        for (ActionDefinition actionDef : this.actions) {
            if (!actionDef.getPath().getLastComponent().equals((Object)action.getLastComponent())) continue;
            actionDefinition = actionDef;
            schemaPath = actionDef.getPath();
        }
        Preconditions.checkNotNull(actionDefinition, (String)"Action does not exist: %s", (Object)action.getLastComponent());
        if (actionDefinition.getInput().getChildNodes().isEmpty()) {
            return new NetconfMessage(NetconfMessageTransformUtil.prepareDomResultForActionRequest(DataSchemaContextTree.from((SchemaContext)this.schemaContext), domDataTreeIdentifier, action, this.counter, actionDefinition.getQName().getLocalName()).getNode().getOwnerDocument());
        }
        Preconditions.checkNotNull(payload, (String)"Transforming an action with input: %s, payload cannot be null", (Object)action.getLastComponent());
        Preconditions.checkArgument((boolean)(payload instanceof ContainerNode), (String)"Transforming an rpc with input: %s, payload has to be a container, but was: %s", (Object)action.getLastComponent(), payload);
        action = action.createChild(QName.create((QName)action.getLastComponent(), (String)"input").intern());
        DOMResult result = NetconfMessageTransformUtil.prepareDomResultForActionRequest(DataSchemaContextTree.from((SchemaContext)this.schemaContext), domDataTreeIdentifier, action, this.counter, actionDefinition.getQName().getLocalName());
        try {
            NetconfMessageTransformUtil.writeNormalizedRpc((ContainerNode)payload, result, schemaPath.createChild(QName.create((QName)action.getLastComponent(), (String)"input").intern()), this.schemaContext);
        }
        catch (IOException | IllegalStateException | XMLStreamException e) {
            throw new IllegalStateException("Unable to serialize " + action, e);
        }
        Document node = result.getNode().getOwnerDocument();
        return new NetconfMessage(node);
    }

    private static boolean isBaseOrNotificationRpc(QName rpc) {
        return rpc.getNamespace().equals(NetconfMessageTransformUtil.NETCONF_URI) || rpc.getNamespace().equals(NetconfMessageTransformUtil.IETF_NETCONF_NOTIFICATIONS.getNamespace()) || rpc.getNamespace().equals(NetconfMessageTransformUtil.CREATE_SUBSCRIPTION_RPC_QNAME.getNamespace());
    }

    @Override
    public synchronized DOMRpcResult toRpcResult(NetconfMessage message, SchemaPath rpc) {
        NormalizedNode normalizedNode;
        QName rpcQName = rpc.getLastComponent();
        if (NetconfMessageTransformUtil.isDataRetrievalOperation(rpcQName)) {
            ContainerNode dataNode;
            Element xmlData = NetconfMessageTransformUtil.getDataSubtree(message.getDocument());
            ContainerSchemaNode schemaForDataRead = NetconfMessageTransformUtil.createSchemaForDataRead(this.schemaContext);
            try {
                NormalizedNodeResult resultHolder = new NormalizedNodeResult();
                NormalizedNodeStreamWriter writer = ImmutableNormalizedNodeStreamWriter.from((NormalizedNodeResult)resultHolder);
                XmlParserStream xmlParser = XmlParserStream.create((NormalizedNodeStreamWriter)writer, (SchemaContext)this.schemaContext, (SchemaNode)schemaForDataRead, (boolean)this.strictParsing);
                xmlParser.traverse(new DOMSource(xmlData));
                dataNode = (ContainerNode)resultHolder.getResult();
            }
            catch (IOException | URISyntaxException | ParserConfigurationException | XMLStreamException | SAXException e) {
                throw new IllegalArgumentException(String.format("Failed to parse data response %s", xmlData), e);
            }
            normalizedNode = Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(NetconfMessageTransformUtil.NETCONF_RPC_REPLY_QNAME)).withChild((DataContainerChild)dataNode).build();
        } else {
            RpcDefinition rpcDefinition;
            boolean needToUseBaseCtx;
            Map<QName, RpcDefinition> currentMappedRpcs = this.mappedRpcs;
            boolean bl = needToUseBaseCtx = this.mappedRpcs.get(rpcQName) == null && NetconfMessageTransformer.isBaseOrNotificationRpc(rpcQName);
            if (needToUseBaseCtx) {
                currentMappedRpcs = this.baseSchema.getMappedRpcs();
            }
            Preconditions.checkArgument(((rpcDefinition = currentMappedRpcs.get(rpcQName)) != null ? 1 : 0) != 0, (String)"Unable to parse response of %s, the rpc is unknown", (Object)rpcQName);
            normalizedNode = this.parseResult(message, (OperationDefinition)rpcDefinition);
        }
        return new DefaultDOMRpcResult(normalizedNode);
    }

    @Override
    public DOMActionResult toActionResult(SchemaPath action, NetconfMessage message) {
        ActionDefinition actionDefinition = null;
        for (ActionDefinition actionDef : this.actions) {
            if (!actionDef.getPath().getLastComponent().equals((Object)action.getLastComponent())) continue;
            actionDefinition = actionDef;
        }
        Preconditions.checkNotNull(actionDefinition, (String)"Action does not exist: %s", (Object)action);
        ContainerNode normalizedNode = (ContainerNode)this.parseResult(message, (OperationDefinition)actionDefinition);
        if (normalizedNode == null) {
            return new SimpleDOMActionResult(Collections.emptyList());
        }
        return new SimpleDOMActionResult(normalizedNode, Collections.emptyList());
    }

    private NormalizedNode<?, ?> parseResult(NetconfMessage message, OperationDefinition operationDefinition) {
        Optional okResponseElement = XmlElement.fromDomDocument((Document)message.getDocument()).getOnlyChildElementWithSameNamespaceOptionally("ok");
        if (operationDefinition.getOutput().getChildNodes().isEmpty()) {
            Preconditions.checkArgument((boolean)okResponseElement.isPresent(), (String)"Unexpected content in response of rpc: %s, %s", (Object)operationDefinition.getQName(), (Object)message);
            return null;
        }
        if (okResponseElement.isPresent()) {
            LOG.debug("Received response <ok/> for RPC with defined Output");
            return null;
        }
        Element element = message.getDocument().getDocumentElement();
        try {
            NormalizedNodeResult resultHolder = new NormalizedNodeResult();
            NormalizedNodeStreamWriter writer = ImmutableNormalizedNodeStreamWriter.from((NormalizedNodeResult)resultHolder);
            XmlParserStream xmlParser = XmlParserStream.create((NormalizedNodeStreamWriter)writer, (SchemaContext)this.schemaContext, (SchemaNode)operationDefinition.getOutput(), (boolean)this.strictParsing);
            xmlParser.traverse(new DOMSource(element));
            return resultHolder.getResult();
        }
        catch (IOException | URISyntaxException | ParserConfigurationException | XMLStreamException | SAXException e) {
            throw new IllegalArgumentException(String.format("Failed to parse RPC response %s", element), e);
        }
    }

    static class NetconfDeviceNotification
    implements DOMNotification,
    DOMEvent {
        private final ContainerNode content;
        private final SchemaPath schemaPath;
        private final Instant eventTime;

        NetconfDeviceNotification(ContainerNode content, Instant eventTime) {
            this.content = content;
            this.eventTime = eventTime;
            this.schemaPath = NetconfMessageTransformUtil.toPath(content.getNodeType());
        }

        public SchemaPath getType() {
            return this.schemaPath;
        }

        public ContainerNode getBody() {
            return this.content;
        }

        public Instant getEventInstant() {
            return this.eventTime;
        }
    }
}

