/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.connect.netconf.schema.mapping;

import java.time.Instant;
import java.util.Map;
import javax.xml.transform.dom.DOMSource;
import org.opendaylight.mdsal.dom.api.DOMNotification;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.mdsal.dom.spi.DefaultDOMRpcResult;
import org.opendaylight.netconf.api.NetconfMessage;
import org.opendaylight.netconf.api.xml.MissingNameSpaceException;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.sal.connect.api.MessageTransformer;
import org.opendaylight.netconf.sal.connect.netconf.schema.mapping.BaseRpcSchemalessTransformer;
import org.opendaylight.netconf.sal.connect.netconf.schema.mapping.NetconfMessageTransformer;
import org.opendaylight.netconf.sal.connect.netconf.util.NetconfMessageTransformUtil;
import org.opendaylight.netconf.sal.connect.util.MessageCounter;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AnyXmlNode;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SchemalessMessageTransformer
implements MessageTransformer<NetconfMessage> {
    private static final YangInstanceIdentifier.NodeIdentifier REPLY_ID = new YangInstanceIdentifier.NodeIdentifier(NetconfMessageTransformUtil.NETCONF_RPC_REPLY_QNAME);
    public static final YangInstanceIdentifier.NodeIdentifier SCHEMALESS_NOTIFICATION_PAYLOAD = new YangInstanceIdentifier.NodeIdentifier(QName.create((String)"", (String)"schemaless-notification-payload"));
    private final MessageCounter counter;

    public SchemalessMessageTransformer(MessageCounter counter) {
        this.counter = counter;
    }

    @Override
    public DOMNotification toNotification(NetconfMessage message) {
        QName notificationNoRev;
        Map.Entry<Instant, XmlElement> stripped = NetconfMessageTransformUtil.stripNotification(message);
        try {
            notificationNoRev = QName.create((String)stripped.getValue().getNamespace(), (String)stripped.getValue().getName()).withoutRevision();
        }
        catch (MissingNameSpaceException e) {
            throw new IllegalArgumentException("Unable to parse notification " + message + ", cannot find namespace", e);
        }
        AnyXmlNode notificationPayload = (AnyXmlNode)Builders.anyXmlBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(notificationNoRev)).withValue((Object)new DOMSource(stripped.getValue().getDomElement())).build();
        ContainerNode notificationBody = (ContainerNode)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)SCHEMALESS_NOTIFICATION_PAYLOAD).withChild((DataContainerChild)notificationPayload).build();
        return new NetconfMessageTransformer.NetconfDeviceNotification(notificationBody, stripped.getKey());
    }

    @Override
    public NetconfMessage toRpcRequest(SchemaPath rpc, NormalizedNode<?, ?> input) {
        DOMSource payload = (DOMSource)input.getValue();
        this.wrapPayload((Document)payload.getNode());
        return new NetconfMessage((Document)((AnyXmlNode)input).getValue().getNode());
    }

    @Override
    public DOMRpcResult toRpcResult(NetconfMessage rpcReply, SchemaPath rpc) {
        Document document = rpcReply.getDocument();
        AnyXmlNode result = BaseRpcSchemalessTransformer.isOkPresent(document) ? null : (AnyXmlNode)Builders.anyXmlBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)REPLY_ID).withValue((Object)new DOMSource(rpcReply.getDocument())).build();
        return new DefaultDOMRpcResult(result);
    }

    private void wrapPayload(Document doc) {
        Element payload = doc.getDocumentElement();
        doc.removeChild(payload);
        Element rpcNS = doc.createElementNS(NetconfMessageTransformUtil.NETCONF_RPC_QNAME.getNamespace().toString(), NetconfMessageTransformUtil.NETCONF_RPC_QNAME.getLocalName());
        rpcNS.setAttribute("message-id", this.counter.getNewMessageId("m"));
        rpcNS.appendChild(payload);
        doc.appendChild(rpcNS);
    }
}

