/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.connect.netconf.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.URI;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.FailedNetconfMessage;
import org.opendaylight.netconf.api.NetconfDocumentedException;
import org.opendaylight.netconf.api.NetconfMessage;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.api.xml.XmlUtil;
import org.opendaylight.netconf.notifications.NetconfNotification;
import org.opendaylight.netconf.sal.connect.netconf.util.NodeContainerProxy;
import org.opendaylight.netconf.sal.connect.util.MessageCounter;
import org.opendaylight.netconf.util.NetconfUtil;
import org.opendaylight.netconf.util.messages.NetconfMessageUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.edit.config.input.EditContent;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.notification._1._0.rev080714.CreateSubscriptionInput;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.NetconfState;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfCapabilityChange;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.opendaylight.yangtools.yang.data.api.ModifyAction;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AnyXmlNode;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.xml.XMLStreamNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.impl.schema.SchemaOrderedNormalizedNodeWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.NormalizedNodeAttrBuilder;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextNode;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextTree;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class NetconfMessageTransformUtil {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfMessageTransformUtil.class);
    public static final String MESSAGE_ID_PREFIX = "m";
    public static final String MESSAGE_ID_ATTR = "message-id";
    public static final QName CREATE_SUBSCRIPTION_RPC_QNAME = QName.create((QName)CreateSubscriptionInput.QNAME, (String)"create-subscription").intern();
    private static final String SUBTREE = "subtree";
    private static final Document BLANK_DOCUMENT = XmlUtil.newDocument();
    public static final String EVENT_TIME = "eventTime";
    public static final QName IETF_NETCONF_MONITORING = QName.create((QName)NetconfState.QNAME, (String)"ietf-netconf-monitoring").intern();
    public static final QName GET_DATA_QNAME = QName.create((QName)IETF_NETCONF_MONITORING, (String)"data").intern();
    public static final QName GET_SCHEMA_QNAME = QName.create((QName)IETF_NETCONF_MONITORING, (String)"get-schema").intern();
    public static final QName IETF_NETCONF_MONITORING_SCHEMA_FORMAT = QName.create((QName)IETF_NETCONF_MONITORING, (String)"format").intern();
    public static final QName IETF_NETCONF_MONITORING_SCHEMA_LOCATION = QName.create((QName)IETF_NETCONF_MONITORING, (String)"location").intern();
    public static final QName IETF_NETCONF_MONITORING_SCHEMA_IDENTIFIER = QName.create((QName)IETF_NETCONF_MONITORING, (String)"identifier").intern();
    public static final QName IETF_NETCONF_MONITORING_SCHEMA_VERSION = QName.create((QName)IETF_NETCONF_MONITORING, (String)"version").intern();
    public static final QName IETF_NETCONF_MONITORING_SCHEMA_NAMESPACE = QName.create((QName)IETF_NETCONF_MONITORING, (String)"namespace").intern();
    public static final QName IETF_NETCONF_NOTIFICATIONS = QName.create((QName)NetconfCapabilityChange.QNAME, (String)"ietf-netconf-notifications").intern();
    public static final QName NETCONF_QNAME = QName.create((String)"urn:ietf:params:xml:ns:netconf:base:1.0", (String)"2011-06-01", (String)"netconf").intern();
    public static final URI NETCONF_URI = NETCONF_QNAME.getNamespace();
    public static final QName NETCONF_DATA_QNAME = QName.create((QName)NETCONF_QNAME, (String)"data").intern();
    public static final YangInstanceIdentifier.NodeIdentifier NETCONF_DATA_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)NETCONF_DATA_QNAME);
    public static final QName NETCONF_RPC_REPLY_QNAME = QName.create((QName)NETCONF_QNAME, (String)"rpc-reply").intern();
    public static final QName NETCONF_OK_QNAME = QName.create((QName)NETCONF_QNAME, (String)"ok").intern();
    public static final QName NETCONF_ERROR_OPTION_QNAME = QName.create((QName)NETCONF_QNAME, (String)"error-option").intern();
    public static final YangInstanceIdentifier.NodeIdentifier NETCONF_ERROR_OPTION_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)NETCONF_ERROR_OPTION_QNAME);
    public static final QName NETCONF_RUNNING_QNAME = QName.create((QName)NETCONF_QNAME, (String)"running").intern();
    public static final QName NETCONF_SOURCE_QNAME = QName.create((QName)NETCONF_QNAME, (String)"source").intern();
    public static final YangInstanceIdentifier.NodeIdentifier NETCONF_SOURCE_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)NETCONF_SOURCE_QNAME);
    public static final QName NETCONF_CANDIDATE_QNAME = QName.create((QName)NETCONF_QNAME, (String)"candidate").intern();
    public static final QName NETCONF_TARGET_QNAME = QName.create((QName)NETCONF_QNAME, (String)"target").intern();
    public static final YangInstanceIdentifier.NodeIdentifier NETCONF_TARGET_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)NETCONF_TARGET_QNAME);
    public static final QName NETCONF_CONFIG_QNAME = QName.create((QName)NETCONF_QNAME, (String)"config").intern();
    public static final YangInstanceIdentifier.NodeIdentifier NETCONF_CONFIG_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)NETCONF_CONFIG_QNAME);
    public static final QName NETCONF_COMMIT_QNAME = QName.create((QName)NETCONF_QNAME, (String)"commit").intern();
    public static final SchemaPath NETCONF_COMMIT_PATH = NetconfMessageTransformUtil.toPath(NETCONF_COMMIT_QNAME);
    public static final QName NETCONF_VALIDATE_QNAME = QName.create((QName)NETCONF_QNAME, (String)"validate").intern();
    public static final YangInstanceIdentifier.NodeIdentifier NETCONF_VALIDATE_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)NETCONF_VALIDATE_QNAME);
    public static final SchemaPath NETCONF_VALIDATE_PATH = NetconfMessageTransformUtil.toPath(NETCONF_VALIDATE_QNAME);
    public static final QName NETCONF_COPY_CONFIG_QNAME = QName.create((QName)NETCONF_QNAME, (String)"copy-config").intern();
    public static final YangInstanceIdentifier.NodeIdentifier NETCONF_COPY_CONFIG_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)NETCONF_COPY_CONFIG_QNAME);
    public static final SchemaPath NETCONF_COPY_CONFIG_PATH = NetconfMessageTransformUtil.toPath(NETCONF_COPY_CONFIG_QNAME);
    public static final QName NETCONF_OPERATION_QNAME = QName.create((QName)NETCONF_QNAME, (String)"operation").intern();
    public static final QName NETCONF_DEFAULT_OPERATION_QNAME = QName.create((QName)NETCONF_OPERATION_QNAME, (String)"default-operation").intern();
    public static final YangInstanceIdentifier.NodeIdentifier NETCONF_DEFAULT_OPERATION_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)NETCONF_DEFAULT_OPERATION_QNAME);
    public static final QName NETCONF_EDIT_CONFIG_QNAME = QName.create((QName)NETCONF_QNAME, (String)"edit-config").intern();
    public static final YangInstanceIdentifier.NodeIdentifier NETCONF_EDIT_CONFIG_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)NETCONF_EDIT_CONFIG_QNAME);
    public static final SchemaPath NETCONF_EDIT_CONFIG_PATH = NetconfMessageTransformUtil.toPath(NETCONF_EDIT_CONFIG_QNAME);
    public static final QName NETCONF_GET_CONFIG_QNAME = QName.create((QName)NETCONF_QNAME, (String)"get-config");
    public static final YangInstanceIdentifier.NodeIdentifier NETCONF_GET_CONFIG_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)NETCONF_GET_CONFIG_QNAME);
    public static final SchemaPath NETCONF_GET_CONFIG_PATH = NetconfMessageTransformUtil.toPath(NETCONF_GET_CONFIG_QNAME);
    public static final QName NETCONF_DISCARD_CHANGES_QNAME = QName.create((QName)NETCONF_QNAME, (String)"discard-changes");
    public static final SchemaPath NETCONF_DISCARD_CHANGES_PATH = NetconfMessageTransformUtil.toPath(NETCONF_DISCARD_CHANGES_QNAME);
    public static final QName NETCONF_TYPE_QNAME = QName.create((QName)NETCONF_QNAME, (String)"type").intern();
    public static final QName NETCONF_FILTER_QNAME = QName.create((QName)NETCONF_QNAME, (String)"filter").intern();
    public static final QName NETCONF_GET_QNAME = QName.create((QName)NETCONF_QNAME, (String)"get").intern();
    public static final YangInstanceIdentifier.NodeIdentifier NETCONF_GET_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)NETCONF_GET_QNAME);
    public static final SchemaPath NETCONF_GET_PATH = NetconfMessageTransformUtil.toPath(NETCONF_GET_QNAME);
    public static final QName NETCONF_RPC_QNAME = QName.create((QName)NETCONF_QNAME, (String)"rpc").intern();
    public static final QName YANG_QNAME = null;
    public static final URI NETCONF_ACTION_NAMESPACE = URI.create("urn:ietf:params:xml:ns:yang:1");
    public static final String NETCONF_ACTION = "action";
    public static final URI NETCONF_ROLLBACK_ON_ERROR_URI = URI.create("urn:ietf:params:netconf:capability:rollback-on-error:1.0");
    public static final String ROLLBACK_ON_ERROR_OPTION = "rollback-on-error";
    public static final URI NETCONF_CANDIDATE_URI = URI.create("urn:ietf:params:netconf:capability:candidate:1.0");
    public static final URI NETCONF_NOTIFICATONS_URI = URI.create("urn:ietf:params:netconf:capability:notification:1.0");
    public static final URI NETCONF_RUNNING_WRITABLE_URI = URI.create("urn:ietf:params:netconf:capability:writable-running:1.0");
    public static final QName NETCONF_LOCK_QNAME = QName.create((QName)NETCONF_QNAME, (String)"lock").intern();
    public static final YangInstanceIdentifier.NodeIdentifier NETCONF_LOCK_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)NETCONF_LOCK_QNAME);
    public static final SchemaPath NETCONF_LOCK_PATH = NetconfMessageTransformUtil.toPath(NETCONF_LOCK_QNAME);
    public static final QName NETCONF_UNLOCK_QNAME = QName.create((QName)NETCONF_QNAME, (String)"unlock").intern();
    public static final YangInstanceIdentifier.NodeIdentifier NETCONF_UNLOCK_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)NETCONF_UNLOCK_QNAME);
    public static final SchemaPath NETCONF_UNLOCK_PATH = NetconfMessageTransformUtil.toPath(NETCONF_UNLOCK_QNAME);
    public static final YangInstanceIdentifier.NodeIdentifier EDIT_CONTENT_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)EditContent.QNAME);
    public static final ContainerNode DISCARD_CHANGES_RPC_CONTENT = (ContainerNode)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifier.create((QName)NETCONF_DISCARD_CHANGES_QNAME)).build();
    public static final ContainerNode COMMIT_RPC_CONTENT = (ContainerNode)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifier.create((QName)NETCONF_COMMIT_QNAME)).build();
    public static final ContainerNode GET_RPC_CONTENT = (ContainerNode)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NETCONF_GET_NODEID).build();
    public static final ContainerNode CREATE_SUBSCRIPTION_RPC_CONTENT = (ContainerNode)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifier.create((QName)CREATE_SUBSCRIPTION_RPC_QNAME)).build();
    private static final YangInstanceIdentifier.NodeIdentifier NETCONF_FILTER_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)NETCONF_FILTER_QNAME);
    private static final Map<QName, String> SUBTREE_FILTER_ATTRIBUTES = ImmutableMap.of((Object)NETCONF_TYPE_QNAME, (Object)"subtree");
    public static final DataContainerChild<?, ?> EMPTY_FILTER;

    private NetconfMessageTransformUtil() {
    }

    public static DataContainerChild<?, ?> toFilterStructure(YangInstanceIdentifier identifier, SchemaContext ctx) {
        NormalizedNodeAttrBuilder anyXmlBuilder = (NormalizedNodeAttrBuilder)Builders.anyXmlBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NETCONF_FILTER_NODEID).withAttributes(SUBTREE_FILTER_ATTRIBUTES);
        Element element = XmlUtil.createElement((Document)BLANK_DOCUMENT, (String)NETCONF_FILTER_QNAME.getLocalName(), Optional.of(NETCONF_FILTER_QNAME.getNamespace().toString()));
        element.setAttributeNS(NETCONF_FILTER_QNAME.getNamespace().toString(), NETCONF_TYPE_QNAME.getLocalName(), SUBTREE);
        try {
            NetconfUtil.writeFilter((YangInstanceIdentifier)identifier, (DOMResult)new DOMResult(element), (SchemaPath)SchemaPath.ROOT, (SchemaContext)ctx);
        }
        catch (IOException | XMLStreamException e) {
            throw new IllegalStateException("Unable to serialize filter element for path " + identifier, e);
        }
        anyXmlBuilder.withValue((Object)new DOMSource(element));
        return (DataContainerChild)anyXmlBuilder.build();
    }

    public static void checkValidReply(NetconfMessage input, NetconfMessage output) throws NetconfDocumentedException {
        String outputMsgId;
        String inputMsgId = input.getDocument().getDocumentElement().getAttribute(MESSAGE_ID_ATTR);
        if (!inputMsgId.equals(outputMsgId = output.getDocument().getDocumentElement().getAttribute(MESSAGE_ID_ATTR))) {
            ImmutableMap errorInfo = ImmutableMap.builder().put((Object)"actual-message-id", (Object)outputMsgId).put((Object)"expected-message-id", (Object)inputMsgId).build();
            throw new NetconfDocumentedException("Response message contained unknown \"message-id\"", null, DocumentedException.ErrorType.PROTOCOL, DocumentedException.ErrorTag.BAD_ATTRIBUTE, DocumentedException.ErrorSeverity.ERROR, (Map)errorInfo);
        }
    }

    public static void checkSuccessReply(NetconfMessage output) throws NetconfDocumentedException {
        if (NetconfMessageUtil.isErrorMessage((NetconfMessage)output)) {
            throw NetconfDocumentedException.fromXMLDocument((Document)output.getDocument());
        }
    }

    public static RpcError toRpcError(NetconfDocumentedException ex) {
        RpcError.ErrorSeverity severity;
        StringBuilder infoBuilder = new StringBuilder();
        Map errorInfo = ex.getErrorInfo();
        if (errorInfo != null) {
            for (Map.Entry e : errorInfo.entrySet()) {
                infoBuilder.append('<').append((String)e.getKey()).append('>').append((String)e.getValue()).append("</").append((String)e.getKey()).append('>');
            }
        }
        return (severity = NetconfMessageTransformUtil.toRpcErrorSeverity(ex.getErrorSeverity())) == RpcError.ErrorSeverity.ERROR ? RpcResultBuilder.newError((RpcError.ErrorType)NetconfMessageTransformUtil.toRpcErrorType(ex.getErrorType()), (String)ex.getErrorTag().getTagValue(), (String)ex.getLocalizedMessage(), null, (String)infoBuilder.toString(), (Throwable)ex.getCause()) : RpcResultBuilder.newWarning((RpcError.ErrorType)NetconfMessageTransformUtil.toRpcErrorType(ex.getErrorType()), (String)ex.getErrorTag().getTagValue(), (String)ex.getLocalizedMessage(), null, (String)infoBuilder.toString(), (Throwable)ex.getCause());
    }

    private static RpcError.ErrorSeverity toRpcErrorSeverity(DocumentedException.ErrorSeverity severity) {
        switch (severity) {
            case WARNING: {
                return RpcError.ErrorSeverity.WARNING;
            }
        }
        return RpcError.ErrorSeverity.ERROR;
    }

    private static RpcError.ErrorType toRpcErrorType(DocumentedException.ErrorType type) {
        switch (type) {
            case PROTOCOL: {
                return RpcError.ErrorType.PROTOCOL;
            }
            case RPC: {
                return RpcError.ErrorType.RPC;
            }
            case TRANSPORT: {
                return RpcError.ErrorType.TRANSPORT;
            }
        }
        return RpcError.ErrorType.APPLICATION;
    }

    public static YangInstanceIdentifier.NodeIdentifier toId(YangInstanceIdentifier.PathArgument qname) {
        return qname instanceof YangInstanceIdentifier.NodeIdentifier ? (YangInstanceIdentifier.NodeIdentifier)qname : NetconfMessageTransformUtil.toId(qname.getNodeType());
    }

    public static YangInstanceIdentifier.NodeIdentifier toId(QName nodeType) {
        return new YangInstanceIdentifier.NodeIdentifier(nodeType);
    }

    public static Element getDataSubtree(Document doc) {
        return (Element)doc.getElementsByTagNameNS(NETCONF_URI.toString(), "data").item(0);
    }

    public static boolean isDataRetrievalOperation(QName rpc) {
        return NETCONF_URI.equals(rpc.getNamespace()) && (NETCONF_GET_CONFIG_QNAME.getLocalName().equals(rpc.getLocalName()) || NETCONF_GET_QNAME.getLocalName().equals(rpc.getLocalName()));
    }

    public static ContainerSchemaNode createSchemaForDataRead(SchemaContext schemaContext) {
        return new NodeContainerProxy(NETCONF_DATA_QNAME, schemaContext.getChildNodes());
    }

    public static ContainerSchemaNode createSchemaForNotification(NotificationDefinition next) {
        return new NodeContainerProxy(next.getQName(), next.getChildNodes(), (Set<AugmentationSchemaNode>)next.getAvailableAugmentations());
    }

    @Deprecated
    public static ContainerNode wrap(QName name, DataContainerChild<?, ?> ... node) {
        return NetconfMessageTransformUtil.wrap(NetconfMessageTransformUtil.toId(name), node);
    }

    public static ContainerNode wrap(YangInstanceIdentifier.NodeIdentifier name, DataContainerChild<?, ?> ... node) {
        return (ContainerNode)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)name).withValue((Collection)ImmutableList.copyOf((Object[])node)).build();
    }

    public static AnyXmlNode createEditConfigAnyxml(SchemaContext ctx, YangInstanceIdentifier dataPath, Optional<ModifyAction> operation, Optional<NormalizedNode<?, ?>> lastChildOverride) {
        NormalizedNode<?, ?> configContent;
        if (dataPath.isEmpty()) {
            Preconditions.checkArgument((boolean)lastChildOverride.isPresent(), (Object)"Data has to be present when creating structure for top level element");
            Preconditions.checkArgument((boolean)(lastChildOverride.get() instanceof DataContainerChild), (String)"Data has to be either container or a list node when creating structure for top level element, but was: %s", lastChildOverride.get());
            configContent = lastChildOverride.get();
        } else {
            AbstractMap.SimpleEntry<QName, ModifyAction> modifyOperation = operation.isPresent() ? new AbstractMap.SimpleEntry<QName, ModifyAction>(NETCONF_OPERATION_QNAME, operation.get()) : null;
            configContent = ImmutableNodes.fromInstanceId((SchemaContext)ctx, (YangInstanceIdentifier)dataPath, lastChildOverride, Optional.ofNullable(modifyOperation));
        }
        Element element = XmlUtil.createElement((Document)BLANK_DOCUMENT, (String)NETCONF_CONFIG_QNAME.getLocalName(), Optional.of(NETCONF_CONFIG_QNAME.getNamespace().toString()));
        try {
            NetconfUtil.writeNormalizedNode(configContent, (DOMResult)new DOMResult(element), (SchemaPath)SchemaPath.ROOT, (SchemaContext)ctx);
        }
        catch (IOException | XMLStreamException e) {
            throw new IllegalStateException("Unable to serialize edit config content element for path " + dataPath, e);
        }
        return (AnyXmlNode)Builders.anyXmlBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NETCONF_CONFIG_NODEID).withValue((Object)new DOMSource(element)).build();
    }

    public static DataContainerChild<?, ?> createEditConfigStructure(SchemaContext ctx, YangInstanceIdentifier dataPath, Optional<ModifyAction> operation, Optional<NormalizedNode<?, ?>> lastChildOverride) {
        return (DataContainerChild)Builders.choiceBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)EDIT_CONTENT_NODEID).withChild((DataContainerChild)NetconfMessageTransformUtil.createEditConfigAnyxml(ctx, dataPath, operation, lastChildOverride)).build();
    }

    public static SchemaPath toPath(QName rpc) {
        return SchemaPath.ROOT.createChild(rpc);
    }

    public static Map.Entry<Instant, XmlElement> stripNotification(NetconfMessage message) {
        XmlElement notificationElement;
        XmlElement eventTimeElement;
        XmlElement xmlElement = XmlElement.fromDomDocument((Document)message.getDocument());
        List childElements = xmlElement.getChildElements();
        Preconditions.checkArgument((childElements.size() == 2 ? 1 : 0) != 0, (String)"Unable to parse notification %s, unexpected format.\nExpected 2 childElements, actual childElements size is %s", (Object)message, (int)childElements.size());
        if (((XmlElement)childElements.get(0)).getName().equals(EVENT_TIME)) {
            eventTimeElement = (XmlElement)childElements.get(0);
            notificationElement = (XmlElement)childElements.get(1);
        } else if (((XmlElement)childElements.get(1)).getName().equals(EVENT_TIME)) {
            eventTimeElement = (XmlElement)childElements.get(1);
            notificationElement = (XmlElement)childElements.get(0);
        } else {
            throw new IllegalArgumentException("Notification payload does not contain eventTime " + message);
        }
        try {
            return new AbstractMap.SimpleEntry<Instant, XmlElement>(((Date)NetconfNotification.RFC3339_DATE_PARSER.apply(eventTimeElement.getTextContent())).toInstant(), notificationElement);
        }
        catch (DocumentedException e) {
            throw new IllegalArgumentException("Notification payload does not contain eventTime " + message, e);
        }
        catch (DateTimeParseException e) {
            LOG.warn("Unable to parse event time from {}. Setting time to {}", new Object[]{eventTimeElement, NetconfNotification.UNKNOWN_EVENT_TIME, e});
            return new AbstractMap.SimpleEntry<Instant, XmlElement>(NetconfNotification.UNKNOWN_EVENT_TIME.toInstant(), notificationElement);
        }
    }

    public static DOMResult prepareDomResultForRpcRequest(QName rpcQName, MessageCounter counter) {
        Document document = XmlUtil.newDocument();
        Element rpcNS = document.createElementNS(NETCONF_RPC_QNAME.getNamespace().toString(), NETCONF_RPC_QNAME.getLocalName());
        rpcNS.setAttribute(MESSAGE_ID_ATTR, counter.getNewMessageId(MESSAGE_ID_PREFIX));
        Element elementNS = document.createElementNS(rpcQName.getNamespace().toString(), rpcQName.getLocalName());
        rpcNS.appendChild(elementNS);
        document.appendChild(rpcNS);
        return new DOMResult(elementNS);
    }

    public static DOMResult prepareDomResultForActionRequest(DataSchemaContextTree dataSchemaContextTree, DOMDataTreeIdentifier domDataTreeIdentifier, SchemaPath actionSchemaPath, MessageCounter counter, String action) {
        Document document = XmlUtil.newDocument();
        Element rpcNS = document.createElementNS(NETCONF_RPC_QNAME.getNamespace().toString(), NETCONF_RPC_QNAME.getLocalName());
        rpcNS.setAttribute(MESSAGE_ID_ATTR, counter.getNewMessageId(MESSAGE_ID_PREFIX));
        Element actionNS = document.createElementNS(NETCONF_ACTION_NAMESPACE.toString(), NETCONF_ACTION);
        DataSchemaContextNode rootSchemaContextNode = dataSchemaContextTree.getRoot();
        Element actionData = NetconfMessageTransformUtil.prepareActionData(rootSchemaContextNode, actionNS, domDataTreeIdentifier.getRootIdentifier().getPathArguments().iterator(), document);
        Element specificActionElement = document.createElement(action);
        actionData.appendChild(specificActionElement);
        rpcNS.appendChild(actionNS);
        document.appendChild(rpcNS);
        return new DOMResult(specificActionElement);
    }

    private static Element prepareActionData(DataSchemaContextNode<?> currentParentSchemaNode, Element actionNS, Iterator<YangInstanceIdentifier.PathArgument> iterator, Document document) {
        if (iterator.hasNext()) {
            YangInstanceIdentifier.PathArgument next = iterator.next();
            QName actualNS = next.getNodeType();
            DataSchemaContextNode current = currentParentSchemaNode.getChild(next);
            Preconditions.checkArgument((current != null ? 1 : 0) != 0, (String)"Invalid input: schema for argument %s not found", (Object)next);
            if (current.isMixin()) {
                return NetconfMessageTransformUtil.prepareActionData(current, actionNS, iterator, document);
            }
            Element actualElement = document.createElementNS(actualNS.getNamespace().toString(), actualNS.getLocalName());
            if (next instanceof YangInstanceIdentifier.NodeWithValue) {
                actualElement.setNodeValue(((YangInstanceIdentifier.NodeWithValue)next).getValue().toString());
            } else if (next instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates) {
                for (Map.Entry entry : ((YangInstanceIdentifier.NodeIdentifierWithPredicates)next).getKeyValues().entrySet()) {
                    Element entryElement = document.createElementNS(((QName)entry.getKey()).getNamespace().toString(), ((QName)entry.getKey()).getLocalName());
                    entryElement.setTextContent(entry.getValue().toString());
                    entryElement.setNodeValue(entry.getValue().toString());
                    actualElement.appendChild(entryElement);
                }
            }
            actionNS.appendChild(actualElement);
            return NetconfMessageTransformUtil.prepareActionData(current, actualElement, iterator, document);
        }
        return actionNS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeNormalizedRpc(ContainerNode normalized, DOMResult result, SchemaPath schemaPath, SchemaContext baseNetconfCtx) throws IOException, XMLStreamException {
        XMLStreamWriter writer = NetconfUtil.XML_FACTORY.createXMLStreamWriter(result);
        try (NormalizedNodeStreamWriter normalizedNodeStreamWriter = XMLStreamNormalizedNodeStreamWriter.create((XMLStreamWriter)writer, (SchemaContext)baseNetconfCtx, (SchemaPath)schemaPath);
             SchemaOrderedNormalizedNodeWriter normalizedNodeWriter = new SchemaOrderedNormalizedNodeWriter(normalizedNodeStreamWriter, baseNetconfCtx, schemaPath);){
            Collection value = normalized.getValue();
            normalizedNodeWriter.write(value);
            normalizedNodeWriter.flush();
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception e) {
                LOG.warn("Unable to close resource properly", (Throwable)e);
            }
        }
    }

    public static RpcResult<NetconfMessage> toRpcResult(FailedNetconfMessage message) {
        return RpcResultBuilder.failed().withRpcError(NetconfMessageTransformUtil.toRpcError(new NetconfDocumentedException(message.getException().getMessage(), DocumentedException.ErrorType.APPLICATION, DocumentedException.ErrorTag.MALFORMED_MESSAGE, DocumentedException.ErrorSeverity.ERROR))).build();
    }

    static {
        NormalizedNodeAttrBuilder anyXmlBuilder = (NormalizedNodeAttrBuilder)Builders.anyXmlBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NETCONF_FILTER_NODEID).withAttributes(SUBTREE_FILTER_ATTRIBUTES);
        Element element = XmlUtil.createElement((Document)BLANK_DOCUMENT, (String)NETCONF_FILTER_QNAME.getLocalName(), Optional.of(NETCONF_FILTER_QNAME.getNamespace().toString()));
        element.setAttributeNS(NETCONF_FILTER_QNAME.getNamespace().toString(), NETCONF_TYPE_QNAME.getLocalName(), SUBTREE);
        anyXmlBuilder.withValue((Object)new DOMSource(element));
        EMPTY_FILTER = (DataContainerChild)anyXmlBuilder.build();
    }
}

