/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.connect.netconf.util;

import java.util.Optional;
import org.opendaylight.netconf.sal.connect.netconf.util.NetconfMessageTransformUtil;
import org.opendaylight.netconf.sal.connect.netconf.util.RpcStructureTransformer;
import org.opendaylight.yangtools.yang.data.api.ModifyAction;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AnyXmlNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodes;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

class NetconfRpcStructureTransformer
implements RpcStructureTransformer {
    private final SchemaContext schemaContext;

    NetconfRpcStructureTransformer(SchemaContext schemaContext) {
        this.schemaContext = schemaContext;
    }

    @Override
    public Optional<NormalizedNode<?, ?>> selectFromDataStructure(DataContainerChild<? extends YangInstanceIdentifier.PathArgument, ?> data, YangInstanceIdentifier path) {
        return NormalizedNodes.findNode(data, (Iterable)path.getPathArguments());
    }

    @Override
    public AnyXmlNode createEditConfigStructure(Optional<NormalizedNode<?, ?>> data, YangInstanceIdentifier dataPath, Optional<ModifyAction> operation) {
        return NetconfMessageTransformUtil.createEditConfigAnyxml(this.schemaContext, dataPath, operation, data);
    }

    @Override
    public DataContainerChild<?, ?> toFilterStructure(YangInstanceIdentifier path) {
        return NetconfMessageTransformUtil.toFilterStructure(path, this.schemaContext);
    }
}

